<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if (session_status() === PHP_SESSION_NONE) session_start();

$task_id     = $_POST['task_id'] ?? null;
$template_id = $_POST['template_id'] ?? null;
$user_id     = $_SESSION['user']['id'] ?? null;
$left        = $_POST['left'] ?? '100px';
$top         = $_POST['top'] ?? '100px';
$width       = intval($_POST['width'] ?? 150);

if (!$task_id || !$template_id || !$user_id || !$left || !$top) {
  die('❌ بيانات ناقصة');
}

// ✅ تحديد مسارات الملفات
$html_content = $_POST['html_content'] ?? '';
$custom_path  = "../templates/html/task_{$task_id}_template_{$template_id}.html";
$default_path = "../templates/html/{$template_id}.html";

// ✅ حفظ التعديلات إن وجدت في النسخة الخاصة بالمهمة
if ($html_content && $template_id && $task_id) {
  file_put_contents($custom_path, $html_content);
} else {
  // ✅ قراءة النموذج: نسخة خاصة أو نسخة عامة
  if (file_exists($custom_path)) {
    $html_content = file_get_contents($custom_path);
  } elseif (file_exists($default_path)) {
    $html_content = file_get_contents($default_path);
  } else {
    die('❌ ملف HTML غير موجود');
  }
}

// ✅ تعويض القيم إن وجدت
$values = json_decode($_POST['values'] ?? '{}', true);
foreach ($values as $key => $val) {
  $pattern = '/<span data-placeholder="' . preg_quote($key, '/') . '">.*?<\/span>/';
  $replacement = "<span data-placeholder=\"$key\">$val</span>";
  $html_content = preg_replace($pattern, $replacement, $html_content);
}

// ✅ جلب توقيع المستخدم
$signStmt = $conn->prepare("SELECT signature_path FROM users WHERE id = ?");
$signStmt->execute([$user_id]);
$user = $signStmt->fetch(PDO::FETCH_ASSOC);

if (!$user || empty($user['signature_path'])) {
  die('❌ لم يتم العثور على توقيع المستخدم.');
}

$signature_url = realpath('../uploads/signatures/' . $user['signature_path']);
if (!$signature_url || !file_exists($signature_url)) {
  die('❌ ملف التوقيع غير موجود فعليًا.');
}
$signature_url = 'file:///' . str_replace('\\', '/', $signature_url);

// ✅ إدراج التوقيع في الـ HTML
$signature_html = "<img src='{$signature_url}' style='position: absolute; left: {$left}px; top: {$top}px; width: {$width}px; height: auto;'>";

if (strpos($html_content, '{{signature}}') !== false) {
  $html_content = str_replace('{{signature}}', $signature_html, $html_content);
} else {
  $html_content = str_replace('</body>', $signature_html . '</body>', $html_content);
}

// ✅ توليد PDF من HTML
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('defaultFont', 'dejavusans');

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html_content, 'UTF-8');
$dompdf->setPaper('A4');
$dompdf->render();

// ✅ حفظ PDF
$filename = 'task_' . $task_id . '_signed_' . time() . '.pdf';
$pdf_output_path = "../uploads/" . $filename;
file_put_contents($pdf_output_path, $dompdf->output());

// ✅ تسجيله كمرفق للمهمة
$stmt = $conn->prepare("INSERT INTO attachments (task_id, file_path, uploaded_by) VALUES (?, ?, ?)");
$stmt->execute([$task_id, 'uploads/' . $filename, $user_id]);

echo "✅ تم توقيع النموذج ورفعه كمرفق PDF";
