<?php
session_start();
require_once '../config/db.php';
require_once '../auth.php';

$isAjax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';

// ... كودك فوق زي ماهو

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  try {
    $title         = trim($_POST['title'] ?? '');
    $description   = trim($_POST['description'] ?? '');
    $priority      = $_POST['priority'] ?? 'medium';
    $secret_level  = $_POST['secret_level'] ?? 'normal';
    $due_date      = $_POST['due_date'] ?? null;

    if (!$due_date) { die('❌ يجب إدخال تاريخ الاستحقاق.'); }

    $department_id = !empty($_POST['department_id']) ? (int)$_POST['department_id'] : null;
    $assigned_to   = !empty($_POST['assigned_to'])   ? (int)$_POST['assigned_to']   : null;
    $stage_id      = !empty($_POST['stage_id'])      ? (int)$_POST['stage_id']      : null;
    $custom_fields = $_POST['custom_fields'] ?? [];
    $project_id    = !empty($_POST['project_id'])    ? (int)$_POST['project_id']    : null;
    $task_type_id  = !empty($_POST['task_type_id'])  ? (int)$_POST['task_type_id']  : null;

    // 🧑‍💻 أهم سطرين: ناخذ آي دي المستخدم ونحفظه في created_by
    $creator_id    = (int)($_SESSION['user']['id'] ?? 0);
    if ($creator_id <= 0) { throw new Exception('لا يوجد مستخدم مسجّل دخول'); }

    // نستخدم ترانزاكشن احتياط
    $conn->beginTransaction();

    $stmt = $conn->prepare("
      INSERT INTO tasks
        (title, description, stage_id, priority, secret_level, due_date,
         department_id, assigned_to, created_by, created_at, is_deleted, project_id, task_type_id)
      VALUES
        (?,     ?,           ?,        ?,        ?,            ?, 
         ?,            ?,           ?,          NOW(),     0,          ?,          ?)
    ");

    $stmt->execute([
      $title,
      $description,
      $stage_id,
      $priority,
      $secret_level,
      $due_date,        // YYYY-MM-DD
      $department_id,
      $assigned_to,
      $creator_id,      // ✅ هنا نحفظ منشئ المهمة
      $project_id,
      $task_type_id
    ]);

    $task_id = (int)$conn->lastInsertId();

    // الحقول المخصصة
    if (!empty($custom_fields) && is_array($custom_fields)) {
      $stmtField = $conn->prepare("
        INSERT INTO task_custom_values (task_id, field_id, value) VALUES (?, ?, ?)
      ");
      foreach ($custom_fields as $field_id => $value) {
        $stmtField->execute([$task_id, (int)$field_id, (string)$value]);
      }
    }

    // المرفقات
    if (!empty($_FILES['attachments']['name'][0])) {
      $uploadDir = $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/uploads/';
      if (!is_dir($uploadDir)) { mkdir($uploadDir, 0775, true); }

      $attStmt = $conn->prepare("
        INSERT INTO attachments (task_id, file_path, uploaded_at)
        VALUES (?, ?, NOW())
      ");

      foreach ($_FILES['attachments']['name'] as $i => $fileName) {
        if ($_FILES['attachments']['error'][$i] !== UPLOAD_ERR_OK) continue;

        $tmpName  = $_FILES['attachments']['tmp_name'][$i];
        $safeName = time() . '_' . preg_replace('/[^A-Za-z0-9._-]/', '_', $fileName);
        $destPath = $uploadDir . $safeName;

        if (move_uploaded_file($tmpName, $destPath)) {
          $webPath = '/erp_task_system/uploads/' . $safeName; // مسار الويب الصحيح
          $attStmt->execute([$task_id, $webPath]);
        }
      }
    }

    $conn->commit();

    if ($isAjax) {
      ob_clean();
      header('Content-Type: application/json');
      echo json_encode(['success' => true, 'task_id' => $task_id]);
    } else {
      $_SESSION['success'] = '✅ تم حفظ المهمة بنجاح';
      echo "<script>
        if (window.parent) {
          window.parent.document.getElementById('addTaskModal').classList.add('hidden');
          window.parent.location.reload();
        }
      </script>";
      exit;
    }
    exit;

  } catch (Exception $e) {
    if ($conn->inTransaction()) { $conn->rollBack(); }
    if ($isAjax) {
      ob_clean();
      header('Content-Type: application/json');
      echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    } else {
      $_SESSION['success'] = '❌ حصل خطأ: ' . $e->getMessage();
      header("Location: list.php");
    }
    exit;
  }
}