<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'];
$currentUserColorId  = $user['color_id'];

// إضافة تصنيف جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add'])) {
  $name = trim($_POST['name']);
  if ($name) {
    $stmt = $conn->prepare("INSERT INTO task_types (name) VALUES (?)");
    $stmt->execute([$name]);
    header('Location: task_types.php');
    exit;
  }
}

// حذف تصنيف
if (isset($_GET['delete'])) {
  $id = intval($_GET['delete']);
  $conn->prepare("DELETE FROM task_types WHERE id = ?")->execute([$id]);
  header('Location: task_types.php');
  exit;
}

// تعديل تصنيف
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_id'])) {
  $id = intval($_POST['edit_id']);
  $name = trim($_POST['edit_name']);
  if ($name) {
    $conn->prepare("UPDATE task_types SET name = ? WHERE id = ?")->execute([$name, $id]);
    header('Location: task_types.php');
    exit;
  }
}

// جلب جميع التصنيفات
$types = $conn->query("SELECT * FROM task_types ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة تصنيفات المعاملات</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body, html {
      background-color: <?= $userThemeColor ?> !important;
      color: <?= $userThemeTextColor ?> !important;
    }
    .main-card, .shadow, .navbar, .card {
      background-color: <?= $userThemeNavColor ?> !important;
      color: <?= $userThemeTextColor ?> !important;
    }
    th, td {
      color: <?= $userThemeTextColor ?> !important;
    }
    .btn-main {
      background: #7be667;
      color: #000;
      border-radius: 8px;
      font-weight: bold;
    }
    .btn-main:hover {
      opacity: 0.85;
    }
    .edit-btn {
      background-color: #3b82f6;
      color: #fff;
      border-radius: 6px;
    }
    .edit-btn:hover {
      background-color: #2563eb;
    }
    .delete-btn {
      background-color: #ef4444;
      color: #fff;
      border-radius: 6px;
    }
    .delete-btn:hover {
      background-color: #dc2626;
    }
    input, select {
      color: #222 !important;
      background: #fff !important;
    }
  </style>
</head>
<body class="text-right">

  <!-- الناف بار -->
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<?php $helpHref = file_exists(__DIR__.'/help_task_types.php') ? 'help_task_types.php' : 'help.php'; ?>

<div class="max-w-lg mx-auto mt-14 main-card rounded p-6 shadow">
  <div class="flex items-center gap-2 mb-4">
    <h1 class="text-xl font-bold">إدارة تصنيفات المعاملات</h1>

    <!-- يسار في RTL -->
    <a href="<?= htmlspecialchars($helpHref) ?>" target="_blank" rel="noopener"
       class="btn-main px-4 py-2 rtl:mr-auto ltr:ml-auto no-print inline-flex items-center gap-1"
       title="تعليمات إدارة التصنيفات">❓ تعليمات</a>
  </div>
    <form method="POST" class="mb-6 flex gap-2">
      <input type="text" name="name" placeholder="اسم التصنيف" required class="border rounded px-3 py-2 flex-1">
      <button type="submit" name="add" class="btn-main px-4">إضافة</button>
    </form>
    <table class="w-full text-center border rounded overflow-hidden">
      <tr class="bg-gray-200 main-card">
        <th>#</th>
        <th>اسم التصنيف</th>
        <th>تعديل</th>
        <th>حذف</th>
      </tr>
      <?php foreach ($types as $type): ?>
        <tr class="bg-white">
          <td><?= $type['id'] ?></td>
          <td>
            <?php if (isset($_GET['edit']) && $_GET['edit'] == $type['id']): ?>
              <form method="POST" class="flex gap-2">
                <input type="hidden" name="edit_id" value="<?= $type['id'] ?>">
                <input type="text" name="edit_name" value="<?= htmlspecialchars($type['name']) ?>" class="border rounded px-2 py-1 flex-1">
                <button type="submit" class="edit-btn px-2">حفظ</button>
              </form>
            <?php else: ?>
              <?= htmlspecialchars($type['name']) ?>
            <?php endif; ?>
          </td>
          <td>
            <a href="?edit=<?= $type['id'] ?>" class="edit-btn px-2 py-1 text-sm">تعديل</a>
          </td>
          <td>
            <a href="?delete=<?= $type['id'] ?>" onclick="return confirm('متأكد؟')" class="delete-btn px-2 py-1 text-sm">حذف</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </table>
  </div>
</body>
</html>