<?php
require_once '../config/db.php';
require_once '../auth.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$task_id = $_GET['task_id'] ?? null;
if (!$task_id) {
  echo "<p class='text-red-600 text-center mt-10'>لم يتم تحديد المعاملة.</p>";
  exit;
}

// جلب بيانات المعاملة
$stmt = $conn->prepare("
  SELECT t.*, 
         d.name AS department_name, 
         u.name AS assigned_name, 
         s.name AS stage_name, 
         ty.name AS type_name,
         p.name AS project_name
  FROM tasks t
  LEFT JOIN departments d ON d.id = t.department_id
  LEFT JOIN users u ON u.id = t.assigned_to
  LEFT JOIN stages s ON s.id = t.stage_id
  LEFT JOIN task_types ty ON ty.id = t.task_type_id
  LEFT JOIN projects p ON p.id = t.project_id
  WHERE t.id = ?
");
$stmt->execute([$task_id]);
$task = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$task) {
  echo "<p class='text-red-600 text-center mt-10'>المعاملة غير موجودة.</p>";
  exit;
}

// جلب الحقول الإضافية
$customStmt = $conn->prepare("SELECT * FROM custom_fields WHERE department_id = ?");
$customStmt->execute([$task['department_id']]);
$customFields = $customStmt->fetchAll(PDO::FETCH_ASSOC);

$valuesStmt = $conn->prepare("SELECT * FROM task_custom_values WHERE task_id = ?");
$valuesStmt->execute([$task_id]);
$customValues = [];
foreach ($valuesStmt->fetchAll(PDO::FETCH_ASSOC) as $cv) {
  $customValues[$cv['field_id']] = $cv['value'];
}

// جلب المرفقات
$attachments = $conn->prepare("SELECT * FROM task_attachments WHERE task_id = ?");
$attachments->execute([$task_id]);
$files = $attachments->fetchAll(PDO::FETCH_ASSOC);

// جلب التعليقات
$comments = $conn->prepare("SELECT c.*, u.name AS author_name FROM task_comments c LEFT JOIN users u ON c.user_id = u.id WHERE c.task_id = ? ORDER BY c.created_at ASC");

$comments->execute([$task_id]);
$all_comments = $comments->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>عرض المعاملة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">



  <div id="printArea" class="max-w-3xl mx-auto bg-white shadow rounded-2xl p-8 mt-10">

    <h1 class="text-2xl font-bold mb-5 text-blue-900">تفاصيل المعاملة #<?= $task['id'] ?></h1>
    
    <div class="grid grid-cols-2 gap-4 text-gray-800 mb-6">
      <div><span class="font-semibold">العنوان:</span> <?= htmlspecialchars($task['title']) ?></div>
      <div><span class="font-semibold">الإدارة:</span> <?= htmlspecialchars($task['department_name']) ?></div>
      <div><span class="font-semibold">الموظف المسؤول:</span> <?= htmlspecialchars($task['assigned_name']) ?></div>
      <div><span class="font-semibold">المشروع:</span> <?= htmlspecialchars($task['project_name'] ?? '-') ?></div>
      <div><span class="font-semibold">المرحلة:</span> <?= htmlspecialchars($task['stage_name']) ?></div>
      <div><span class="font-semibold">التصنيف:</span> <?= htmlspecialchars($task['type_name']) ?></div>
      <div><span class="font-semibold">الأولوية:</span> <?= ($task['priority'] == 'high' ? 'عالية' : ($task['priority'] == 'medium' ? 'متوسطة' : 'منخفضة')) ?></div>
      <div><span class="font-semibold">السرية:</span> 
        <?php
        if ($task['secret_level'] == 'top_secret') echo "سرية جداً";
        elseif ($task['secret_level'] == 'secret') echo "سرية";
        else echo "عادية";
        ?>
      </div>
      <div><span class="font-semibold">تاريخ الإنشاء:</span> <?= $task['created_at'] ?></div>
      <div><span class="font-semibold">تاريخ الاستحقاق:</span> <?= $task['due_date'] != '0000-00-00' ? $task['due_date'] : '-' ?></div>
    </div>

    <div class="mb-4">
      <span class="font-semibold block mb-2">الوصف :</span>
      <div class="bg-gray-50 p-3 rounded text-gray-700"><?= nl2br(htmlspecialchars($task['description'])) ?></div>
    </div>
    
    <?php if (count($customFields)): ?>
      <div class="mb-5">
        <span class="font-semibold block mb-2">حقول إضافية:</span>
        <div class="grid grid-cols-2 gap-4">
          <?php foreach ($customFields as $field): ?>
            <div>
             <span class="font-medium"><?= htmlspecialchars($field['label'] ?? '') ?>:</span>
             <?= htmlspecialchars(isset($customValues[$field['id']]) ? $customValues[$field['id']] : '-') ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>

    <div class="mb-8">
      <h2 class="font-bold text-lg mb-2">📎 المرفقات</h2>
      <?php if (count($files)): ?>
        <div class="grid grid-cols-3 gap-3">
          <?php foreach ($files as $f): 
            $ext = strtolower(pathinfo($f['file_name'], PATHINFO_EXTENSION));
            $isImage = in_array($ext, ['jpg','jpeg','png','webp','gif']);
          ?>
            <div class="border rounded p-2 bg-gray-50 flex flex-col items-center">
              <?php if ($isImage): ?>
                <a href="../uploads/<?= htmlspecialchars($f['file_name']) ?>" target="_blank">
                  <img src="../uploads/<?= htmlspecialchars($f['file_name']) ?>" class="w-24 h-24 object-cover mb-1 rounded shadow">
                </a>
              <?php else: ?>
                <a href="../uploads/<?= htmlspecialchars($f['file_name']) ?>" target="_blank" class="text-blue-700 underline mb-1"><?= htmlspecialchars($f['original_name']) ?></a>
                <div class="text-xs text-gray-400"><?= strtoupper($ext) ?></div>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>
      <?php else: ?>
        <div class="text-gray-400">لا يوجد مرفقات للمعاملة.</div>
      <?php endif; ?>
    </div>
    
    <div class="mb-8">
      <h2 class="font-bold text-lg mb-2">💬 التعليقات</h2>
      <?php if (count($all_comments)): ?>
        <div class="space-y-3">
          <?php foreach ($all_comments as $c): ?>
            <div class="bg-gray-50 p-2 rounded">
              <div class="font-semibold text-sm text-blue-800"><?= htmlspecialchars($c['author_name']) ?></div>
              <div class="text-gray-700"><?= nl2br(htmlspecialchars($c['content'])) ?></div>
              <div class="text-xs text-gray-400"><?= $c['created_at'] ?></div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php else: ?>
        <div class="text-gray-400">لا توجد تعليقات بعد.</div>
      <?php endif; ?>
    </div>
  </div>
  
<div class="flex justify-center gap-3 mt-8">
  <button onclick="printDiv('printArea')" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
    🖨️ طباعة المعاملة
  </button>
  <a href="list.php" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
    رجوع إلى القائمة
  </a>
</div>


  <script>
    function printDiv(divId) {
      var printContents = document.getElementById(divId).innerHTML;
      var originalContents = document.body.innerHTML;
      document.body.innerHTML = printContents;
      window.print();
      document.body.innerHTML = originalContents;
      location.reload();
    }
  </script>

</body>
</html>
