<?php
require_once '../config/db.php';
require_once '../auth.php';

if (!in_array($_SESSION['user']['role'], ['admin', 'manager'])) {
  header("Location: ../unauthorized.php");
  exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
} else {
  $stmt = $conn->prepare("SELECT id, name FROM departments WHERE id = ?");
  $stmt->execute([$department_id]);
  $departments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$users = $conn->query("SELECT id, name, department_id FROM users WHERE can_sign = 1")->fetchAll(PDO::FETCH_ASSOC);
$stages = $conn->query("SELECT id, name, department_id FROM stages")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'] ?? '';
  $department_id = $role === 'admin' ? ($_POST['department_id'] ?? null) : $department_id;
  $stage_id = $_POST['stage_id'] ?? null;
  $signer_user_id = $_POST['signer_user_id'] ?? null;

  if (isset($_FILES['template_file']) && $_FILES['template_file']['error'] === 0) {
    $file_tmp = $_FILES['template_file']['tmp_name'];
    $file_name = uniqid() . '_' . basename($_FILES['template_file']['name']);

    // ✅ نحفظه في مجلد templates/word/
    $destination = '../templates/word/' . $file_name;

    // نتأكد أن المجلد موجود
    if (!is_dir('../templates/word')) {
      mkdir('../templates/word', 0777, true);
    }

    if (move_uploaded_file($file_tmp, $destination)) {
      $stmt = $conn->prepare("INSERT INTO templates (name, file_path, department_id, stage_id, signer_user_id) VALUES (?, ?, ?, ?, ?)");
      $stmt->execute([
        $name,
        'templates/word/' . $file_name,
        $department_id,
        $stage_id,
        $signer_user_id
      ]);

      $_SESSION['success'] = "✅ تم حفظ النموذج بنجاح.";
      header("Location: index.php");
      exit;
    } else {
      $error = "❌ فشل رفع الملف.";
    }
  } else {
    $error = "❌ لم يتم اختيار ملف أو هناك خطأ في الرفع.";
  }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إضافة نموذج</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-xl mx-auto">
    <h1 class="text-xl font-bold mb-4">➕ إضافة نموذج جديد</h1>

    <?php if (!empty($error)): ?>
      <div class="bg-red-100 text-red-700 p-3 mb-4 rounded shadow"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data" class="space-y-4 bg-white p-4 rounded shadow">
      <div>
        <label class="block mb-1 text-sm">اسم النموذج</label>
        <input type="text" name="name" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block mb-1 text-sm">الإدارة</label>
        <select name="department_id" required class="w-full border rounded px-3 py-2">
          <option value="">-- اختر --</option>
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">المرحلة (اختياري)</label>
        <select name="stage_id" id="stageSelect" class="w-full border rounded px-3 py-2">
          <option value="">-- بدون --</option>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">الموقّع (اختياري)</label>
        <select name="signer_user_id" class="w-full border rounded px-3 py-2">
          <option value="">-- بدون --</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">ملف النموذج (.docx)</label>
        <input type="file" name="template_file" accept=".docx" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">💾 حفظ</button>
        <a href="index.php" class="ml-4 text-gray-600 hover:underline">🔙 رجوع</a>
      </div>
    </form>
  </div>

  <script>
    const departmentSelect = document.querySelector('[name="department_id"]');
    const stageSelect = document.getElementById('stageSelect');

    departmentSelect.addEventListener('change', function () {
      const depId = this.value;
      stageSelect.innerHTML = '<option value="">-- تحميل المراحل... --</option>';

      fetch('../templates/get_stages_by_department.php?department_id=' + depId)
        .then(res => res.json())
        .then(data => {
          stageSelect.innerHTML = '<option value="">-- بدون --</option>';
          data.forEach(stage => {
            const opt = document.createElement('option');
            opt.value = stage.id;
            opt.textContent = stage.name;
            stageSelect.appendChild(opt);
          });
        });
    });
  </script>
</body>
</html>
