<?php
require_once '../config/db.php';
require_once '../auth.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

if (!in_array($_SESSION['user']['role'], ['admin', 'manager'])) {
  header("Location: ../unauthorized.php");
  exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeNavColor = $color['nav_color'];
$chartColor = $color['chart_color'];
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];

if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
} else {
  $stmt = $conn->prepare("SELECT id, name FROM departments WHERE id = ?");
  $stmt->execute([$department_id]);
  $departments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$users = $conn->query("SELECT id, name, department_id FROM users WHERE can_sign = 1")->fetchAll(PDO::FETCH_ASSOC);
$stages = $conn->query("SELECT id, name, department_id FROM stages")->fetchAll(PDO::FETCH_ASSOC);

// حمل HTML جاهز مسبقًا (قابل للتعديل)
$prefilled_html = file_exists('../templates/html/converted_template.html') ? file_get_contents('../templates/html/converted_template.html') : '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'] ?? '';
  $department_id = $role === 'admin' ? ($_POST['department_id'] ?? null) : $department_id;
  $stage_id = $_POST['stage_id'] ?? null;
  $signer_user_id = $_POST['signer_user_id'] ?? null;
  $html_content = $_POST['html_content'] ?? '';

  if ($html_content) {
    $template_id = uniqid();
    $file_name = "template_" . $template_id . ".html";
    $save_path = "../templates/html/" . $file_name;

    if (!is_dir("../templates/html")) {
      mkdir("../templates/html", 0777, true);
    }

    file_put_contents($save_path, $html_content);

    $stmt = $conn->prepare("INSERT INTO templates (name, file_path, department_id, stage_id, signer_user_id) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([
      $name,
      "templates/html/" . $file_name,
      $department_id,
      $stage_id,
      $signer_user_id
    ]);

    $_SESSION['success'] = "✅ تم حفظ النموذج بنجاح.";
    header("Location: index.php");
    exit;
  } else {
    $error = "❌ الرجاء كتابة محتوى النموذج.";
  }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>إضافة نموذج</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>


  <style>
    body,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,
    option,
    h2,
    select,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

    .secondary-text {
      color: <?php echo $userThemeSecondTextColor; ?> !important;
    }

    .gr {
      color: #7be667;
    }

    .bl {
      color: #4d70f4;
    }

    .text-button {
      color: #ffffff !important;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .move-button:hover {
      background-color: rgb(19, 11, 57) !important;
    }

    .view-tasks {
      background-color: none !important;
      /* background-color: rgb(19, 11, 57) !important; */
      border: 3px solid rgb(110, 118, 56) !important;
      border-radius: 15px !important;
      color: <?= ($currentUserColorId == 3) ?  htmlspecialchars('#ffffff') : htmlspecialchars('#000000'); ?> !important;

    }

    .view-tasks:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
      border: 3px solid <?= ($currentUserColorId == 3) ?  htmlspecialchars('#ffffff') : htmlspecialchars('#130B39'); ?> !important;
      color: <?= ($currentUserColorId == 3) ?  htmlspecialchars('#ffffff') : htmlspecialchars('#000000'); ?> !important;

    }
  </style>
</head>

<body class=" p-6">
  <div class="max-w-3xl mx-auto">
    <h1 class="text-xl font-bold mb-4">➕ إضافة نموذج جديد</h1>

    <?php if (!empty($error)): ?>
      <div class="bg-red-100 text-red-700 p-3 mb-4 rounded shadow"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-4 bg-white p-4 rounded shadow">
      <div>
        <label class="block mb-1 text-sm">اسم النموذج</label>
        <input type="text" name="name" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block mb-1 text-sm">الإدارة</label>
        <select name="department_id" id="departmentSelect" required class="card w-full border rounded px-3 py-2">
          <option value="">-- اختر --</option>
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">المرحلة (اختياري)</label>
        <select name="stage_id" id="stageSelect" class="card w-full border rounded px-3 py-2">
          <option value="">-- بدون --</option>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">الموقّع (اختياري)</label>
        <select name="signer_user_id" class="card w-full border rounded px-3 py-2">
          <option value="">-- بدون --</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">📂 أو اختر نموذج HTML جاهز</label>
        <input type="file" accept=".html" id="html_file_input" class="w-full border rounded px-3 py-2 bg-gray-50">
      </div>

      <div>
        <label class="block mb-1 text-sm">محتوى النموذج</label>
        <textarea name="html_content" id="html_content" rows="10" class="w-full border rounded"><?= htmlspecialchars($prefilled_html) ?></textarea>
      </div>

      <div>
        <button type="submit" class="move-button text-button text-white px-4 py-2 rounded">💾 حفظ</button>
        <a href="index.php" class="ml-4 text view-tasks">🔙 رجوع</a>
      </div>
    </form>
  </div>

  <script>
    // تحميل ملف HTML وتعبئة المحرر
    document.getElementById('html_file_input').addEventListener('change', function(e) {
      const file = e.target.files[0];
      if (!file) return;

      const reader = new FileReader();
      reader.onload = function(e) {
        const htmlContent = e.target.result;
        if (tinymce.activeEditor) {
          tinymce.activeEditor.setContent(htmlContent);
        } else {
          document.getElementById('html_content').value = htmlContent;
        }

      };
      reader.readAsText(file, 'UTF-8');
    });
  </script>
  <script>
    departmentSelect.addEventListener('change', function() {
      const departmentId = this.value;
      stageSelect.innerHTML = '<option value="">-- تحميل المراحل... --</option>';

      fetch('../templates/get_stages_by_department.php?department_id=' + departmentId)
        .then(response => response.json())
        .then(data => {
          stageSelect.innerHTML = '<option value="">-- بدون --</option>';
          data.forEach(stage => {
            const option = document.createElement('option');
            option.value = stage.id;
            option.textContent = stage.name;
            stageSelect.appendChild(option);
          });
        })
        .catch(error => {
          stageSelect.innerHTML = '<option value="">-- فشل التحميل --</option>';
          console.error('Error fetching stages:', error);
        });
    });
  </script>
  <script>
    tinymce.init({
      selector: '#html_content',
      height: 500,
      directionality: 'rtl',
      language: 'ar',
      plugins: 'code preview table link lists image fullscreen',
      toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image table | code preview fullscreen',
      menubar: 'file edit view insert format tools table',
      content_style: "body { font-family: Tahoma, sans-serif; font-size: 14px; direction: rtl; }"
    });
  </script>


</body>

</html>