<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$task_id = $_POST['task_id'] ?? null;
$template_id = $_POST['template_id'] ?? null;
$user_id = $_SESSION['user']['id'] ?? null;
$htmlFile = $_SESSION['html_preview'] ?? null;

if (!$task_id || !$template_id || !$user_id || !$htmlFile || !file_exists($htmlFile)) {
    die('❌ بيانات غير مكتملة أو المعاينة غير متوفرة.');
}

// قراءة محتوى HTML
$htmlContent = file_get_contents($htmlFile);

// حذف الملف المؤقت (اختياري)
unlink($htmlFile);
unset($_SESSION['html_preview'], $_SESSION['preview_task_id'], $_SESSION['preview_template_id']);

// تحويل HTML إلى PDF باستخدام Dompdf
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($htmlContent, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$filename = 'task_' . $task_id . '_signed_' . time() . '.pdf';
$fullPath = __DIR__ . '/../uploads/' . $filename;
file_put_contents($fullPath, $dompdf->output());

// حفظ كمرفق
$stmt = $conn->prepare("INSERT INTO attachments (task_id, file_path, uploaded_by) VALUES (?, ?, ?)");
$stmt->execute([$task_id, 'uploads/' . $filename, $user_id]);

// ✅ رسالة نجاح
echo "<p style='text-align:center; font-size:18px; margin-top:50px;'>✅ تم تأكيد التوقيع وحفظه كمرفق.</p>";
echo "<p style='text-align:center;'><a href='../tasks/list.php'>🔙 الرجوع للمهام</a></p>";
exit;
