<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';

use PhpOffice\PhpWord\TemplateProcessor;
use PhpOffice\PhpWord\IOFactory;

// دالة هجري محلي
function getHijriDateLocal($timestamp = null) {
  if (is_null($timestamp)) $timestamp = time();
  $jd = gregoriantojd(date('m', $timestamp), date('d', $timestamp), date('Y', $timestamp));
  $hijri = jdtojewish($jd, true);
  list($h_month, $h_day, $h_year) = explode('/', $hijri);
  return "$h_day-$h_month-$h_year";
}

// استقبال المتغيرات
$template_id = $_GET['template_id'] ?? null;
$task_id = $_GET['task_id'] ?? 'غير محدد';

if (!$template_id) {
  die("❌ رقم النموذج غير موجود");
}

// جلب بيانات النموذج
$stmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$template_id]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$template) {
  die("❌ لم يتم العثور على النموذج");
}

// مسارات
$file_path = $template['file_path'];
$input_path = __DIR__ . "/../" . $template['file_path'];
echo "🔍 التحقق من الملف في: <code>$input_path</code><br>";

if (!$input_path || !file_exists($input_path)) {
  die("❌ ملف وورد غير موجود: $input_path");
}
$temp_docx = "../temp/temp_filled.docx";
$output_path = "../templates/html/{$template_id}.html";

// تحقق من وجود ملف Word الأصلي
if (!file_exists($input_path)) {
  die("❌ ملف وورد غير موجود: $input_path");
}

// ✅ تعبئة المتغيرات داخل ملف Word
$templateProcessor = new TemplateProcessor($input_path);

$gregorianDate = date('Y-m-d');
$hijriDate = getHijriDateLocal();
$signaturePath = '../signatures/user_signature.png';

$templateProcessor->setValue('current_date', $gregorianDate);
$templateProcessor->setValue('hijri_date', $hijriDate);
$templateProcessor->setValue('task_id', $task_id);

if (file_exists($signaturePath)) {
  $templateProcessor->setImageValue('signature', [
    'path' => $signaturePath,
    'width' => 120,
    'height' => 60,
    'ratio' => true
  ]);
} else {
  $templateProcessor->setValue('signature', '[لا يوجد توقيع]');
}

// حفظ الملف المؤقت بعد تعبئة القيم
$templateProcessor->saveAs($temp_docx);

// ✅ تحويل النسخة المعوضة إلى HTML
try {
  $phpWord = IOFactory::load($temp_docx);
  $htmlWriter = IOFactory::createWriter($phpWord, 'HTML');

  if (!is_dir("../templates/html")) {
    mkdir("../templates/html", 0777, true);
  }

  $htmlWriter->save($output_path);

  // تعديل الاتجاه RTL
  $html = file_get_contents($output_path);
  $rtlStyle = '
  <style>
    body {
      direction: rtl;
      text-align: right;
      font-family: "Arial", sans-serif;
    }
  </style>
  ';
  $html = str_replace('</head>', $rtlStyle . '</head>', $html);
  file_put_contents($output_path, $html);

  echo "✅ تم التحويل بنجاح. <a href='$output_path' target='_blank'>عرض HTML</a>";

} catch (Exception $e) {
  echo "❌ خطأ في التحويل: " . $e->getMessage();
}
