<?php
require_once '../config/db.php';
require_once '../auth.php';

if (!in_array($_SESSION['user']['role'], ['admin', 'manager'])) {
  header("Location: ../unauthorized.php");
  exit;
}

$id = $_GET['id'] ?? null;
if (!$id) {
  $_SESSION['error'] = "❌ لم يتم تحديد النموذج.";
  header("Location: index.php");
  exit;
}

// جلب مسار الملف لحذفه من السيرفر
$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

if ($role === 'admin') {
  $stmt = $conn->prepare("SELECT file_path FROM templates WHERE id = ?");
  $stmt->execute([$id]);
} else {
  $stmt = $conn->prepare("SELECT file_path FROM templates WHERE id = ? AND department_id = ?");
  $stmt->execute([$id, $department_id]);
}

$template = $stmt->fetch(PDO::FETCH_ASSOC);

if ($template) {
  // حذف الملف من السيرفر
  if (file_exists($template['file_path'])) {
    unlink($template['file_path']);
  }

  // حذف السطر من قاعدة البيانات
  $delete = $conn->prepare("DELETE FROM templates WHERE id = ?");
  $delete->execute([$id]);

  $_SESSION['success'] = "✅ تم حذف النموذج بنجاح.";
} else {
  $_SESSION['error'] = "❌ النموذج غير موجود.";
}

header("Location: index.php");
exit;
