<?php
require_once '../config/db.php';

$template_id = $_GET['template_id'] ?? null;
if (!$template_id || !is_numeric($template_id)) {
  die('❌ رقم النموذج غير صالح.');
}

$stmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$template_id]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$template) {
  die('❌ النموذج غير موجود.');
}

$file_path = "../" . $template['file_path']; // تأكد أن عندك عمود اسمه file_path في جدول templates

if (!file_exists($file_path)) {
  die('❌ الملف غير موجود.');
}

header('Content-Description: File Transfer');
header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($file_path));
readfile($file_path);
exit;
