<?php
require_once '../config/db.php';
require_once '../auth.php';

if (!in_array($_SESSION['user']['role'], ['admin', 'manager'])) {
  header("Location: ../unauthorized.php");
  exit;
}

$id = $_GET['id'] ?? null;
if (!$id) exit('رقم النموذج غير موجود');

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

if ($role === 'admin') {
  $templateStmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
  $templateStmt->execute([$id]);
} else {
  $templateStmt = $conn->prepare("SELECT * FROM templates WHERE id = ? AND department_id = ?");
  $templateStmt->execute([$id, $department_id]);
}

$template = $templateStmt->fetch(PDO::FETCH_ASSOC);
if (!$template) exit('❌ النموذج غير موجود أو ليس لديك صلاحية لتعديله.');


if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
} else {
  $stmt = $conn->prepare("SELECT id, name FROM departments WHERE id = ?");
  $stmt->execute([$department_id]);
  $departments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
$users = $conn->query("SELECT id, name FROM users WHERE can_sign = 1")->fetchAll(PDO::FETCH_ASSOC);
$stages = $conn->query("SELECT id, name FROM stages")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'] ?? '';
$department_id = $role === 'admin' ? ($_POST['department_id'] ?? null) : $department_id;
  $stage_id = $_POST['stage_id'] ?? null;
  $signer_user_id = $_POST['signer_user_id'] ?? null;

  $file_path = $template['file_path'];

  // إذا فيه ملف جديد مرفوع، نستبدله
  if (isset($_FILES['template_file']) && $_FILES['template_file']['error'] === 0) {
    $file_tmp = $_FILES['template_file']['tmp_name'];
    $file_name = uniqid() . '_' . basename($_FILES['template_file']['name']);
    $destination = '../templates/' . $file_name;

    if (move_uploaded_file($file_tmp, $destination)) {
      $file_path = $destination;
    }
  }

  $stmt = $conn->prepare("UPDATE templates SET name=?, file_path=?, department_id=?, stage_id=?, signer_user_id=? WHERE id=?");
  $stmt->execute([$name, $file_path, $department_id, $stage_id, $signer_user_id, $id]);

  $_SESSION['success'] = "✅ تم تحديث النموذج بنجاح.";
  header("Location: index.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل النموذج</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-xl mx-auto">
    <h1 class="text-xl font-bold mb-4">✏️ تعديل النموذج</h1>

    <form method="POST" enctype="multipart/form-data" class="space-y-4 bg-white p-4 rounded shadow">
      <div>
        <label class="block mb-1 text-sm">اسم النموذج</label>
        <input type="text" name="name" value="<?= htmlspecialchars($template['name']) ?>" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block mb-1 text-sm">الإدارة</label>
        <select name="department_id" required class="w-full border rounded px-3 py-2">
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $template['department_id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($dep['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">المرحلة</label>
        <select name="stage_id" class="w-full border rounded px-3 py-2">
          <option value="">-- بدون --</option>
          <?php foreach ($stages as $s): ?>
            <option value="<?= $s['id'] ?>" <?= $s['id'] == $template['stage_id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($s['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">الموقّع</label>
        <select name="signer_user_id" class="w-full border rounded px-3 py-2">
          <option value="">-- بدون --</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= $u['id'] ?>" <?= $u['id'] == $template['signer_user_id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($u['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 text-sm">استبدال ملف النموذج (اختياري)</label>
        <input type="file" name="template_file" accept=".docx" class="w-full border rounded px-3 py-2">
        <p class="text-sm text-gray-500 mt-1">الملف الحالي: <a href="<?= $template['file_path'] ?>" target="_blank" class="text-blue-600 hover:underline">عرض</a></p>
      </div>

      <div>
        <button type="submit" class=" text-white px-4 py-2 rounded hover:bg-green-700" style="background-color: #7be667;">💾 تحديث</button>
        <a href="index.php" class="ml-4 text-gray-600 hover:underline">🔙 رجوع</a>
      </div>
    </form>
  </div>
</body>
</html>
