<?php
/* /erp_task_system/templates/help.php */
session_start();
ini_set('display_errors',1);
ini_set('startup_errors',1);
error_reporting(E_ALL);

require_once '../config/db.php';

/* توحيد التفويض */
$authz = __DIR__ . '/../authorize.php';
$auth  = __DIR__ . '/../auth.php';
if (file_exists($authz)) require_once $authz;
if (file_exists($auth))  require_once $auth;

/* السماح للأدمن والمدير فقط */
if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'] ?? 'user', ['admin','manager'])) {
  session_unset(); session_destroy();
  header('Location: ../unauthorized.php'); exit;
}

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code'          => '#0b1023',
  'second_text_color' => '#e9eefb',
  'text_color'        => '#e9eefb',
  'nav_color'         => '#121b35',
  'chart_color'       => 'rgba(111,125,251,.8)',
];

$userThemeColor           = $color['hex_code'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeTextColor       = $color['text_color'];
$userThemeNavColor        = $color['nav_color'];

/* روابط ذكية حسب الموجود */
function firstExistingRelative(array $cands): string {
  foreach ($cands as $p) { if (file_exists(__DIR__.'/'.$p)) return $p; }
  return $cands[0] ?? '#';
}
$indexHref      = firstExistingRelative(['index.php','list.php']);
$addHref        = firstExistingRelative(['add.php']);
$addHtmlHref    = firstExistingRelative(['add_template_html.php','add_html.php']);
$reportHref     = firstExistingRelative(['../report_builder.php','../reports/report_builder.php']);
$kanbanHref     = firstExistingRelative(['../kanban.php','../kanban_new.php']);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>📘 تعليمات إدارة النماذج</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
:root{
  --bg: <?= $userThemeColor ?>;
  --panel: <?= $userThemeNavColor ?>;
  --ink: <?= $userThemeTextColor ?>;
  --ink-2: <?= $userThemeSecondTextColor ?>;
  --ring:#c7d2fe; --ok:#16a34a; --warn:#f59e0b; --err:#ef4444;
  --primary:#6f7dfb; --muted:#9aa3b2;
}
body{ background:var(--bg); color:var(--ink); }
.card{ background:var(--panel); border:1px solid rgba(255,255,255,.07); border-radius:1rem; }
.section{ padding:1rem; }
.h1{ font-size:1.5rem; font-weight:800; }
.h2{ font-size:1.125rem; font-weight:800; }
.lead{ color:var(--ink-2); opacity:.95 }
.toc a{ display:block; padding:.5rem .75rem; border-radius:.6rem; background:rgba(255,255,255,.05); }
.toc a:hover{ background:rgba(255,255,255,.1); }
.callout{ border-radius:.75rem; padding:.75rem .9rem; background:rgba(255,255,255,.06); border:1px dashed rgba(255,255,255,.2); }
.callout.ok{ border-color:rgba(22,163,74,.45) }
.callout.warn{ border-color:rgba(245,158,11,.45) }
.callout.err{ border-color:rgba(239,68,68,.45) }
.badge{ display:inline-flex; align-items:center; gap:.35rem; font-size:.8rem; padding:.25rem .55rem; border-radius:999px; background:rgba(255,255,255,.09) }
.kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; background:rgba(255,255,255,.08); padding:.1rem .45rem; border-radius:.4rem; font-size:.85em; }
.anchor{ scroll-margin-top:7rem }

/* ===== طباعة A4 ===== */
@page { size: A4 portrait; margin: 10mm 10mm 14mm 10mm; }
.print-only{ display:none; }
@media print{
  :root{ --panel:#fff; --ink:#111827; --ink-2:#374151; }
  html, body{ background:#fff !important; color:#111827 !important;
    -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  body{ font-size:11pt; line-height:1.55; counter-reset: page; }
  .no-print, nav, .navbar, [onclick], a[href^="javascript:"], #contact{ display:none !important; }

  .print-header, .print-footer{
    display:block !important; position:fixed; left:0; right:0; background:#fff; color:#6b7280;
  }
  .print-header{ top:0; padding:6px 10mm; border-bottom:1px solid #e5e7eb; }
  .print-footer{ bottom:0; padding:6px 10mm; border-top:1px solid #e5e7eb; }
  .print-footer .page:after{ content: counter(page); }
  .print-footer .pages:after{ content: counter(pages); }

  .container-print{ margin-top:22mm !important; margin-bottom:18mm !important; }
  .max-w-5xl{ max-width:100% !important; }
  .card{ background:#fff !important; border:1px solid #e5e7eb !important; box-shadow:none !important; }
  .section{ padding:.6rem .8rem !important; }
  header.card.section{ padding:.8rem 1rem !important; }
  .h1{ font-size:16pt !important; margin:0 0 .25rem !important; }
  .h2{ font-size:13pt !important; margin:0 0 .2rem !important; }
  nav.toc{ display:block !important; columns:3; column-gap:8mm; }
  .toc a{ background:transparent !important; padding:.15rem 0 !important; break-inside:avoid; }
  .callout, .card, .anchor{ break-inside:avoid; page-break-inside:avoid; }
  .page-break{ break-before:page; page-break-before:always; }
}
  </style>
</head>
<body>
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>
  <div class="h-20"></div>

<div class="max-w-5xl mx-auto px-4 space-y-6 container-print">

  <!-- ترويسة الطباعة -->
  <div class="print-only print-header">
    <div style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;align-items:center;gap:10px;">
        <img src="/erp_task_system/assets/img/fav.png" alt="ASRA" style="height:24px;width:auto;">
        <strong>تعليمات إدارة النماذج</strong>
      </div>
      <div style="font-size:10pt"><?= date('Y-m-d H:i') ?></div>
    </div>
  </div>

  <!-- تذييل الطباعة -->
  <div class="print-only print-footer">
    <div style="display:flex;align-items:center;justify-content:space-between;">
      <strong>أسرع لتقنية المعلومات — 98RL</strong>
      <strong>صفحة <strong class="page"></strong> / <strong class="pages"></strong></strong>
    </div>
  </div>

  <!-- رأس -->
  <header class="card section">
    <div class="flex items-start justify-between gap-3">
      <div>
        <h1 class="h1">📘 تعليمات استخدام إدارة النماذج</h1>
        <p class="lead mt-1">
          الصفحة هذي لإدارة قوالب المستندات (HTML/ملفات مرفوعة)، مع ربطها بالإدارة والمرحلة والموقّع،
          وتحريرها أو حذفها. تقدر تضيف نموذج جديد أو HTML جاهز حسب حاجتك.
        </p>
      </div>
      <div class="no-print flex items-center gap-2">
        <a href="<?= htmlspecialchars($indexHref) ?>" class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700">⬅️ رجوع للنماذج</a>
        <button onclick="window.print()" class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700">🖨️ طباعة</button>
      </div>
    </div>
  </header>

  <!-- فهرس -->
  <nav class="card section toc grid sm:grid-cols-2 lg:grid-cols-3 gap-2">
    <a href="#what">وش تسوي الصفحة؟</a>
    <a href="#roles">الأدوار والصلاحيات</a>
    <a href="#add">إضافة نموذج</a>
    <a href="#fields">الحقول والربط</a>
    <a href="#table">أعمدة الجدول</a>
    <a href="#actions">الخيارات (تعديل/حذف/تحميل)</a>
    <a href="#preview">المعاينة والتوافق</a>
    <a href="#tips">نصائح ضبط الجودة</a>
    <a href="#faq">مشاكل شائعة</a>
    <a href="#links">روابط سريعة</a>
  </nav>

  <!-- وش تسوي الصفحة -->
  <section id="what" class="card section anchor">
    <h2 class="h2 mb-2">وش تسوي الصفحة؟</h2>
    <p>
      تعرض كل النماذج المتاحة حسب صلاحيتك. تقدر تضيف/تعدّل/تحذف قوالب، وتربط كل نموذج بإدارة ومرحلة
      وموقّع معيّن عشان يظهر زر عرض/توقيع النموذج في تفاصيل المعاملة إذا وصلت المرحلة المرتبطة.
    </p>
  </section>

  <!-- الأدوار -->
  <section id="roles" class="card section anchor">
    <h2 class="h2 mb-2">الأدوار والصلاحيات</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong class="badge">المدير العام</strong>: يشوف كل الإدارات ويقدر يفلتر بالقائمة العلوية.</li>
      <li><strong class="badge">مدير الادارة</strong>: يشوف نماذج إدارته فقط.</li>
    </ul>
  </section>

  <!-- إضافة -->
  <section id="add" class="card section anchor">
    <h2 class="h2 mb-2">إضافة نموذج</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>➕ إضافة نموذج</strong> : إضافة نموذج عادي مع تحديد الحقول.</li>
      <li><strong>➕ إضافة HTML</strong> :رفع/لصق HTML جاهز بنفس تنسيقه.</li>
    </ul>
    <div class="callout ok mt-2">
      تلميح: لو عندك ملف Word محوّل لـ HTML، ارفعه هنا وتأكد إن المسارات (صور/CSS) مضبوطة.
    </div>
  </section>


  <!-- أعمدة الجدول -->
  <section id="table" class="card section anchor">
    <h2 class="h2 mb-2">أعمدة الجدول</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>#</strong> ترقيم تسلسلي بالواجهة.</li>
      <li><strong>اسم النموذج</strong>، <strong>الإدارة</strong>، <strong>المرحلة</strong>، <strong>الموقّع</strong>.</li>
      <li><strong>ملف النموذج</strong>: زر <strong class="kbd">📥 تحميل</strong> يفتح/ينزّل الملف من <strong class="kbd">file_path</strong>.</li>
      <li><strong>خيارات</strong>: تعديل ✏️ — حذف 🗑.</li>
    </ul>
  </section>

  <!-- الخيارات -->
  <section id="actions" class="card section anchor">
    <h2 class="h2 mb-2">الخيارات (تعديل/حذف/تحميل)</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>✏️ تعديل</strong>: يفتح لتعديل الحقول أو المسار.</li>
      <li><strong>🗑 حذف</strong>: يتطلب تأكيد قبل التنفيذ — انتبه قبل حذف نموذج يستخدم بالإجراءات.</li>
      <li><strong>📥 تحميل</strong>: يفيد للمعاينة السريعة أو تنزيل الملف.</li>
    </ul>
  </section>

  <!-- المعاينة -->
  <section id="preview" class="card section anchor">
    <h2 class="h2 mb-2">المعاينة والتوافق</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>الخطوط: يفضّل تضمين خطوط عربية مناسبة أو الاعتماد على خطوط النظام.</li>
    </ul>
  </section>

  <!-- نصائح -->
  <section id="tips" class="card section anchor">
    <h2 class="h2 mb-2">نصائح ضبط الجودة</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>سمِّ النماذج بأسماء واضحة (مثال: <em>خطاب تعريف — موارد بشرية</em>).</li>
      <li>إصدارات: لو تعدّل كثير، احتفظ بنسخة قديمة باسم مختلف (v2, v3) لسهولة الرجوع.</li>
      <li>التجربة: جرّب فتح النموذج في مهمة فعلية للوصول للزر وتحقق من التوقيع/الطباعة.</li>
    </ul>
  </section>

  <!-- مشاكل شائعة -->
  <section id="faq" class="card section anchor">
    <h2 class="h2 mb-2">مشاكل شائعة</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>النموذج ما يظهر في المعاملة؟ → تأكد من <strong class="kbd">stage_id</strong> وربطه بالمرحلة الصحيحة.</li>
      <li>المدير ما يشوف كل النماذج؟ → التصميم مقصود: المدير يشوف نماذج إدارته فقط.</li>
    </ul>
  </section>

  <!-- تواصل -->
  <section id="contact" class="py-12 md:py-16">
    <div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
      <div class="card rounded-2xl p-6">
        <h2 class="text-xl md:text-2xl font-bold">خلّنا نتواصل</h2>
        <form id="contactForm" class="mt-4 grid gap-3">
          <input id="c_name"  class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
          <input id="c_email" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
          <input id="c_phone" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
          <textarea id="c_msg" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
          <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
          <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
        </form>
      </div>
      <div>
        <h3 class="text-2xl font-bold">بيانات التواصل</h3>
        <ul class="mt-4 space-y-2" style="color:var(--muted)">
          <li>الموقع: 98RL.LINK</li>
          <li>البريد: 98rl@98rl.link</li>
          <li>واتساب: +966535500241</li>
        </ul>
        <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">تواصل واتساب مباشر</a>
      </div>
    </div>
  </section>

  <!-- روابط سريعة -->
  <section id="links" class="card section anchor">
    <h2 class="h2 mb-2">روابط سريعة</h2>
    <div class="flex flex-wrap gap-2">
      <a class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700" href="<?= htmlspecialchars($indexHref) ?>">📄 إدارة النماذج</a>
      <?php if ($addHref && $addHref !== '#'): ?>
        <a class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700" href="<?= htmlspecialchars($addHref) ?>">➕ إضافة نموذج</a>
      <?php endif; ?>
      <?php if ($addHtmlHref && $addHtmlHref !== '#'): ?>
        <a class="px-3 py-2 rounded-lg bg-sky-600 hover:bg-sky-700" href="<?= htmlspecialchars($addHtmlHref) ?>">➕ إضافة HTML</a>
      <?php endif; ?>
      <?php if ($kanbanHref && $kanbanHref !== '#'): ?>
        <a class="px-3 py-2 rounded-lg bg-amber-600 hover:bg-amber-700" href="<?= htmlspecialchars($kanbanHref) ?>">📌 الكانبان</a>
      <?php endif; ?>
      <?php if ($reportHref && $reportHref !== '#'): ?>
        <a class="px-3 py-2 rounded-lg bg-pink-600 hover:bg-pink-700" href="<?= htmlspecialchars($reportHref) ?>">📊 التقارير</a>
      <?php endif; ?>
    </div>
  </section>

</div><!-- /container-print -->

<script>
/* إرسال واتساب مباشرة */
(function(){
  const form = document.getElementById('contactForm');
  const res  = document.getElementById('contactResult');
  const WA_NUMBER = '966535500241';
  if(!form) return;
  form.addEventListener('submit', function(e){
    e.preventDefault();
    const name  = document.getElementById('c_name').value.trim();
    const email = document.getElementById('c_email').value.trim();
    const phone = document.getElementById('c_phone').value.trim();
    const msg   = document.getElementById('c_msg').value.trim();
    if(!name || !msg){ res.textContent = 'الاسم والطلب مطلوبين'; return; }
    const page = location.pathname;
    const text = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email || '-'}
الجوال: ${phone || '-'}
الصفحة: ${page}
————————
الطلب:
${msg}`;
    const url = `https://wa.me/${WA_NUMBER}?text=${encodeURIComponent(text)}`;
    window.open(url, '_blank');
    res.textContent = 'بيفتح لك واتساب برسالة جاهزة.. بس أرسلها ونخدمك 👍';
  });
})();
</script>

</body>
</html>
