<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$role = $user['role'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$currentUserColorId = $user['color_id'];
if (!in_array($role, ['admin', 'manager'])) {
  header("Location: ../unauthorized.php");
  exit;
}

// جلب الإدارات
$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
$departmentsMap = array_column($departments, 'name', 'id');
$selected_department_id = $_GET['department_id'] ?? null;

// جلب المستخدمين
$users = $conn->query("SELECT id, name FROM users")->fetchAll(PDO::FETCH_ASSOC);
$usersMap = array_column($users, 'name', 'id');

// جلب المراحل
$stages = $conn->query("SELECT id, name FROM stages")->fetchAll(PDO::FETCH_ASSOC);
$stagesMap = array_column($stages, 'name', 'id');

// جلب النماذج
if ($role === 'admin') {
  if ($selected_department_id) {
    $stmt = $conn->prepare("SELECT * FROM templates WHERE department_id = ? ORDER BY created_at DESC");
    $stmt->execute([$selected_department_id]);
    $templates = $stmt->fetchAll(PDO::FETCH_ASSOC);
  } else {
    $templates = $conn->query("SELECT * FROM templates ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
  }
} else {
  $stmt = $conn->prepare("SELECT * FROM templates WHERE department_id = ? ORDER BY created_at DESC");
  $stmt->execute([$user['department_id']]);
  $templates = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة النماذج</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body, .main-card, tr:hover, a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

    .text-button {
      color: #ffffff !important;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .move-button:hover,
    .view-tasks:hover {
      background-color: rgb(19, 11, 57) !important;
    }

    .download-button {
      background-color: #4d70f4;
      color: #FFFFFF !important;
      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;
    }

    .edit-button:hover , .view-button:hover , .download-button:hover , .delete-button:hover {
      color: <?= isset($currentUserColorId) && $currentUserColorId == 3 ? '#FFFFFF' : '#000000'; ?> !important;
    }

    .edit-button {
      background-color: #8BFB75 !important;
      color: #0e162a !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;
    }

    .delete-button {
      background-color: #FD7474 !important;
      color: #FFFFFF !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;
    }
  </style>
</head>
<script src="../assets/js/task_modal_functions.js"></script>
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<body class="bg-gray-100 text-right">

  <div class="max-w-7xl mx-auto">
    <h1 class="text-2xl text font-bold mb-6">📄 إدارة النماذج</h1>

<?php $helpHref = file_exists(__DIR__.'/help.php') ? 'help.php' : 'instructions.php'; ?>
<div class="flex items-center gap-2 mb-4">
  <a href="add.php" class="move-button text-button text-white px-4 py-2 rounded inline-block">➕ إضافة نموذج</a>
  <a href="add_template_html.php" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 inline-block">➕ إضافة HTML</a>

  <!-- دفّه يسار في RTL -->
  <a href="<?= htmlspecialchars($helpHref) ?>" target="_blank" rel="noopener"
     class="move-button text-button text-white px-4 py-2 rounded inline-flex items-center gap-1 rtl:mr-auto ltr:ml-auto no-print"
     title="تعليمات إدارة النماذج">❓ تعليمات</a>
</div>

    <?php if ($role === 'admin'): ?>
      <form method="GET" class="mb-4">
        <label class="block mb-1 text-sm font-medium">اختر الإدارة لعرض النماذج:</label>
        <select name="department_id" onchange="this.form.submit()" class="card border rounded px-3 py-2 w-64">
          <option value="">-- كل الإدارات --</option>
          <?php foreach ($departments as $dept): ?>
            <option value="<?= $dept['id'] ?>" <?= $dept['id'] == $selected_department_id ? 'selected' : '' ?>>
              <?= htmlspecialchars($dept['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </form>
    <?php endif; ?>

    <div class="rounded shadow overflow-x-auto">
      <table class="card min-w-full text-sm text-right">
        <thead>
          <tr>
            <th class="px-4 py-2 border">#</th>
            <th class="px-4 py-2 border">اسم النموذج</th>
            <th class="px-4 py-2 border">الإدارة</th>
            <th class="px-4 py-2 border">المرحلة</th>
            <th class="px-4 py-2 border">الموقّع</th>
            <th class="px-4 py-2 border">ملف النموذج</th>
            <th class="px-4 py-2 border">خيارات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($templates as $i => $template): ?>
            <tr class="border-b">
              <td class="px-4 py-2 border"><?= $i + 1 ?></td>
              <td class="px-4 py-2 border"><?= htmlspecialchars($template['name']) ?></td>
              <td class="px-4 py-2 border"><?= $departmentsMap[$template['department_id']] ?? '—' ?></td>
              <td class="px-4 py-2 border"><?= $stagesMap[$template['stage_id']] ?? '—' ?></td>
              <td class="px-4 py-2 border"><?= $usersMap[$template['signer_user_id']] ?? '—' ?></td>
              <td class="px-4 py-2 border">
                <a href="<?= htmlspecialchars($template['file_path']) ?>" target="_blank" class="text-blue-600 download-button">📥 تحميل</a>
              </td>
              <td class="px-4 py-2 border space-x-2 rtl:space-x-reverse">
                <a href="edit.php?id=<?= $template['id'] ?>" class="text-green-600 edit-button">✏️ تعديل</a>
                <a href="delete.php?id=<?= $template['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')" class="text-red-600 delete-button">🗑 حذف</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</body>
</html>