<?php
session_start();

$tempHtmlPath = $_SESSION['html_preview'] ?? null;
$task_id = $_SESSION['preview_task_id'] ?? null;
$template_id = $_SESSION['preview_template_id'] ?? null;

if (!$tempHtmlPath || !file_exists($tempHtmlPath)) {
    echo "❌ لا يوجد محتوى للمعاينة.";
    exit;
}

$htmlContent = file_get_contents($tempHtmlPath);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
  <meta charset="UTF-8">
  <title>معاينة النموذج</title>
  <style>
    body { font-family: 'Arial'; margin: 20px; }
    iframe { width: 100%; height: 90vh; border: 1px solid #ccc; }
    .btns { margin-top: 20px; display: flex; gap: 10px; }
  </style>
</head>
<body>
  <h2>📝 معاينة النموذج قبل التوقيع</h2>

  <iframe srcdoc="<?php echo htmlspecialchars($htmlContent); ?>"></iframe>

  <div class="btns">
    <form method="post" action="confirm_sign.php">
      <input type="hidden" name="task_id" value="<?= $task_id ?>">
      <input type="hidden" name="template_id" value="<?= $template_id ?>">
      <button type="submit">✅ تأكيد التوقيع</button>
    </form>
    <a href="javascript:history.back()">🔙 رجوع</a>
  </div>
</body>
</html>
