<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if (session_status() === PHP_SESSION_NONE) session_start();

$task_id = $_POST['task_id'] ?? null;
$template_id = $_POST['template_id'] ?? null;
$user_id = $_SESSION['user']['id'] ?? null;
$left = $_POST['left'] ?? '100px';
$top = $_POST['top'] ?? '100px';
$width = intval($_POST['width'] ?? 150); // ← عرض التوقيع إذا أرسلناه

if (!$task_id || !$template_id || !$user_id || !$left || !$top) {
  die('❌ بيانات ناقصة');
}

// ✅ جلب بيانات النموذج
$stmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$template_id]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$template) die('❌ النموذج غير موجود');

$template_html_path = "../templates/html/{$template_id}.html";
if (!file_exists($template_html_path)) die('❌ ملف HTML غير موجود');

$html_content = file_get_contents($template_html_path);

// ✅ جلب توقيع المستخدم
$signStmt = $conn->prepare("SELECT signature_path FROM users WHERE id = ?");
$signStmt->execute([$user_id]);
$user = $signStmt->fetch(PDO::FETCH_ASSOC);

if (!$user || empty($user['signature_path'])) {
  die('❌ لم يتم العثور على توقيع المستخدم.');
}

$signature_url = realpath('../uploads/signatures/' . $user['signature_path']);
$signature_url = 'file:///' . str_replace('\\', '/', $signature_url);
if (!file_exists($signature_url)) {
  die('❌ ملف التوقيع غير موجود فعليًا.');
}

$html_content = file_get_contents($template_html_path);

// ✅ تعويض القيم المعدّلة
$values = json_decode($_POST['values'] ?? '{}', true);
foreach ($values as $key => $val) {
  $replacement = "<span data-placeholder=\"$key\">$val</span>";
  $html_content = preg_replace($pattern, $replacement, $html_content);
}



// ✅ دمج التوقيع في HTML داخل div بمكان مختار
$signature_html = "<img src='{$signature_url}' style='position: absolute; left: {$left}px; top: {$top}px; width: {$width}px; height: auto;'>";

// استبدال {{signature}} أو إضافته آخر الـ body
if (strpos($html_content, '{{signature}}') !== false) {
  $html_content = str_replace('{{signature}}', $signature_html, $html_content);
} else {
  $html_content = str_replace('</body>', $signature_html . '</body>', $html_content);
}

// ✅ توليد PDF من HTML
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('defaultFont', 'dejavusans');

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html_content, 'UTF-8');
$dompdf->setPaper('A4');
$dompdf->render();

// ✅ حفظ PDF في uploads
$filename = 'task_' . $task_id . '_signed_' . time() . '.pdf';
$pdf_output_path = "../uploads/" . $filename;
file_put_contents($pdf_output_path, $dompdf->output());

// ✅ حفظ كمرفق في قاعدة البيانات
$stmt = $conn->prepare("INSERT INTO attachments (task_id, file_path, uploaded_by) VALUES (?, ?, ?)");
$stmt->execute([$task_id, 'uploads/' . $filename, $user_id]);

echo "✅ تم توقيع النموذج ورفعه كمرفق PDF";
