<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';

use Dompdf\Dompdf;

session_start();

$task_id = $_POST['task_id'] ?? null;
$template_id = $_POST['template_id'] ?? null;
$user_id = $_SESSION['user']['id'] ?? null;

if (!$task_id || !$template_id || !$user_id) {
  die('❌ بيانات غير مكتملة.');
}

// جلب بيانات المهمة
$stmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
$stmt->execute([$task_id]);
$task = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب بيانات المستخدم
$stmt = $conn->prepare("SELECT signature_path FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب بيانات النموذج
$stmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$template_id]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب الحقول المخصصة
$customStmt = $conn->prepare("SELECT cf.label, tcv.value FROM task_custom_values tcv 
  JOIN custom_fields cf ON cf.id = tcv.field_id
  WHERE tcv.task_id = ?");
$customStmt->execute([$task_id]);
$customFields = $customStmt->fetchAll(PDO::FETCH_ASSOC);

// إعداد التاريخ الهجري
$formatter = new IntlDateFormatter('ar_SA@calendar=islamic', IntlDateFormatter::LONG, IntlDateFormatter::NONE, 'Asia/Riyadh');
$hijri_date = $formatter->format(time());

// ✅ إنشاء HTML
ob_start();
?>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <style>
    body { font-family: DejaVu Sans, sans-serif; }
    .signature { margin-top: 50px; }
  </style>
</head>
<body>
  <h2><?= htmlspecialchars($task['title']) ?></h2>
  <p><?= nl2br(htmlspecialchars($task['description'])) ?></p>
  <p><strong>تاريخ الاستحقاق:</strong> <?= $task['due_date'] ?></p>
  <p><strong>التاريخ الهجري:</strong> <?= $hijri_date ?></p>

  <?php foreach ($customFields as $field): ?>
    <p><strong><?= htmlspecialchars($field['label']) ?>:</strong> <?= htmlspecialchars($field['value']) ?></p>
  <?php endforeach; ?>

  <?php if (!empty($user['signature_path']) && file_exists($user['signature_path'])): ?>
    <div class="signature">
      <strong>التوقيع:</strong><br>
      <img src="../<?= $user['signature_path'] ?>" width="150" height="70">
    </div>
  <?php endif; ?>
</body>
</html>
<?php
$html = ob_get_clean();

// 🖨️ إنشاء PDF باستخدام Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$pdfPath = 'uploads/task_' . $task_id . '_signed_' . time() . '.pdf';
file_put_contents($pdfPath, $dompdf->output());

// 📎 حفظ كمرفق
$stmt = $conn->prepare("INSERT INTO attachments (task_id, file_path, uploaded_by) VALUES (?, ?, ?)");
$stmt->execute([$task_id, $pdfPath, $user_id]);

// 🔍 عرض مباشر
header("Content-Type: application/pdf");
header("Content-Disposition: inline; filename='signed.pdf'");
readfile($pdfPath);
exit;
