<?php
require_once '../config/db.php';

$template_id = $_GET['template_id'] ?? null;

if (!$template_id) {
  die('❌ رقم النموذج غير موجود.');
}

$stmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$template_id]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$template) {
  die('❌ لم يتم العثور على النموذج.');
}

$file_path = '../' . $template['file_path'];

if (!file_exists($file_path)) {
  die('❌ لم يتم العثور على ملف النموذج.');
}

// إجبار المتصفح على فتح أو تحميل الملف
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
header("Content-Disposition: inline; filename=\"" . basename($file_path) . "\"");
readfile($file_path);
exit;
