<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';

use PhpOffice\PhpWord\TemplateProcessor;
use PhpOffice\PhpWord\IOFactory;

if (session_status() === PHP_SESSION_NONE) session_start();

$task_id = $_GET['task_id'] ?? null;
$template_id = $_GET['template_id'] ?? null;

if (!$task_id || !$template_id) {
  exit("<p class='text-red-600 p-4'>❌ بيانات غير مكتملة</p>");
}

// جلب معلومات النموذج من قاعدة البيانات
$stmt = $conn->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$template_id]);
$template = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$template) {
  exit("<p class='text-red-600 p-4'>❌ النموذج غير موجود</p>");
}

$file_path = "../" . $template['file_path'];
$extension = strtolower(pathinfo($file_path, PATHINFO_EXTENSION));
$template_path = '';

if (!file_exists($file_path)) {
  exit("<p class='text-red-600 p-4'>❌ الملف غير موجود</p>");
}

if ($extension === 'html') {
  // إذا كان HTML نعرضه مباشرة
  $template_path = $file_path;
} elseif ($extension === 'docx') {
  // نحاول توليد HTML من Word
  $html_path = "../templates/html/task_{$task_id}_template_{$template_id}.html";
  if (!file_exists($html_path)) {
    $processor = new TemplateProcessor($file_path);
    $processor->setValue('current_date', date('Y-m-d'));
    $processor->setValue('hijri_date', convertToHijri(date('Y-m-d')));
    $processor->setValue('task_id', $task_id);

    if (!is_dir("../templates/temp")) mkdir("../templates/temp", 0777, true);
    $tempDocx = "../templates/temp/temp_{$template_id}.docx";
    $processor->saveAs($tempDocx);

    $phpWord = IOFactory::load($tempDocx);
    $htmlWriter = IOFactory::createWriter($phpWord, 'HTML');

    if (!is_dir("../templates/html")) mkdir("../templates/html", 0777, true);
    $htmlWriter->save($html_path);
  }
  $template_path = $html_path;
} else {
  exit("<p class='text-red-600 p-4'>❌ نوع الملف غير مدعوم</p>");
}

// قراءة المحتوى بعد تحديد المسار النهائي
$html_content = file_get_contents($template_path);

// استبدال المتغيرات
$user = $_SESSION['user'];
$signatureUrl = "../uploads/signatures/{$user['signature_path']}";
$variables = [
  '{gregorian_date}' => date('Y-m-d'),
  '{hijri_date}'     => convertToHijri(date('Y-m-d')),
  '{task_id}'        => $task_id
];
$html_content = str_replace(array_keys($variables), array_values($variables), $html_content);
?>


<!-- ✅ واجهة المودال -->
<div class="fixed inset-0 bg-black bg-opacity-30 flex justify-center items-center z-50">
  <div class="relative bg-white rounded-2xl shadow-xl w-full max-w-4xl max-h-[90vh] overflow-y-auto animate-fade-in">

    <button onclick="closeModal()" class="absolute top-4 left-4 text-red-600 text-2xl font-bold z-10">
      &times;
    </button>

    <div class="p-6 border-b">
      <h2 class="text-xl font-bold text-gray-800">📄 معاينة النموذج</h2>
    </div>

    <div id="templateWrapper" class="relative p-6 bg-white border rounded-lg shadow-inner min-h-[600px]" dir="rtl">
     <div id="templateContainer"
     class="text-right leading-relaxed text-[16px] text-black"
     contenteditable="true"
     style="min-height: 500px;">
  <style>
    body {
      font-family: Tahoma, Arial, sans-serif;
      direction: rtl;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 1rem;
    }

    th, td {
      border: 1px solid #aaa;
      padding: 8px;
      text-align: right;
    }

    h1, h2, h3 {
      margin: 1rem 0 0.5rem;
      font-weight: bold;
    }

    p {
      margin: 0.5rem 0;
    }
  </style>

  <?= $html_content ?>
</div>


      <img id="userSignature"
           src="<?= $signatureUrl ?>"
           class="draggable-signature"
           style="position: absolute; top: 50px; left: 50px; max-height: 100px; cursor: move;">
    </div>

    <div class="p-4 border-t flex justify-between items-center bg-white">

      <button onclick="closeModal()"
              class="bg-gray-200 text-gray-800 px-4 py-2 rounded hover:bg-gray-300 text-sm flex items-center gap-1">
        ❌ إغلاق
      </button>

      <div class="flex gap-2">
        <a href="../templates/download_template.php?template_id=<?= $template_id ?>" target="_blank"
           class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 text-sm flex items-center gap-1">
          ⬇️ تحميل
        </a>

        <button onclick="saveTemplateEdit(<?= $task_id ?>, <?= $template_id ?>)"
                class="bg-yellow-500 text-white px-4 py-2 rounded hover:bg-yellow-600 text-sm flex items-center gap-1">
          💾 حفظ التعديلات
        </button>

        <button onclick="printTemplateContent()"
                class="bg-emerald-600 text-white px-4 py-2 rounded hover:bg-emerald-700 text-sm flex items-center gap-1">
          🖨️ طباعة
        </button>
      </div>
    </div>
  </div>
</div>

<!-- ✅ تنسيقات -->
<style>
  #templateWrapper {
    position: relative;
    overflow: hidden;
    background-color: #fff;
  }

  #templateContainer {
    outline: none;
  }

  .draggable-signature {
    position: absolute;
    z-index: 9999;
    border: 1px dashed #aaa;
    background-color: #fff;
    user-select: none;
    -webkit-user-drag: none;
    padding: 2px;
    box-shadow: 0 0 5px rgba(0,0,0,0.1);
  }

  @media print {
    body * {
      visibility: hidden;
    }

    .print-container, .print-container * {
      visibility: visible;
    }

    .draggable-signature {
      border: none !important;
      box-shadow: none !important;
    }
  }
</style>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const sig = document.getElementById("userSignature");
  const container = document.getElementById("templateWrapper");
  if (!sig || !container) return;

  let isDragging = false, offsetX = 0, offsetY = 0;

  sig.addEventListener("mousedown", (e) => {
    isDragging = true;
    const rect = sig.getBoundingClientRect();
    offsetX = e.clientX - rect.left;
    offsetY = e.clientY - rect.top;
  });

  document.addEventListener("mousemove", (e) => {
    if (!isDragging) return;

    const containerRect = container.getBoundingClientRect();
    const left = e.clientX - containerRect.left - offsetX + container.scrollLeft;
    const top = e.clientY - containerRect.top - offsetY + container.scrollTop;

    sig.style.left = Math.max(0, left) + "px";
    sig.style.top = Math.max(0, top) + "px";
  });

  document.addEventListener("mouseup", () => {
    isDragging = false;
  });
});

function printTemplateContent() {
  const container = document.getElementById("templateContainer");
  const signature = document.getElementById("userSignature");

  if (!container || !signature) {
    alert("📌 لا يمكن العثور على النموذج أو التوقيع");
    return;
  }

  const content = container.innerHTML;
  const left = signature.style.left || "50px";
  const top = signature.style.top || "50px";
  const width = signature.offsetWidth || 150;
  const src = signature.getAttribute("src");

  const signatureHtml = `<img src="${src}" style="position: absolute; left: ${left}; top: ${top}; width: ${width}px; max-height: 100px;">`;

  const printWindow = window.open('', '_blank');
  printWindow.document.write(`
    <html dir="rtl">
      <head>
        <title>طباعة النموذج</title>
        <style>
          body { font-family: Arial, sans-serif; direction: rtl; padding: 20px; }
          .print-container { position: relative; min-height: 600px; }
          img { max-width: 100%; }
        </style>
      </head>
      <body onload="window.print(); window.close();">
        <div class="print-container">
          ${content}
          ${signatureHtml}
        </div>
      </body>
    </html>
  `);
  printWindow.document.close();
}

function saveTemplateEdit(taskId, templateId) {
  const btn = event.target;
  const editedHtml = document.getElementById("templateContainer")?.innerHTML;

  if (!editedHtml) {
    alert("⚠️ لا يوجد محتوى لحفظه.");
    return;
  }

  btn.disabled = true;
  btn.innerText = "⏳ جاري الحفظ...";

  fetch("../templates/save_template_update.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `task_id=${taskId}&template_id=${templateId}&html_content=${encodeURIComponent(editedHtml)}`
  })
  .then(res => res.text())
  .then(res => {
    btn.disabled = false;
    btn.innerText = "💾 حفظ التعديلات";

    if (res.includes("✅")) {
      alert("✅ تم حفظ التعديلات بنجاح");
    } else {
      alert("❌ فشل الحفظ: " + res);
    }
  });
}
</script>

<?php
function convertToHijri($date = null) {
    if (!$date) {
        $date = date('Y-m-d');
    }

    list($gy, $gm, $gd) = explode('-', $date);

    $jd = cal_to_jd(CAL_GREGORIAN, $gm, $gd, $gy);

    $jd = $jd - 1948440 + 10632;
    $n = (int)(($jd - 1) / 10631);
    $jd = $jd - 10631 * $n + 354;
    $j = ((int)((10985 - $jd) / 5316)) * ((int)(50 * $jd / 17719)) +
         ((int)($jd / 5670)) * ((int)(43 * $jd / 15238));
    $jd = $jd - ((int)((30 - $j) / 15)) * ((int)((17719 * $j) / 50)) -
               ((int)($j / 16)) * ((int)((15238 * $j) / 43)) + 29;

    $month = (int)(24 * $jd / 709);
    $day = $jd - (int)(709 * $month / 24);
    $year = 30 * $n + $j - 30;

    $months_ar = [
        "محرم", "صفر", "ربيع الأول", "ربيع الثاني", "جمادى الأولى", "جمادى الآخرة",
        "رجب", "شعبان", "رمضان", "شوال", "ذو القعدة", "ذو الحجة"
    ];

return $day . ' / ' . $month . ' / ' . $year . ' هـ';
}

?>
