<?php
require_once '../config/db.php';
require_once '../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user']) || !isset($_SESSION['user']['name']) || !isset($_SESSION['user']['email']) || !isset($_SESSION['user']['role']) || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}
$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'];
$userThemeSecondTextColor = $color['second_text_color'];
$currentUserColorId  = $user['color_id'];

// جلب الموظفين
$users = $conn->query("SELECT id, name FROM users ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

// هل تعديل أم إضافة؟
$editing = isset($_GET['id']) && is_numeric($_GET['id']);
$training = [
    'employee_id' => '',
    'course_name' => '',
    'provider' => '',
    'course_date' => '',
    'hours' => '',
    'employee_feedback' => '',
    'certificate_path' => ''
];

if ($editing) {
    $stmt = $conn->prepare("SELECT * FROM employee_trainings WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $training = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$training) die('الدورة غير موجودة');
}

// رقم الموظف المرسل بالرابط أو الفورم أو من البيانات القديمة (تسلسل مرن)
$employee_id = $_POST['employee_id'] ??
               ($_GET['employee_id'] ?? 
               ($training['employee_id'] ?? ''));

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $course_name = $_POST['course_name'] ?? '';
    $provider = $_POST['provider'] ?? '';
    $course_date = $_POST['course_date'] ?? '';
    $hours = $_POST['hours'] ?? '';
    $employee_feedback = $_POST['employee_feedback'] ?? '';
    $certificate_path = $training['certificate_path'];

    if (!$employee_id || !is_numeric($employee_id)) {
        $msg = "❌ الرجاء اختيار الموظف بشكل صحيح.";
    } elseif (empty($course_name) || empty($provider) || empty($course_date) || empty($hours)) {
        $msg = "❌ جميع الحقول مطلوبة.";
    } else {
        // معالجة رفع الشهادة
        if (isset($_FILES['certificate']) && $_FILES['certificate']['error'] === UPLOAD_ERR_OK) {
            $ext = strtolower(pathinfo($_FILES['certificate']['name'], PATHINFO_EXTENSION));
            $allowed = ['pdf', 'jpg', 'jpeg', 'png'];
            if (in_array($ext, $allowed)) {
                $certDir = __DIR__ . '/uploads/certificates/';
                if (!is_dir($certDir)) mkdir($certDir, 0777, true);
                $uniqueFile = uniqid() . '.' . $ext;
                move_uploaded_file($_FILES['certificate']['tmp_name'], $certDir . $uniqueFile);
                $certificate_path = 'users/uploads/certificates/' . $uniqueFile;
            }
        }

        if ($editing) {
            $stmt = $conn->prepare("UPDATE employee_trainings SET employee_id=?, course_name=?, provider=?, course_date=?, hours=?, employee_feedback=?, certificate_path=? WHERE id=?");
            $stmt->execute([$employee_id, $course_name, $provider, $course_date, $hours, $employee_feedback, $certificate_path, $_GET['id']]);
            $msg = "تم تحديث الدورة بنجاح";
        } else {
            $stmt = $conn->prepare("INSERT INTO employee_trainings (employee_id, course_name, provider, course_date, hours, employee_feedback, certificate_path) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$employee_id, $course_name, $provider, $course_date, $hours, $employee_feedback, $certificate_path]);
            $msg = "تم إضافة الدورة بنجاح";
            $training = [
                'employee_id' => '',
                'course_name' => '',
                'provider' => '',
                'course_date' => '',
                'hours' => '',
                'employee_feedback' => '',
                'certificate_path' => ''
            ];
            $employee_id = ''; // إذا تبي تعيد الفورم فارغ بعد الإضافة
        }
        $training = [
            'employee_id' => $employee_id,
            'course_name' => $course_name,
            'provider' => $provider,
            'course_date' => $course_date,
            'hours' => $hours,
            'employee_feedback' => $employee_feedback,
            'certificate_path' => $certificate_path
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title><?= $editing ? 'تعديل' : 'إضافة' ?> دورة تدريبية</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body, .main-card { background-color: <?= $userThemeColor ?> !important; }
    .card, nav { background-color: <?= $userThemeNavColor ?> !important; }
    label, h2, th, td, a, .text { color: <?= $userThemeTextColor ?> !important; }
    input, textarea, select { color: <?= $userThemeTextColor ?> !important; background-color: #fff !important; }
    .main-card { border-radius: 1.25rem; box-shadow: 0 1px 8px 0 #0001; }
    .btn-main { background: <?= $userThemeNavColor ?>; color: <?= $userThemeTextColor ?>; border-radius: 10px; padding: 10px 0; font-weight: bold;}
    .btn-main:hover { opacity: 0.9;}
  </style>
</head>
<body class="min-h-screen flex flex-col">
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class="h-20"></div>
  <div class="main-card card w-full max-w-xl p-8 mx-auto my-10">
    <h2 class="text-2xl font-bold mb-6 text-center"><?= $editing ? 'تعديل' : 'إضافة' ?> دورة تدريبية</h2>
    <?php if($msg): ?>
      <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4 text-center"><?= $msg ?></div>
    <?php endif; ?>
    <form method="POST" enctype="multipart/form-data" class="grid gap-5">
      <div>
        <label class="block mb-1 font-medium">الموظف *</label>
        <?php if ($employee_id): ?>
          <select class="w-full border p-2 rounded bg-gray-200 cursor-not-allowed" disabled>
            <?php foreach ($users as $user_): ?>
              <option value="<?= $user_['id'] ?>" <?= $user_['id'] == $employee_id ? 'selected' : '' ?>>
                <?= htmlspecialchars($user_['name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
          <input type="hidden" name="employee_id" value="<?= htmlspecialchars($employee_id) ?>">
        <?php else: ?>
          <select name="employee_id" class="w-full border p-2 rounded" required>
            <option value="">اختـر الموظف</option>
            <?php foreach ($users as $user_): ?>
              <option value="<?= $user_['id'] ?>" <?= $user_['id'] == ($training['employee_id'] ?? '') ? 'selected' : '' ?>>
                <?= htmlspecialchars($user_['name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        <?php endif; ?>
      </div>
      <div>
        <label class="block mb-1 font-medium">اسم الدورة *</label>
        <input type="text" name="course_name" value="<?= htmlspecialchars($training['course_name']) ?>" class="w-full border p-2 rounded" required>
      </div>
      <div>
        <label class="block mb-1 font-medium">جهة التدريب *</label>
        <input type="text" name="provider" value="<?= htmlspecialchars($training['provider']) ?>" class="w-full border p-2 rounded" required>
      </div>
      <div>
        <label class="block mb-1 font-medium">تاريخ الدورة *</label>
        <input type="date" name="course_date" value="<?= htmlspecialchars($training['course_date']) ?>" class="w-full border p-2 rounded" required>
      </div>
      <div>
        <label class="block mb-1 font-medium">عدد الساعات *</label>
        <input type="number" name="hours" value="<?= htmlspecialchars($training['hours']) ?>" class="w-full border p-2 rounded" min="1" required>
      </div>
      <div>
        <label class="block mb-1 font-medium">ملاحظات / تغذية راجعة</label>
        <textarea name="employee_feedback" class="w-full border p-2 rounded"><?= htmlspecialchars($training['employee_feedback']) ?></textarea>
      </div>
      <div>
        <label class="block mb-1 font-medium">الشهادة (PDF أو صورة)</label>
        <?php if ($editing && $training['certificate_path']): ?>
          <div class="mb-2">
            <a href="../<?= $training['certificate_path'] ?>" target="_blank" class="text-blue-600 underline">مشاهدة الشهادة الحالية</a>
          </div>
        <?php endif; ?>
        <input type="file" name="certificate" accept=".pdf,.jpg,.jpeg,.png" class="w-full border p-2 rounded">
      </div>
      <button type="submit" class="btn-main w-full"><?= $editing ? 'تحديث الدورة' : 'إضافة الدورة' ?></button>
    </form>
    <a href="trainings_list.php" class="block text-center mt-4 text-gray-600 hover:text-blue-600">الرجوع للسجل</a>
  </div>
</body>
</html>
