<?php
session_start();
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user'])) {
    header("Location: ../users/login.php");
    exit;
}

$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'];
$userThemeSecondTextColor = $color['second_text_color'] ?? '#333';

$role = $user['role'];

// جلب الإدارات للفلتر
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

// تحضير الفلاتر
$where = [];
$params = [];

if (!empty($_GET['search'])) {
    $term = '%' . $_GET['search'] . '%';
    $where[] = "(u.name LIKE :term OR ar.asset_type_name LIKE :term OR ar.status LIKE :term OR d.name LIKE :term OR hf.serial_number LIKE :term OR ar.id LIKE :term OR hf.price LIKE :term OR ar.created_at LIKE :term OR hf.created_at LIKE :term)";
    $params[':term'] = $term;
}

if (!empty($_GET['department'])) {
    $where[] = "d.id = :dep";
    $params[':dep'] = $_GET['department'];
}

if (!empty($_GET['from_date'])) {
    $where[] = "DATE(ar.created_at) >= :from";
    $params[':from'] = $_GET['from_date'];
}

if (!empty($_GET['to_date'])) {
    $where[] = "DATE(ar.created_at) <= :to";
    $params[':to'] = $_GET['to_date'];
}

$sql = "SELECT 
            ar.*, 
            u.name AS employee_name, 
            u.employee_number,
            d.name AS department_name,
            m.name AS manager_name,
            ma.name AS approving_manager_name,
            hf.serial_number,
            hf.price,
            hf.invoice_filename,
            hf.status AS handover_status,
            hf.created_at AS handover_created_at
        FROM asset_requests ar
        JOIN users u ON ar.user_id = u.id
        LEFT JOIN departments d ON u.department_id = d.id
        LEFT JOIN users m ON ar.assigned_manager_id = m.id
        LEFT JOIN users ma ON ar.approved_by_manager = ma.id
        LEFT JOIN asset_hand_over_forms hf ON hf.asset_request_id = ar.id";

if (!empty($where)) {
    $sql .= ' WHERE ' . implode(' AND ', $where);
}

$sql .= " ORDER BY ar.created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$requests = $stmt->fetchAll(PDO::FETCH_ASSOC);

function statusColor($status) {
    $status = trim($status ?? '');
    if(strpos($status, 'بانتظار') !== false) return 'bg-yellow-200 text-yellow-900';
    if(strpos($status, 'مرفوضة') !== false) return 'bg-red-200 text-red-700';
    if(strpos($status, 'تم التنفيذ') !== false || strpos($status, 'تم التسليم') !== false || strpos($status, 'منفذة') !== false) return 'bg-green-200 text-green-700';
    if(strpos($status, 'اعتماد المدير') !== false || strpos($status, 'المدير المختص') !== false) return 'bg-blue-200 text-blue-900';
    return 'bg-gray-200 text-gray-700';
}

// التصدير إلى اكسل
if (isset($_GET['export']) && $_GET['export'] === 'excel') {
    header("Content-Type: application/vnd.ms-excel; charset=utf-8");
    header("Content-Disposition: attachment; filename=asset_requests_" . date('Ymd_His') . ".xls");
    echo "<table border='1'>";
    echo "<tr>
            <th>#</th><th>الموظف</th><th>الإدارة</th><th>نوع العهدة</th>
            <th>تفاصيل</th><th>الحالة</th><th>المدير المختص</th><th>المدير المعتمد</th>
            <th>تاريخ الطلب</th><th>الرقم التسلسلي</th><th>السعر</th>
            <th>حالة التسليم</th><th>تاريخ التسليم</th>
        </tr>";
    foreach ($requests as $req) {
        echo "<tr>";
        echo "<td>{$req['id']}</td>";
        echo "<td>" . htmlspecialchars($req['employee_name']) . "</td>";
        echo "<td>" . htmlspecialchars($req['department_name']) . "</td>";
        echo "<td>" . htmlspecialchars($req['asset_type_name']) . "</td>";
        echo "<td>" . htmlspecialchars($req['details']) . "</td>";
        echo "<td>" . htmlspecialchars($req['status']) . "</td>";
        echo "<td>" . htmlspecialchars($req['manager_name']) . "</td>";
        echo "<td>" . htmlspecialchars($req['approving_manager_name']) . "</td>";
        echo "<td>" . $req['created_at'] . "</td>";
        echo "<td>" . ($req['serial_number'] ?? '-') . "</td>";
        echo "<td>" . ($req['price'] ?? '-') . "</td>";
        echo "<td>" . ($req['handover_status'] ?? '-') . "</td>";
        echo "<td>" . ($req['handover_created_at'] ?? '-') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة العهد</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
<style>
    body, .main-card, tr:hover, a:hover {background-color: <?= $userThemeColor ?> !important;}
    nav, .select2-results__option, .select2-search, .select2-selection--multiple, li, .card {
        background-color: <?= $userThemeNavColor ?> !important;}
    .text, label, h3, option, h2, th, td, li, strong, select, input, a {
        color: <?= $userThemeTextColor ?> !important;}
    option {text-align: center;}
    @media print {
        form, .no-print, nav, .navbar, .btn, .text-blue-800 {
            display: none !important;
        }
        table {
            direction: rtl;
            width: 100%;
            font-size: 12px;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 4px;
        }
        body {
            background: white !important;
            color: black !important;
        }
        @page {
            size: landscape;
        }
    }
</style>

</head>
<body class="text-right">

<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<div class="max-w-7xl mx-auto p-6">

<style>.rtl-left{ margin-right:auto; }</style>

<div class="flex items-center gap-2 mb-4">
  <h2 class="text-2xl font-bold text-center md:text-right flex-1">🛠️ إدارة العهد</h2>
  <a href="help_asset_requests.php" target="_blank"
     class="rtl-left inline-flex items-center gap-2 px-3 py-1.5 rounded-xl bg-gray-200 text-gray-900 hover:bg-gray-300">

❓ تعليمات</a>
</div>

    <!-- نموذج البحث والفلاتر وزر التصدير والطباعة -->
    <form method="GET" class="mb-4 p-4 flex flex-wrap gap-2 items-center bg-white rounded shadow">
        <input type="text" name="search" placeholder="كلمة بحث..." value="<?= htmlspecialchars($_GET['search'] ?? '') ?>" class="border px-4 py-2 rounded w-full md:w-1/4" />

        <select name="department" class="border px-4 py-2 rounded w-full md:w-1/4">
            <option value="">🔽 كل الإدارات</option>
            <?php foreach ($departments as $dept): ?>
                <option value="<?= $dept['id'] ?>" <?= (isset($_GET['department']) && $_GET['department'] == $dept['id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($dept['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <input type="date" name="from_date" value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>" class="border px-4 py-2 rounded w-full md:w-1/5" />
        <input type="date" name="to_date" value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>" class="border px-4 py-2 rounded w-full md:w-1/5" />

        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 w-full md:w-auto">🔍 بحث</button>
        <button type="submit" name="export" value="excel" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 w-full md:w-auto">📥 تصدير Excel</button>
        <button type="button" onclick="window.print()" class="bg-orange-600 text-white px-4 py-2 rounded hover:bg-orange-700 w-full md:w-auto">🖨️ طباعة</button>
    </form>

    <div class="rounded shadow overflow-x-auto bg-white">
    <table class="w-full text-sm border">
        <thead>
            <tr>
                <th class="p-2 border">#</th>
                <th class="p-2 border">الموظف</th>
                <th class="p-2 border">الإدارة</th>
                <th class="p-2 border">نوع العهدة</th>
                <th class="p-2 border">تفاصيل</th>
                <th class="p-2 border">الحالة</th>
                <th class="p-2 border">المدير المختص</th>
                <th class="p-2 border">المدير المعتمد</th>
                <th class="p-2 border">تاريخ الطلب</th>
                <th class="p-2 border">الرقم التسلسلي</th>
                <th class="p-2 border">السعر</th>
                <th class="p-2 border">ملف الفاتورة</th>
                <th class="p-2 border">حالة التسليم</th>
                <th class="p-2 border">تاريخ التسليم</th>
                <th class="p-2 border no-print">إجراء</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($requests as $req): ?>
            <tr>
                <td class="p-2 border text-center"><?= $req['id'] ?></td>
                <td class="p-2 border"><?= htmlspecialchars($req['employee_name']) ?></td>
                <td class="p-2 border"><?= htmlspecialchars($req['department_name']) ?></td>
                <td class="p-2 border"><?= htmlspecialchars($req['asset_type_name'] ?? '—') ?></td>
                <td class="p-2 border"><?= nl2br(htmlspecialchars($req['details'])) ?></td>
                <td class="p-2 border font-bold text-center">
                    <span class="rounded px-3 py-1 <?= statusColor($req['status']) ?>">
                        <?= htmlspecialchars($req['status']) ?>
                    </span>
                </td>
                <td class="p-2 border"><?= $req['manager_name'] ?? '—' ?></td>
                <td class="p-2 border"><?= $req['approving_manager_name'] ?? '—' ?></td>
                <td class="p-2 border"><?= $req['created_at'] ?></td>
                <td class="p-2 border"><?= $req['serial_number'] ?? '—' ?></td>
                <td class="p-2 border"><?= $req['price'] ?? '—' ?></td>
                <td class="p-2 border">
    <?php if (!empty($req['invoice_filename']) && !empty($req['employee_number'])): ?>
        <a href="/erp_task_system/users/employee_files/<?= urlencode($req['employee_number']) ?>/<?= htmlspecialchars($req['invoice_filename']) ?>" target="_blank" class="text-blue-700 underline">عرض الفاتورة</a>
    <?php else: ?>
        —
    <?php endif; ?>
</td>

                <td class="p-2 border"><?= $req['handover_status'] ?? '—' ?></td>
                <td class="p-2 border"><?= $req['handover_created_at'] ?? '—' ?></td>
                <td class="p-2 border text-center no-print">
                    <form action="delete_asset_form.php" method="POST" onsubmit="return confirm('أكيد تبي تحذف العهدة؟');" style="display:inline;">
                        <input type="hidden" name="id" value="<?= $req['id'] ?>">
                        <button type="submit" class="bg-red-500 hover:bg-red-700 text-white rounded px-2 py-1">حذف</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>
</body>
</html>