<?php
session_start();
require_once '../config/db.php';
require_once '../authorize.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* السماح فقط للمدير والمدير العام */
if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'] ?? '', ['admin','manager'])) {
  header('Location: ../unauthorized.php'); exit;
}

/* المعرّف */
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { die('Bad user id'); }

/* جلب بيانات المستخدم */
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$id]);
$U = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$U) { die('User not found'); }

/* ثيم */
$user = $_SESSION['user'] ?? [];
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58','second_text_color'=>'#94a3b8'];
$userThemeColor            = $color['hex_code'];
$userThemeTextColor        = $color['text_color'];
$userThemeSecondTextColor  = $color['second_text_color'];
$userThemeNavColor         = $color['nav_color'] ?? '#233a58';

/* قوائم مساعدة */
$departments   = $conn->query("SELECT id, name FROM departments ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$work_shifts   = $conn->query("SELECT id, name, start_time, end_time, type FROM work_shifts")->fetchAll(PDO::FETCH_ASSOC);
$locations     = $conn->query("SELECT id, name FROM locations ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$salaryComponents = $conn->query("
  SELECT id, name, code, type
  FROM salary_components
  WHERE is_active = 1
  ORDER BY type, id
")->fetchAll(PDO::FETCH_ASSOC);
$projects = $conn->query("SELECT id, name FROM projects ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل مستخدم</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <style>
    body{ background: <?= $userThemeColor ?> }
    .card{ background: <?= $userThemeNavColor ?> }
    .text, label, h3, h2, th, td, select, input, textarea { color: <?= $userThemeTextColor ?> }
    .step-btn{ border:1px solid #cbd5e1; border-radius:.375rem; padding:.4rem .8rem; background:#fff; color:#111827; }
    .step-btn.active{ background:#2563eb; color:#fff; border-color:#2563eb; }
    .step-btn[disabled]{ opacity:.45; cursor:not-allowed; }
    .seg-btn{ border:1px solid #cbd5e1; border-radius:.375rem; padding:.25rem .75rem; background:#fff; color:#111827; }
    .seg-btn.active{ background:#2563eb; color:#fff; border-color:#2563eb; }
    #wizardBar{ position:sticky; bottom:0; z-index:30; background:rgba(17,24,39,.75); backdrop-filter: blur(6px); border-top:1px solid rgba(255,255,255,.1); }
    .hint{ color:#e5e7eb; font-size:.8rem }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-5xl mx-auto space-y-6">

    <!-- Stepper -->
    <div id="stepper" class="flex flex-wrap gap-2">
      <button class="step-btn" data-step="1">١. الأساسية</button>
      <button class="step-btn" data-step="2">٢. العنوان والاتصال</button>
      <button class="step-btn" data-step="3">٣. الهوية والجواز</button>
      <button class="step-btn" data-step="4">٤. الحساب البنكي</button>
      <button class="step-btn" data-step="5">٥. المواقع</button>
      <button class="step-btn" data-step="6">٦. الطوارئ</button>
      <button class="step-btn" data-step="7">٧. العائلة</button>
      <button class="step-btn" data-step="8">٨. المؤهلات</button>
      <button class="step-btn" data-step="9" id="btn-salary">٩. الراتب</button>
      <button class="step-btn" data-step="10" id="btn-contracts">١٠. العقود</button>
    </div>

    <!-- نموذج التعديل -->
    <form id="basicForm" enctype="multipart/form-data" class="space-y-6">
      <input type="hidden" name="user_id" value="<?= (int)$U['id'] ?>">

      <!-- 1) الأساسية -->
      <section data-step="1" class="card rounded shadow p-4">
        <h1 class="text-xl font-bold mb-4">✏️ تعديل البيانات الأساسية</h1>
        <div class="grid md:grid-cols-3 gap-3">

          <div>
            <label class="block text-sm mb-1">الاسم</label>
            <input class="w-full border rounded px-3 py-2 bg-white text-black" name="name" required value="<?= htmlspecialchars($U['name']??'') ?>">
          </div>

          <div>
            <label class="block text-sm mb-1">البريد</label>
            <input type="email" class="w-full border rounded px-3 py-2 bg-white text-black" name="email" required value="<?= htmlspecialchars($U['email']??'') ?>">
            <small id="email_hint" class="block mt-1 text-xs"></small>
          </div>

          <div>
            <label class="block text-sm mb-1">كلمة المرور (اتركها فاضية بدون تغيير)</label>
            <input type="password" class="w-full border rounded px-3 py-2 bg-white text-black" name="password">
          </div>

          <div>
            <label class="block text-sm mb-1">الجنس</label>
            <select name="gender" class="w-full border rounded px-3 py-2 bg-white text-black">
              <?php $g=$U['gender']??''; ?>
              <option value="">اختر</option>
              <option <?= $g==='ذكر'?'selected':'' ?>>ذكر</option>
              <option <?= $g==='أنثى'?'selected':'' ?>>أنثى</option>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">الديانة</label>
            <select name="religion" class="w-full border rounded px-3 py-2 bg-white text-black">
              <?php $r=$U['religion']??''; ?>
              <option value="">اختر</option>
              <option <?= $r==='مسلم'?'selected':'' ?>>مسلم</option>
              <option <?= $r==='غير مسلم'?'selected':'' ?>>غير مسلم</option>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">الحالة الاجتماعية</label>
            <?php $m=$U['marital_status']??''; ?>
            <select name="marital_status" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option value="">اختر</option>
              <option <?= $m==='أعزب'?'selected':'' ?>>أعزب</option>
              <option <?= $m==='متزوج'?'selected':'' ?>>متزوج</option>
              <option <?= $m==='مطلق'?'selected':'' ?>>مطلق</option>
              <option <?= $m==='أرمل'?'selected':'' ?>>أرمل</option>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">إيميل شخصي</label>
            <input name="personal_email" type="email" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['personal_email']??'') ?>">
          </div>

          <div>
            <label class="block text-sm mb-1">جوال شخصي</label>
            <input name="personal_phone" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['personal_phone']??'') ?>">
          </div>

          <div>
            <label class="block text-sm mb-1">الدور</label>
            <?php $role=$U['role']??'employee'; ?>
            <select name="role" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option value="admin"    <?= $role==='admin'?'selected':'' ?>>مدير نظام</option>
              <option value="manager"  <?= $role==='manager'?'selected':'' ?>>مدير</option>
              <option value="employee" <?= $role==='employee'?'selected':'' ?>>موظف</option>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">الإدارة</label>
            <select name="department_id" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option value="">بدون</option>
              <?php foreach($departments as $d): ?>
                <option value="<?= $d['id'] ?>" <?= (string)$U['department_id']===(string)$d['id']?'selected':'' ?>>
                  <?= htmlspecialchars($d['name']) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">وقت الدوام</label>
            <select name="work_shift_id" class="w-full border rounded px-3 py-2 bg-white text-black" required>
              <option value="">اختر</option>
              <?php foreach($work_shifts as $s): ?>
                <option value="<?= $s['id'] ?>" <?= (string)$U['work_shift_id']===(string)$s['id']?'selected':'' ?>>
                  <?= htmlspecialchars($s['name']) ?> (<?= $s['type'] ?>: <?= substr($s['start_time'],0,5) ?> - <?= substr($s['end_time'],0,5) ?>)
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">الموقع الرئيسي</label>
            <select name="location_id" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option value="">اختر</option>
              <?php foreach($locations as $l): ?>
                <option value="<?= $l['id'] ?>" <?= (string)$U['location_id']===(string)$l['id']?'selected':'' ?>>
                  <?= htmlspecialchars($l['name']) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">يوم الراحة</label>
            <?php $day_off = is_null($U['day_off']) ? '' : (string)$U['day_off']; ?>
            <select name="day_off" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option value="">بدون</option>
              <option value="6" <?= $day_off==='6'?'selected':'' ?>>السبت</option>
              <option value="0" <?= $day_off==='0'?'selected':'' ?>>الأحد</option>
              <option value="1" <?= $day_off==='1'?'selected':'' ?>>الاثنين</option>
              <option value="2" <?= $day_off==='2'?'selected':'' ?>>الثلاثاء</option>
              <option value="3" <?= $day_off==='3'?'selected':'' ?>>الأربعاء</option>
              <option value="4" <?= $day_off==='4'?'selected':'' ?>>الخميس</option>
              <option value="5" <?= $day_off==='5'?'selected':'' ?>>الجمعة</option>
            </select>
          </div>

          <div>
            <label class="block text-sm mb-1">الرقم الوظيفي</label>
            <input id="employee_number" name="employee_number" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['employee_number']??'') ?>">
            <small class="hint">ملاحظة: الرقم لازم يكون فريد</small>
          </div>

          <div>
            <label class="block text-sm mb-1">المسمّى الوظيفي</label>
            <input name="job_title" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['job_title']??'') ?>">
          </div>

          <div>
            <label class="block text-sm mb-1">تاريخ التوظيف</label>
            <input type="date" name="hire_date" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['hire_date']??'') ?>">
          </div>

          <div>
            <label class="block text-sm mb-1">الحالة الوظيفية</label>
            <?php $es=$U['employment_status']??'نشط'; ?>
            <select name="employment_status" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option <?= $es==='نشط'?'selected':'' ?>>نشط</option>
              <option <?= $es==='موقوف'?'selected':'' ?>>موقوف</option>
              <option <?= $es==='مستقيل'?'selected':'' ?>>مستقيل</option>
              <option <?= $es==='متعاقد'?'selected':'' ?>>متعاقد</option>
            </select>
          </div>

          <div>
            <label for="nationality" class="block text-sm mb-1">الجنسية</label>
            <input type="text" name="nationality" id="nationality" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['nationality']??'') ?>">
          </div>

          <div class="md:col-span-3 border-t border-white/10 pt-3"></div>

          <div>
            <label class="block text-sm mb-1">صورة الموظف (اختياري)</label>
            <input type="file" name="profile_image" accept="image/*" class="w-full border rounded px-3 py-2 bg-white text-black">
            <?php if (!empty($U['profile_image'])): ?>
              <div class="hint mt-1">الحالي: <?= htmlspecialchars(basename($U['profile_image'])) ?></div>
            <?php endif; ?>
          </div>

          <div>
            <label class="inline-flex items-center gap-2 mt-6">
              <input type="checkbox" name="can_sign" value="1" <?= !empty($U['can_sign'])?'checked':'' ?>> يستطيع التوقيع
            </label>
            <label class="inline-flex items-center gap-2 block mt-2">
              <input type="checkbox" name="can_transfer_tasks" value="1" <?= !empty($U['can_transfer_tasks'])?'checked':'' ?>> تحويل المهام بين الإدارات
            </label>
          </div>

          <div>
            <label class="block text-sm mb-1">درجة السرية</label>
            <?php $sl=$U['secret_level']??'normal'; ?>
            <select name="secret_level" class="w-full border rounded px-3 py-2 bg-white text-black">
              <option value="normal"     <?= $sl==='normal'?'selected':'' ?>>عادية</option>
              <option value="secret"     <?= $sl==='secret'?'selected':'' ?>>سرية</option>
              <option value="top_secret" <?= $sl==='top_secret'?'selected':'' ?>>سرية جدًا</option>
            </select>
          </div>

          <div class="md:col-span-2">
            <label class="block text-sm mb-1">ملف التوقيع (صورة) — اختياري</label>
            <input type="file" name="signature_file" accept="image/*" class="w-full border rounded px-3 py-2 bg-white text-black">
            <?php if (!empty($U['signature_file'])): ?>
              <div class="hint mt-1">الحالي: <?= htmlspecialchars(basename($U['signature_file'])) ?></div>
            <?php endif; ?>
          </div>
        </div>

        <div class="flex justify-end mt-4">
          <button id="btnSaveBasic" type="button" class="px-4 py-2 bg-blue-600 text-white rounded">حفظ التعديلات</button>
        </div>
        <div id="basicSaved" class="text-sm text-green-200 hidden mt-2">✅ تم حفظ التعديلات</div>
      </section>

      <!-- 2) العنوان والاتصال -->
      <section data-step="2" class="card rounded shadow p-4 hidden">
        <h2 class="text-lg font-bold mb-3">📍 العنوان والاتصال</h2>
        <div class="grid md:grid-cols-3 gap-3">
          <div><label class="block text-sm mb-1">المبنى</label><input name="address_building" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['address_building']??'') ?>"></div>
          <div><label class="block text-sm mb-1">الشارع</label><input name="address_street" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['address_street']??'') ?>"></div>
          <div><label class="block text-sm mb-1">الحي</label><input name="address_district" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['address_district']??'') ?>"></div>
          <div><label class="block text-sm mb-1">المدينة</label><input name="address_city" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['address_city']??'') ?>"></div>
          <div><label class="block text-sm mb-1">الرمز البريدي</label><input name="address_zip" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['address_zip']??'') ?>"></div>
          <div><label class="block text-sm mb-1">الرقم الإضافي</label><input name="address_additional_number" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['address_additional_number']??'') ?>"></div>

          <div><label class="block text-sm mb-1">إيميل العمل</label><input name="work_email" type="email" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['work_email']??'') ?>"></div>
          <div><label class="block text-sm mb-1">جوال العمل</label><input name="work_phone" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['work_phone']??'') ?>"></div>

          <div>
            <label class="block text-sm mb-1">شهادة العنوان الوطني (PDF/صورة)</label>
            <input type="file" name="national_address_certificate" accept=".pdf,image/*" class="w-full border rounded px-3 py-2 bg-white text-black">
            <?php if (!empty($U['national_address_certificate'])): ?>
              <div class="hint mt-1">الحالي: <?= htmlspecialchars(basename($U['national_address_certificate'])) ?></div>
            <?php endif; ?>
          </div>
        </div>
        <div class="flex justify-end mt-4">
          <button id="btnSaveAddress" type="button" class="px-4 py-2 bg-blue-600 text-white rounded">حفظ</button>
        </div>
      </section>

      <!-- 3) الهوية والجواز -->
      <section data-step="3" class="card rounded shadow p-4 hidden">
        <h2 class="text-lg font-bold mb-3">🪪 الهوية والجواز</h2>
        <div class="grid md:grid-cols-3 gap-3">
          <div><label class="block text-sm mb-1">الهوية (10 أرقام)</label><input name="national_id" maxlength="10" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['national_id']??'') ?>"></div>
          <div><label class="block text-sm mb-1">تاريخ إصدار الهوية</label><input type="date" name="national_id_issue_date" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['national_id_issue_date']??'') ?>"></div>
          <div><label class="block text-sm mb-1">مكان إصدار الهوية</label><input name="national_id_place" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['national_id_place']??'') ?>"></div>

          <div><label class="block text-sm mb-1">رقم الجواز</label><input name="passport_number" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['passport_number']??'') ?>"></div>
          <div><label class="block text-sm mb-1">مكان إصدار الجواز</label><input name="passport_place" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['passport_place']??'') ?>"></div>
          <div><label class="block text-sm mb-1">دولة الجواز</label><input name="passport_country" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['passport_country']??'') ?>"></div>
          <div><label class="block text-sm mb-1">تاريخ إصدار الجواز</label><input type="date" name="passport_issue_date" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['passport_issue_date']??'') ?>"></div>
          <div><label class="block text-sm mb-1">تاريخ انتهاء الجواز</label><input type="date" name="passport_expire_date" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['passport_expire_date']??'') ?>"></div>
        </div>
        <div class="flex justify-end mt-4">
          <button id="btnSaveIdentity" type="button" class="px-4 py-2 bg-blue-600 text-white rounded">حفظ</button>
        </div>
      </section>

      <!-- 4) الحساب البنكي -->
      <section data-step="4" class="card rounded shadow p-4 hidden">
        <h2 class="text-lg font-bold mb-3">🏦 الحساب البنكي</h2>
        <div class="grid md:grid-cols-3 gap-3">
          <div><label class="block text-sm mb-1">رقم الحساب البنكي</label><input name="bank_account" class="w-full border rounded px-3 py-2 bg-white text-black" value="<?= htmlspecialchars($U['bank_account']??'') ?>"></div>
          <div>
            <label class="block text-sm mb-1">IBAN</label>
            <input id="iban" name="iban" class="w-full border rounded px-3 py-2 uppercase bg-white text-black" placeholder="SA.." value="<?= htmlspecialchars($U['iban']??'') ?>">
            <small class="hint">اكتب الآيبان واطلع من الحقل للتعرّف على البنك تلقائيًا</small>
            <small id="iban_msg" class="block mt-1 text-xs"></small>
          </div>
          <div><label class="block text-sm mb-1">اسم البنك</label><input id="bank_name" name="bank_name" class="w-full border rounded px-3 py-2 bg-gray-50" readonly value="<?= htmlspecialchars($U['bank_name']??'') ?>"></div>
          <div>
            <label class="block text-sm mb-1">شهادة الآيبان (PDF/صورة)</label>
            <input type="file" name="iban_certificate" accept=".pdf,image/*" class="w-full border rounded px-3 py-2 bg-white text-black">
            <?php if (!empty($U['iban_certificate'])): ?>
              <div class="hint mt-1">الحالي: <?= htmlspecialchars(basename($U['iban_certificate'])) ?></div>
            <?php endif; ?>
          </div>
        </div>
        <div class="flex justify-end mt-4">
          <button id="btnSaveBank" type="button" class="px-4 py-2 bg-blue-600 text-white rounded">حفظ</button>
        </div>
      </section>

    </form>

    <!-- 5..10 — نفس أقسامك الحالية المعتمدة على الـAPIs -->
    <section data-step="5" class="card rounded shadow p-4 hidden" data-need-user>
      <h2 class="text-lg font-bold mb-3">📍 المواقع المصرّح بها</h2>
      <div id="loc_wrap" class="grid md:grid-cols-3 gap-2"></div>
      <button id="loc_save" class="px-3 py-2 rounded bg-blue-600 text-white mt-3">حفظ المواقع</button>
    </section>

    <section data-step="6" class="card rounded shadow p-4 hidden" data-need-user>
      <h2 class="text-lg font-bold mb-3">🚑 جهات الطوارئ</h2>
      <div class="grid md:grid-cols-5 gap-2 mb-3">
        <input id="ec_name" class="border rounded px-3 py-2 bg-white text-black" placeholder="الاسم">
        <input id="ec_phone" class="border rounded px-3 py-2 bg-white text-black" placeholder="الجوال">
        <input id="ec_rel"   class="border rounded px-3 py-2 bg-white text-black" placeholder="صلة القرابة">
        <label class="inline-flex items-center gap-2"><input id="ec_primary" type="checkbox"> أولوي</label>
        <button id="ec_save" type="button" class="px-3 py-2 bg-green-600 text-white rounded">حفظ</button>
      </div>
      <div id="ec_list" class="divide-y border rounded bg-white"></div>
    </section>

    <section data-step="7" class="card rounded shadow p-4 hidden" data-need-user>
      <h2 class="text-lg font-bold mb-3">👨‍👩‍👧‍👦 أفراد العائلة</h2>
      <div class="grid md:grid-cols-6 gap-2 mb-3">
        <input id="fm_id" type="hidden">
        <input id="fm_name" class="border rounded px-3 py-2 bg-white text-black" placeholder="الاسم">
        <select id="fm_rel" class="border rounded px-3 py-2 bg-white text-black">
          <option value="">صلة القرابة</option>
          <option>زوج</option><option>زوجة</option><option>ابن</option><option>ابنة</option>
          <option>أب</option><option>أم</option><option>أخ</option><option>أخت</option><option>أخرى</option>
        </select>
        <input id="fm_nid" class="border rounded px-3 py-2 bg-white text-black" placeholder="رقم الهوية">
        <input id="fm_birth" type="date" class="border rounded px-3 py-2 bg-white text-black">
        <label class="inline-flex items-center gap-2"><input id="fm_dep" type="checkbox" checked> معال</label>
        <button id="fm_save" type="button" class="px-3 py-2 bg-green-600 text-white rounded">حفظ</button>
      </div>
      <div id="fm_list" class="divide-y border rounded bg-white"></div>
    </section>

    <section data-step="8" class="card rounded shadow p-4 hidden" data-need-user>
      <h2 class="text-lg font-bold mb-3">🎓 المؤهلات</h2>
      <form id="uq_form" class="grid md:grid-cols-6 gap-2 mb-3" enctype="multipart/form-data">
        <input id="uq_id" name="id" type="hidden">
        <input name="degree" id="uq_degree" class="border rounded px-3 py-2 bg-white text-black" placeholder="المؤهل">
        <input name="major" id="uq_major" class="border rounded px-3 py-2 bg-white text-black" placeholder="التخصص">
        <input name="institution" id="uq_inst" class="border rounded px-3 py-2 bg-white text-black" placeholder="الجهة">
        <input name="country" id="uq_country" class="border rounded px-3 py-2 bg-white text-black" placeholder="الدولة">
        <input name="graduation_date" id="uq_date" type="date" class="border rounded px-3 py-2 bg-white text-black">
        <input name="grade" id="uq_grade" class="border rounded px-3 py-2 bg-white text-black" placeholder="التقدير">
        <input name="file" id="uq_file" type="file" class="md:col-span-3 bg-white text-black">
        <button id="uq_save" type="button" class="px-3 py-2 bg-blue-600 text-white rounded md:col-span-1">حفظ</button>
      </form>
      <div id="uq_list" class="divide-y border rounded bg-white"></div>
    </section>

    <section id="salary_section" data-step="9" class="card rounded shadow p-4 hidden" data-need-user>
      <h2 class="text-lg font-bold mb-3">💰 الراتب</h2>
      <!-- (نفس سكربت راتبك الحالي) -->
      <div class="hint">استخدم نفس منطق user_salary.php — ما عدّلته هنا</div>
    </section>

    <section data-step="10" class="card rounded shadow p-4 hidden" data-need-user>
      <h2 class="text-lg font-bold mb-3">📄 العقود</h2>
      <!-- (نفس سكربت العقود عندك) -->
      <div class="hint">القسم يشغّل /api/contracts.php بنفس طريقتك</div>
      <form id="ctr_form" class="space-y-4">
        <!-- ... (نفس حقك) ... -->
      </form>
      <div id="ctr_list" class="divide-y border rounded bg-white"></div>
    </section>

  </div>

<script>
let NEW_UID = null;
window.PROFILE_UID = <?= (int)$U['id'] ?>;

/* ===== Stepper ===== */
(function(){
  const sections = [...document.querySelectorAll('section[data-step]')];
  const btns = [...document.querySelectorAll('#stepper .step-btn')];
  let curr = 1;
  function show(step){
    curr = step;
    sections.forEach(s => s.classList.toggle('hidden', +s.dataset.step !== step));
    btns.forEach(b=> b.classList.toggle('active', +b.dataset.step === step));
    window.scrollTo({top:0, behavior:'smooth'});
  }
  btns.forEach(b => b.addEventListener('click', ()=> show(+b.dataset.step)));
  show(1);
})();

/* منع submit */
$('#basicForm').on('submit', e => e.preventDefault());

/* فحص الايميل مع استثناء نفس المستخدم */
let emailTimer = null;
$('#basicForm [name="email"]').on('input blur', function(){
  clearTimeout(emailTimer);
  const $btn = $('#btnSaveBasic');
  const $hint = $('#email_hint');
  let val = (this.value || '').trim().toLowerCase();

  // إذا ما تغيّر عن الأصلي: اعتبره OK ولا تعطل الزر
  if (!val || val === ORIGINAL_EMAIL) {
    $hint.text(val ? 'الإيميل لم يتغير' : '').removeClass('text-red-600').addClass('text-green-600');
    $btn.prop('disabled', false);
    return;
  }

  emailTimer = setTimeout(async ()=>{
    try{
      const url = `/erp_task_system/api/check_email.php?email=${encodeURIComponent(val)}&exclude_id=${encodeURIComponent(window.PROFILE_UID)}`;
      const r = await fetch(url);
      const j = await r.json();

      if (j.ok) {
        $hint.text('الإيميل متاح').removeClass('text-red-600').addClass('text-green-600');
        $btn.prop('disabled', false);
      } else {
        $hint.text('الإيميل مستخدم').removeClass('text-green-600').addClass('text-red-600');
        $btn.prop('disabled', true);    // عطّل الزر فقط إذا تغيّر وكان مستخدم
      }
    }catch(e){
      $hint.text('تعذر التحقق').removeClass('text-green-600').addClass('text-red-600');
      $btn.prop('disabled', false);     // لا تعطل الحفظ بسبب مشكلة شبكة
    }
  }, 350);
});

/* IBAN lookup */
function normalizeIBAN(raw){ return (raw||'').toString().replace(/\s+/g,'').toUpperCase(); }
let ibanTimer=null;
async function lookupIBAN(){
  const iban = normalizeIBAN($('#iban').val());
  $('#iban').val(iban);
  if (!iban || iban.length < 6){ $('#bank_name').val(''); $('#iban_msg').text(''); return; }
  const fd = new FormData(); fd.append('iban', iban);
  try{
    const r = await fetch('/erp_task_system/api/iban_lookup.php', { method:'POST', body:fd });
    const j = await r.json();
    if (j.ok){ $('#bank_name').val(j.bank_name || ''); $('#iban_msg').text(j.bank_code ? ('كود البنك: '+j.bank_code) : ''); }
    else    { $('#bank_name').val(''); $('#iban_msg').text(j.reason ? ('ما لقينا بنك مطابق ('+j.reason+')') : 'ما لقينا بنك مطابق'); }
  }catch(e){ console.error(e); $('#iban_msg').text('تعذر الاتصال بخدمة الآيبان'); }
}
$('#iban').on('input', function(){ clearTimeout(ibanTimer); ibanTimer = setTimeout(lookupIBAN, 400); });
$('#iban').on('blur', lookupIBAN);

/* حفظ التعديلات (الأساسية + كل اللي ظاهر داخل الفورم) */
async function saveSection(extra = {}) {
  const f = document.getElementById('basicForm');
  const fd = new FormData(f);
  Object.entries(extra).forEach(([k,v])=> fd.append(k,v));
  const r = await fetch('/erp_task_system/api/users_basic_update.php',{method:'POST',body:fd});
  const j = await r.json();
  if(!j.ok){ alert((j.msg || 'خطأ في الحفظ') + (j.err ? ("\n"+j.err) : '')); return false; }
  return true;
}

$('#btnSaveBasic').on('click', async ()=>{
  const ok = await saveSection({ part: 'basic' });
  if (ok) { $('#basicSaved').removeClass('hidden'); setTimeout(()=>$('#basicSaved').addClass('hidden'), 2000); }
});
$('#btnSaveAddress').on('click', ()=> saveSection({ part: 'address' }));
$('#btnSaveIdentity').on('click', ()=> saveSection({ part: 'identity' }));
$('#btnSaveBank').on('click', ()=> saveSection({ part: 'bank' }));

/* ===== الأقسام 5..10 (تعتمد APIs الحالية) ===== */
async function buildLocSelect(){
  const fd=new FormData(); fd.append('action','list'); fd.append('user_id',window.PROFILE_UID);
  const r=await fetch('/erp_task_system/api/user_locations.php',{method:'POST',body:fd});
  const j=await r.json(); const w=document.getElementById('loc_wrap'); w.innerHTML='';
  if(j.ok){ j.data.forEach(x=>{
    w.insertAdjacentHTML('beforeend',
      `<label class="flex items-center gap-2 p-2 border rounded bg-white text-black">
         <input type="checkbox" value="${x.id}" ${+x.assigned?'checked':''}>
         <span>${x.name}</span>
       </label>`);
  });}
}
$('#loc_save').on('click', async ()=>{
  const ids=[...document.querySelectorAll('#loc_wrap input[type=checkbox]:checked')].map(i=>i.value);
  const fd=new FormData(); fd.append('action','save'); fd.append('user_id',window.PROFILE_UID);
  ids.forEach(i=>fd.append('locations[]',i));
  const r=await fetch('/erp_task_system/api/user_locations.php',{method:'POST',body:fd});
  const j=await r.json(); if(!j.ok){ alert('فشل الحفظ'); return; } alert('تم الحفظ');
});

/* الطوارئ/العائلة/المؤهلات/العقود — نفس دوالك الحالية بالضبط (مختصرة هنا) */
async function ecList(){ /* ... نفس كودك ... */ }
async function fmList(){ /* ... */ }
async function uqList(){ /* ... */ }
async function ctrList(){ /* ... */ }

/* تشغيل التحميل الأولي لأقسام 5..10 */
document.addEventListener('DOMContentLoaded', ()=>{
  buildLocSelect();
  ecList(); fmList(); uqList(); ctrList();
});
</script>
<script>
  window.PROFILE_UID = <?= (int)$U['id'] ?>;
  const ORIGINAL_EMAIL = <?= json_encode(mb_strtolower($U['email'] ?? '')) ?>;
</script>

</body>
</html>
