<?php
require_once '../authorize.php';

// التحقق من الرقم الوظيفي
$employee_number = $_GET['id'] ?? null;
if (!$employee_number) {
    echo "<p class='text-red-600 p-4'>❌ لم يتم تحديد الموظف</p>";
    exit;
}

$folder_path = "../users/employee_files/" . $employee_number;

if (!is_dir($folder_path)) {
    echo "<p class='text-yellow-600 p-4'>🚫 لا يوجد مجلد لهذا الموظف حتى الآن</p>";
    exit;
}

$files = array_diff(scandir($folder_path), ['.', '..']);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>ملفات الموظف <?= htmlspecialchars($employee_number) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
    <div class="max-w-3xl mx-auto bg-white p-6 rounded shadow">
        <h2 class="text-xl font-bold mb-4">📁 ملفات الموظف رقم: <?= htmlspecialchars($employee_number) ?></h2>

        <?php if (empty($files)): ?>
            <p class="text-gray-500">لا توجد ملفات حالياً.</p>
        <?php else: ?>
            <ul class="space-y-2">
                <?php foreach ($files as $file): ?>
                    <li class="flex items-center justify-between border-b pb-2">
                        <span><?= htmlspecialchars($file) ?></span>
                        <div class="space-x-2">
                            <a href="<?= $folder_path . '/' . urlencode($file) ?>" target="_blank" class="text-blue-600 underline">🔽 تحميل</a>
                            <a href="delete_employee_file.php?id=<?= urlencode($employee_number) ?>&file=<?= urlencode($file) ?>" class="text-red-600 underline" onclick="return confirm('هل أنت متأكد من حذف الملف؟')">🗑️ حذف</a>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>

        <hr class="my-6">
        <h3 class="text-lg font-bold mb-2">📤 رفع ملف جديد:</h3>
        <form action="upload_employee_file.php" method="POST" enctype="multipart/form-data" class="space-y-4">
            <input type="hidden" name="employee_number" value="<?= htmlspecialchars($employee_number) ?>">
            <input type="file" name="file" required class="border p-2 w-full">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">رفع الملف</button>
        </form>
    </div>
</body>
</html>
