<?php
require_once '../config/db.php';
require_once '../authorize.php';

// جلب التقييمات مع أسماء الموظفين
$stmt = $conn->query("
  SELECT e.*, u.name AS employee_name 
  FROM employee_evaluations e
  JOIN users u ON e.employee_id = u.id
  ORDER BY e.evaluation_date DESC
");
$evaluations = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>قائمة التقييمات</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-5xl mx-auto bg-white shadow p-6 rounded">
<style>.rtl-left{ margin-right:auto; }</style>

<div class="flex items-center gap-2 mb-4">
  <h2 class="text-2xl font-bold">📋 قائمة التقييمات</h2>
  <a href="help_employee_evaluations.php" target="_blank"
     class="rtl-left inline-flex items-center gap-2 px-3 py-1.5 rounded-xl bg-gray-200 text-gray-900 hover:bg-gray-300">
❓ تعليمات
  </a>
</div>

    <table class="w-full border text-sm text-center">
      <thead class="bg-gray-200">
        <tr>
          <th class="p-2">الموظف</th>
          <th>الفترة</th>
          <th>التاريخ</th>
          <th>الانضباط</th>
          <th>جودة العمل</th>
          <th>إنجاز المهام</th>
          <th>التعاون</th>
          <th>التطوير الذاتي</th>
          <th>تقييم المدير</th>
          <th>المعدل</th>
          <th>نسبة إنجاز المهام</th>
          <th>ملاحظات</th>
          <th>📎 المهام</th>

        </tr>
      </thead>
      <tbody>
        <?php foreach ($evaluations as $e): ?>
          <tr class="border-b hover:bg-gray-50">
            <td class="p-2"><?= htmlspecialchars($e['employee_name']) ?></td>
            <td><?= $e['evaluation_period'] === 'monthly' ? 'شهري' : 'نصف سنوي' ?></td>
            <td><?= $e['evaluation_date'] ?></td>
            <td><?= $e['discipline'] ?></td>
            <td><?= $e['work_quality'] ?></td>
            <td><?= $e['task_completion'] ?></td>
            <td><?= $e['collaboration'] ?></td>
            <td><?= $e['self_development'] ?></td>
            <td><?= $e['manager_rating'] ?></td>
            <td><strong><?= $e['total_score'] ?></strong></td>
            <td><?= $e['task_completion_rate'] ?>%</td>
            <td><?= nl2br(htmlspecialchars($e['comments'])) ?></td>
            <td>
  <a href="view_tasks_by_evaluation.php?employee_id=<?= $e['employee_id'] ?>&evaluation_date=<?= $e['evaluation_date'] ?>&evaluation_period=<?= $e['evaluation_period'] ?>"
     target="_blank"
     class="text-blue-600 underline hover:text-blue-800 text-sm">عرض</a>
</td>

          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
