<?php
$employee_number = $_GET['id'] ?? null;

// مسار نظام الملفات (للقراءة بالـ PHP)
$baseDir  = __DIR__ . '/../users/employee_files';

// مسار الويب (للنقر من المتصفح) ـ عدّل حسب مكان مجلدك فعليًا
$baseUrl  = '/erp_task_system/users/employee_files';

$html = '';
$folder_path = $baseDir . '/' . $employee_number;

if (!$employee_number || !is_dir($folder_path)) {
    $html = '<div class="text-gray-400 text-center">لا توجد ملفات لهذا الموظف.</div>';
} else {
    $files = array_values(array_diff(scandir($folder_path), ['.', '.htaccess', '..']));
    if (empty($files)) {
        $html = '<div class="text-gray-400 text-center">لا توجد ملفات لهذا الموظف.</div>';
    } else {
        $html .= '<div class="flex gap-4 overflow-x-auto p-2">';
        foreach ($files as $file) {
            $url = $baseUrl . '/'
                 . rawurlencode($employee_number) . '/'
                 . rawurlencode($file); // مهم: rawurlencode عشان المسافات والعربي
            $html .= '<div class="min-w-[150px] bg-gray-100 p-3 rounded shadow flex flex-col items-center justify-between">';
            $html .= '<span class="truncate w-full block text-center text-xs mb-2">'
                  . htmlspecialchars($file, ENT_QUOTES, 'UTF-8') . '</span>';
            $html .= '<a href="' . $url . '" target="_blank" rel="noopener" class="text-blue-600 underline">🔽 تحميل</a>';
            $html .= '</div>';
        }
        $html .= '</div>';
    }
}
echo $html;
