<?php
session_start();
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];

// جلب بيانات الطلب
$asset_request_id = $_GET['id'] ?? null;
if (!$asset_request_id) {
    die("لم يتم تحديد الطلب.");
}
$stmt = $conn->prepare("SELECT ar.*, u.name AS employee_name, u.employee_number FROM asset_requests ar
    JOIN users u ON ar.user_id = u.id
    WHERE ar.id = ?");
$stmt->execute([$asset_request_id]);
$asset_request = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$asset_request) die("الطلب غير موجود.");
if ($asset_request['assigned_manager_id'] != $user['id']) die("ليس لديك صلاحية لتعبئة نموذج العهدة لهذا الطلب.");

// جلب أنواع العهدة
$stmt = $conn->query("SELECT id, name FROM asset_types ORDER BY name ASC");
$asset_types = $stmt->fetchAll(PDO::FETCH_ASSOC);


// عند إرسال النموذج
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $asset_type_id = $_POST['asset_type_id'] ?? '';
    $details       = $_POST['details'] ?? '';
    $serial_number = $_POST['serial_number'] ?? '';
    $price = $_POST['price'] ?? '';
    $terms         = $_POST['terms'] ?? '';
    $handover_date = $_POST['handover_date'] ?? '';
    $invoice_file  = $_FILES['invoice_file'] ?? null;

    // تحقق من القيم الأساسية
    if ($asset_type_id && $details && $serial_number) {
        // تجهيز مسار المجلد
// جلب رقم الموظف من قاعدة البيانات بناءً على user_id في الطلب
$stmtUser = $conn->prepare("SELECT employee_number FROM users WHERE id = ?");
$stmtUser->execute([$asset_request['user_id']]);
$employee_number = $stmtUser->fetchColumn() ?: 'unknown';
        $folder_path = "../users/employee_files/$employee_number";
        if (!is_dir($folder_path)) mkdir($folder_path, 0777, true);

        // معالجة ملف الفاتورة (اختياري)
        $invoice_filename = '';
        if ($invoice_file && $invoice_file['tmp_name']) {
            $allowed = ['pdf', 'jpg', 'jpeg', 'png'];
            $ext = strtolower(pathinfo($invoice_file['name'], PATHINFO_EXTENSION));
            if (in_array($ext, $allowed)) {
                $invoice_filename = 'invoice_' . time() . '.' . $ext;
                move_uploaded_file($invoice_file['tmp_name'], "$folder_path/$invoice_filename");
            } else {
                $msg = "صيغة الملف غير مدعومة.";
            }
        }

$stmt = $conn->prepare("INSERT INTO asset_hand_over_forms
    (asset_request_id, asset_type_id, details, serial_number, price, terms, handover_date, invoice_filename, created_by, employee_id, filled_by, form_data)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->execute([
    $asset_request_id,
    $asset_type_id,
    $details,
    $serial_number,
    $price ?: null,
    $terms,
    $handover_date ?: null,
    $invoice_filename,
    $user['id'],
    $asset_request['user_id'],
    $user['id'],
    ''
]);


        // تحديث حالة الطلب: ينتقل للموظف للموافقة
        $conn->prepare("UPDATE asset_requests SET status='بانتظار موافقة الموظف' WHERE id=?")->execute([$asset_request_id]);
        $msg = "تم حفظ النموذج بنجاح.";
    } else {
        $msg = "يرجى تعبئة جميع الحقول المطلوبة.";
    }
}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تعبئة نموذج العهدة</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
    body, .main-card, tr:hover, a:hover { background-color: <?= $userThemeColor ?> !important; }
    nav, .select2-results__option, .select2-search, .select2-selection--multiple, li, .card { background-color: <?= $userThemeNavColor ?> !important; }
    .text, label, h3, option, h2, th, td, li, strong, select, input, a { color: <?= $userThemeTextColor ?> !important; }
    option { text-align: center; }
    </style>
</head>
<body class="text-right">
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<div class="max-w-xl mx-auto card p-8 mt-10 rounded-lg shadow-lg">
    <h2 class="text-2xl font-bold mb-6 text-center">تعبئة نموذج العهدة</h2>
    <?php if ($msg): ?>
        <div class="mb-4 text-center py-2 px-3 rounded <?php if($msg == "تم حفظ النموذج بنجاح.") echo 'bg-green-100 text-green-700'; else echo 'bg-red-100 text-red-700'; ?>">
            <?= htmlspecialchars($msg) ?>
        </div>
    <?php endif; ?>
    <form method="post" enctype="multipart/form-data" class="space-y-4">
        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block mb-1 text">اسم الموظف</label>
                <input type="text" class="border rounded px-2 py-1 w-full bg-gray-100" value="<?= htmlspecialchars($asset_request['employee_name']) ?>" disabled>
            </div>
            <div>
                <label class="block mb-1 text">نوع العهدة</label>
                <select name="asset_type_id" required class="border rounded px-2 py-1 w-full">
                    <option value="">اختر نوع العهدة</option>
                    <?php foreach ($asset_types as $type): ?>
                        <option value="<?= $type['id'] ?>" <?= ($asset_request['asset_type_id'] ?? '') == $type['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($type['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <div>
            <label class="block mb-1 text">تفاصيل العهدة</label>
            <input name="details" required class="border rounded px-2 py-1 w-full" value="<?= htmlspecialchars($asset_request['details'] ?? '') ?>">
        </div>
        <div>
            <label class="block mb-1 text">الرقم التسلسلي</label>
            <input name="serial_number" required class="border rounded px-2 py-1 w-full" value="">
        </div>
        <div>
            <label class="block mb-1 text">قيمة المنتج (اختياري)</label>
            <input name="price" type="number" step="0.01" class="border rounded px-2 py-1 w-full" value="">
        </div>
        <div>
            <label class="block mb-1 text">الشروط</label>
            <textarea name="terms" class="border rounded px-2 py-1 w-full" rows="2"></textarea>
        </div>
        <div>
            <label class="block mb-1 text">تاريخ التسليم</label>
            <input name="handover_date" type="date" class="border rounded px-2 py-1 w-full" value="<?= date('Y-m-d') ?>">
        </div>
        <div>
            <label class="block mb-1 text">رفع فاتورة (PDF, JPG, PNG)</label>
            <input type="file" name="invoice_file" class="border rounded px-2 py-1 w-full">
        </div>
        <div class="text-center">
            <button class="bg-blue-600 text-white py-2 px-6 rounded hover:bg-blue-700">حفظ النموذج</button>
        </div>
    </form>
</div>
</body>
</html>