<?php
require_once '../config/db.php';

$employee_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$employee_id) {
  echo json_encode(['success' => false, 'evaluations' => []]);
  exit;
}

// جلب التقييمات مع اسم اللي قيمه
$stmt = $conn->prepare("
  SELECT e.*, u.name AS evaluator_name
  FROM employee_evaluations e
  LEFT JOIN users u ON e.created_by = u.id
  WHERE e.employee_id = ?
  ORDER BY e.evaluation_date DESC
");
$stmt->execute([$employee_id]);
$evaluations = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(['success' => true, 'evaluations' => $evaluations]);
exit;
