<?php
require_once '../config/db.php';
require_once '../authorize.php';
header('Content-Type: application/json; charset=utf-8');

try {
  $uid  = (int)($_GET['employee_id'] ?? 0);
  $type = $_GET['evaluation_period'] ?? 'monthly';   // monthly | semi_annual
  $ed   = $_GET['evaluation_date'] ?? date('Y-m-d'); // YYYY-MM-DD
  if ($uid <= 0) throw new Exception('bad_user');

  // نحسب الفترة
  $edObj = new DateTime($ed);
  if ($type === 'monthly') {
    $start = (clone $edObj)->modify('first day of this month')->format('Y-m-d');
  } else { // semi_annual = آخر 6 شهور من بداية الشهر
    $start = (clone $edObj)->modify('first day of -5 months')->format('Y-m-d');
  }
  $end = $edObj->format('Y-m-d');

  // معلومات المستخدم (القسم والشفت)
  $st = $conn->prepare("SELECT department_id, work_shift_id FROM users WHERE id=?");
  $st->execute([$uid]);
  $u = $st->fetch(PDO::FETCH_ASSOC) ?: ['department_id'=>null,'work_shift_id'=>null];
  $dept = (int)($u['department_id'] ?? 0);
  $shift_id = (int)($u['work_shift_id'] ?? 0);

  // أوقات الشفت
  if ($shift_id) {
    $q = $conn->prepare("SELECT start_time, end_time FROM work_shifts WHERE id=?");
    $q->execute([$shift_id]);
    $sh = $q->fetch(PDO::FETCH_ASSOC) ?: [];
  }
  $shift_start = ($sh['start_time'] ?? '08:00:00') ?: '08:00:00';
  $shift_end   = ($sh['end_time']   ?? '16:00:00') ?: '16:00:00';
  $grace = 15; // مهلة تأخير افتراضية بالدقائق

  // أيام الدوام للقسم
  $wd = [];
  if ($dept) {
    $q = $conn->prepare("SELECT day_of_week FROM department_work_days WHERE department_id=? AND is_working=1");
    $q->execute([$dept]);
    $days = $q->fetchAll(PDO::FETCH_COLUMN);
    foreach ($days as $d) {
      // نحترم القيم الرقمية 1..7 (MySQL: 1=الأحد)
      $wd[] = (int)$d;
    }
  }
  // لو ما فيه تعريف، نفترض الدوام أحد-خميس (1..5)
  if (!$wd) $wd = [1,2,3,4,5];

  // إجازات معتمدة ومتقاطعة مع الفترة
  $lv = $conn->prepare("
    SELECT start_date, end_date
    FROM leave_requests
    WHERE user_id=? AND (status='approved' OR status='مقبولة')
      AND NOT (end_date < ? OR start_date > ?)
  ");
  $lv->execute([$uid, $start, $end]);
  $leaveRanges = $lv->fetchAll(PDO::FETCH_ASSOC);
  $leaveDays = [];
  foreach ($leaveRanges as $r) {
    $s = new DateTime(max($start, $r['start_date']));
    $e = new DateTime(min($end,   $r['end_date']));
    while ($s <= $e) { $leaveDays[$s->format('Y-m-d')] = true; $s->modify('+1 day'); }
  }

  // الحضور للفترة
  $att = $conn->prepare("
    SELECT DATE(`date`) d, TIME(MIN(check_in)) in_time, TIME(MAX(check_out)) out_time
    FROM attendance
    WHERE user_id=? AND `date` BETWEEN ? AND ?
    GROUP BY DATE(`date`)
  ");
  $att->execute([$uid, $start, $end]);
  $attendance = [];
  while ($r = $att->fetch(PDO::FETCH_ASSOC)) $attendance[$r['d']] = $r;

  // المهام
  $q1 = $conn->prepare("SELECT COUNT(*) FROM tasks WHERE assigned_to=? AND created_at BETWEEN ? AND ?");
  $q1->execute([$uid, $start.' 00:00:00', $end.' 23:59:59']);
  $tasks_total = (int)$q1->fetchColumn();

  $q2 = $conn->prepare("SELECT COUNT(*) FROM tasks WHERE assigned_to=? AND completed_at IS NOT NULL AND completed_at BETWEEN ? AND ?");
  $q2->execute([$uid, $start.' 00:00:00', $end.' 23:59:59']);
  $tasks_done = (int)$q2->fetchColumn();

  // نحسب الغياب والتأخير
  $absences = 0.0;
  $late_cnt = 0;
  $halfDayMinutes = 240;

  $d = new DateTime($start); $E = new DateTime($end);
  while ($d <= $E) {
    $k = $d->format('Y-m-d');
    $dow = (int)$d->format('w'); // 0=السبت؟! لا، PHP: 0=الأحد؟ => نستخدم MySQL-style بدلها
    // نستخدم DAYOFWEEK MySQL: 1=Sunday..7=Saturday
    $dowStmt = $conn->query("SELECT DAYOFWEEK('".$k."')"); 
    $mysqlDow = (int)$dowStmt->fetchColumn(); // 1..7

    $isWorking = in_array($mysqlDow, $wd, true);
    if ($isWorking && empty($leaveDays[$k])) {
      $row = $attendance[$k] ?? null;
      if (!$row) {
        $absences += 1.0;
      } else {
        $in  = $row['in_time'];
        $out = $row['out_time'];
        $worked = 0;
        if ($in && $out) $worked = max(0, (int)round((strtotime($out)-strtotime($in))/60));
        if ($worked < $halfDayMinutes) $absences += 0.5;

        if ($in && (strtotime($in) > (strtotime($shift_start) + $grace*60))) $late_cnt++;
      }
    }
    $d->modify('+1 day');
  }

  echo json_encode([
    'ok'=>true,
    'period'=>['start'=>$start,'end'=>$end],
    'stats'=>[
      'tasks_total'=>$tasks_total,
      'tasks_completed'=>$tasks_done,
      'absences_days'=>$absences,
      'late_count'=>$late_cnt
    ]
  ], JSON_UNESCAPED_UNICODE);

} catch(Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
}
