<?php
require_once '../config/db.php';
require_once '../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ✅ تحقق الجلسة والصلاحيات الأساسية
if (
  !isset($_SESSION['user']) ||
  !isset($_SESSION['user']['name']) ||
  !isset($_SESSION['user']['email']) ||
  !isset($_SESSION['user']['role']) ||
  !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])
) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}

$user  = $_SESSION['user'];
$role  = $user['role'];
$department_id = $user['department_id'] ?? null;

// ✅ ثيم المستخدم
$color = $user['color'] ?? [
  'hex_code'          => '#0b1023',
  'second_text_color' => '#e9eefb',
  'text_color'        => '#e9eefb',
  'nav_color'         => '#121b35',
  'chart_color'       => 'rgba(111,125,251,.8)',
];
$userThemeColor           = $color['hex_code'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeTextColor       = $color['text_color'];
$userThemeNavColor        = $color['nav_color'];
$chartColor               = $color['chart_color'];
$currentUserColorId       = $user['color_id'] ?? null;

// ✅ اسم الإدارة + تعريف صلاحيات الوصول
$deptNameStmt = $conn->prepare("SELECT name FROM departments WHERE id = ?");
$deptNameStmt->execute([$department_id]);
$myDeptName = $deptNameStmt->fetchColumn() ?: ($user['department_name'] ?? '');

$isAdmin      = ($role === 'admin');
$isHRManager  = ($role === 'manager' && $myDeptName === 'إدارة الموارد البشرية');
$hrCanSeeMoney = ($isAdmin || $isHRManager); // أقسام الماليات ظاهرة لهم فقط

// ⛔️ هذه الصفحة خاصة بالأدمن ومدير الموارد البشرية فقط
if (!($isAdmin || $isHRManager)) {
  $_SESSION['error'] = 'غير مصرح بالدخول لهذه الصفحة. التعليمات هذه مخصصة للأدمن ومدير الموارد البشرية.';
  header('Location: ../unauthorized.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>📘 تعليمات صفحة إدارة المستخدمين</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
:root{
  --bg: <?= $userThemeColor ?>;
  --panel: <?= $userThemeNavColor ?>;
  --ink: <?= $userThemeTextColor ?>;
  --ink-2: <?= $userThemeSecondTextColor ?>;
  --ring:#c7d2fe; --ok:#16a34a; --warn:#f59e0b; --err:#ef4444;
  /* افتراضيات مطلوبة لقسم التواصل */
  --primary:#6f7dfb; 
  --muted:#9aa3b2;
}
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--panel); border:1px solid rgba(255,255,255,.07); border-radius:1rem; }
    .section{ padding:1rem; }
    .h1{ font-size:1.5rem; font-weight:800; }
    .h2{ font-size:1.125rem; font-weight:800; }
    .lead{ color:var(--ink-2); opacity:.95 }
    .toc a{ display:block; padding:.5rem .75rem; border-radius:.6rem; background:rgba(255,255,255,.05); }
    .toc a:hover{ background:rgba(255,255,255,.1); }
    .callout{ border-radius:.75rem; padding:.75rem .9rem; background:rgba(255,255,255,.06); border:1px dashed rgba(255,255,255,.2); }
    .callout.ok{ border-color:rgba(22,163,74,.45) }
    .callout.warn{ border-color:rgba(245,158,11,.45) }
    .callout.err{ border-color:rgba(239,68,68,.45) }
    .badge{ display:inline-flex; align-items:center; gap:.35rem; font-size:.8rem; padding:.25rem .55rem; border-radius:999px; background:rgba(255,255,255,.09) }
    .kbd{ font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; background:rgba(255,255,255,.08); padding:.1rem .45rem; border-radius:.4rem; font-size:.85em; }
    .anchor{ scroll-margin-top:7rem }
    .link{ color:#93c5fd; }

/* ========= طباعة محسّنة ========= */
@page {
  size: A4 portrait;
  margin: 10mm 10mm 14mm 10mm;
}
.print-only{ display:none; }

@media print{
  /* ألوان وخلفيات */
  :root{ --panel:#fff; --ink:#111827; --ink-2:#374151; }
  html, body{ background:#fff !important; color:#111827 !important;
    -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  body{ font-size:11pt; line-height:1.55; counter-reset: page; }

  /* إخفاءات */
  .no-print, nav, .navbar, #contact form, .btn, [onclick], 
  a[href^="javascript:"]{ display:none !important; }
  #charts, #links{ display:none !important; } /* أخفي الرسوم والروابط السريعة */
body{ font-size:10pt; line-height:1.45; }   /* تصغير بسيط للخط */
#contact{ display:none !important; }

/* رجّع الفهرس للطباعة (كان مختفي لأن nav مخفي) */
nav.toc{ display:block !important; }

/* شِل مسافة الهيدر الخاصة بالويب في الطباعة */
.h-20{ display:none !important; }

  /* ترويسة/تذييل ثابتين */
  .print-header, .print-footer{
    display:block !important; position:fixed; left:0; right:0; background:#fff; color:#6b7280;
  }
  .print-header{ top:0; padding:6px 10mm; border-bottom:1px solid #e5e7eb; }
  .print-footer{ bottom:0; padding:6px 10mm; border-top:1px solid #e5e7eb; }
  .print-footer .page:after{ content: counter(page); }
  .print-footer .pages:after{ content: counter(pages); }

  /* ترويسة/تذييل = نرفع المحتوى */
  .container-print{ margin-top:22mm !important; margin-bottom:18mm !important; }

  /* الحاوية والمسافات */
  .max-w-5xl{ max-width:100% !important; }
  .card{ background:#fff !important; border:1px solid #e5e7eb !important; box-shadow:none !important; }
  .section{ padding:.6rem .8rem !important; }
  header.card.section{ padding:.8rem 1rem !important; }
  .h1{ font-size:16pt !important; margin:0 0 .25rem !important; }
  .h2{ font-size:13pt !important; margin:0 0 .2rem !important; }
  .lead{ font-size:11pt !important; color:#374151 !important; }
  .badge{ background:transparent !important; padding:0 !important; }

  /* فهرس أعمدة لتقليل الصفحات */
  .toc{ columns:3; column-gap:8mm; }
  .toc a{ background:transparent !important; padding:.15rem 0 !important; break-inside:avoid; }

  /* منع الانقسام */
  .callout, .card, .anchor{ break-inside:avoid; page-break-inside:avoid; }
  .page-break{ break-before:page; page-break-before:always; }

  /* قسم التواصل: نخلي بيانات التواصل بس */
  #contact .grid{ display:block !important; }

  /* (اختياري) ضغط أكثر: أخفِ الرسوم/الروابط */
  /* #charts, #links{ display:none !important; } */
}

  </style>
</head>
<body>
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class="h-20"></div>
<div class="max-w-5xl mx-auto px-4 space-y-6 container-print">

<!-- ترويسة للطباعة فقط -->
<div class="print-only print-header">
  <div style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
    <div style="display:flex;align-items:center;gap:10px;">
      <img src="/erp_task_system/assets/img/fav.png" alt="ASRA" style="height:24px;width:auto;">
      <strong>تعليمات إدارة المستخدمين</strong>
    </div>
    <div style="font-size:10pt"><?= date('Y-m-d H:i') ?></div>
  </div>
</div>

<!-- تذييل للطباعة فقط -->
<div class="print-only print-footer">
  <div style="display:flex;align-items:center;justify-content:space-between;">
    <span>أسرع لتقنية المعلومات — 98RL</span>
    <span>صفحة <span class="page"></span> / <span class="pages"></span></span>
  </div>
</div>

  <div class="max-w-5xl mx-auto px-4 space-y-6">

    <!-- رأس الصفحة -->
    <header class="card section">
      <div class="flex items-start justify-between gap-3">
        <div>
          <h1 class="h1">📘 تعليمات استخدام <span class="whitespace-nowrap">صفحة إدارة المستخدمين</span></h1>
          <p class="lead mt-1">الصفحة هذه <strong>مخصصة للأدمن ومدير الموارد البشرية</strong>، وتشرح مهام الإدارة اليومية وخيارات الاعتماد والنقل والماليات.</p>
        </div>
        <div class="no-print flex items-center gap-2">
          <a href="index.php" class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700">⬅️ رجوع</a>
          <button onclick="window.print()" class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700">🖨️ طباعة</button>
        </div>
      </div>
    </header>

    <!-- فهرس -->
    <nav class="card section toc grid sm:grid-cols-2 lg:grid-cols-3 gap-2">
      <a href="#what">ماهي الصفحة؟</a>
      <a href="#drawer">قائمة الإجراءات (زر ☰)</a>
      <a href="#table">الجدول & كرت التفاصيل</a>
      <a href="#drag">السحب والإفلات</a>
      <a href="#pending">طلبات الإجازة/العهدة</a>
      <a href="#charts">الرسوم البيانية</a>
      <a href="#modals">المودالات</a>
      <a href="#policy">السياسات</a>
      <a href="#faq">مشاكل شائعة</a>
      <a href="#links">روابط سريعة</a>
      <a href="#addbtn">زر “تعليمات” للصفحة</a>
    </nav>

    <!-- ماهي الصفحة -->
    <section id="what" class="card section anchor">
      <h2 class="h2 mb-2">ماهي الصفحة؟</h2>
      <p>تعرض جميع المستخدمين وتوفر أدوات الإدارة: إضافة/تعديل/حذف، متابعة واعتماد الإجازات، تحويل العهدة، نقل الموظفين بين الإدارات والمواقع بالسحب والإفلات، واستعراض الإحصائيات والملفات والدورات. أقسام الماليات (الرواتب/المخالصات) ظاهرة فقط للأدمن ومدير HR.</p>
      <div class="callout ok mt-3">تلميح: اضغط على صف الموظف لفتح <strong>كرت تفاصيل</strong> فيه اختصارات: تعديل، ملفات، تقييم، تدريبات، تأخير/غياب.</div>
    </section>

    <!-- الدرج -->
    <section id="drawer" class="card section anchor">
      <h2 class="h2 mb-2">قائمة الإجراءات (زر ☰)</h2>
      <div class="grid sm:grid-cols-2 gap-3 mt-3">
        <div class="callout"><div class="font-bold mb-1">الأساسيات</div><ul class="list-disc pr-6 text-sm"><li>➕ إضافة مستخدم</li><li>👤 ملفي الشخصي</li></ul></div>
        <div class="callout"><div class="font-bold mb-1">الحضور والورديات</div><ul class="list-disc pr-6 text-sm"><li>🕒 تسجيل حضور — 📜 السجل — 🗓️ الورديات</li></ul></div>
        <div class="callout"><div class="font-bold mb-1">الإجازات</div><ul class="list-disc pr-6 text-sm"><li>🌴 إدارة الطلبات والموافقات</li></ul></div>
        <div class="callout"><div class="font-bold mb-1">العهدة والجزاءات</div><ul class="list-disc pr-6 text-sm"><li>📦 العهد — ⏱️ التأخير/الغياب</li></ul></div>
        <div class="callout"><div class="font-bold mb-1">التدريب والتقييم</div><ul class="list-disc pr-6 text-sm"><li>🎓 الدورات — ⭐ التقييمات</li></ul></div>
        <?php if ($hrCanSeeMoney): ?>
          <div class="callout ok"><div class="font-bold mb-1">الرواتب والتسويات</div><ul class="list-disc pr-6 text-sm"><li>💰 الرواتب — 📑 المخالصات</li></ul></div>
        <?php endif; ?>
        <div class="callout"><div class="font-bold mb-1">التأمينات والمواقع</div><ul class="list-disc pr-6 text-sm"><li>🧾 التأمينات — 📍 إدارة المواقع</li></ul></div>
      </div>
      <div class="mt-3 text-sm opacity-90">تقدر تقفل الدرج بزر <span class="kbd">Esc</span> أو بالنقر خارج اللوحة.</div>
    </section>

    <!-- الجدول -->
    <section id="table" class="card section anchor">
      <h2 class="h2 mb-2">الجدول & كرت تفاصيل الموظف</h2>
      <ul class="list-disc pr-6 space-y-1">
        <li>الأعمدة: الاسم، البريد، الدور، درجة السرّية، الإدارة، تحويل المهام، التوقيع، عرض التوقيع، الإجراءات.</li>
        <li>الضغط على الصف يفتح كرت التفاصيل وفيه اختصارات (تعديل/ملفات/تقييم/تدريبات/تأخير).</li>
        <li>الحذف يتم عبر <span class="kbd">POST</span> مع <span class="kbd">CSRF</span> لرفع الأمان.</li>
      </ul>
    </section>

    <!-- السحب والإفلات -->
    <section id="drag" class="card section anchor">
      <h2 class="h2 mb-2">السحب والإفلات — نقل الموظفين</h2>
      <p>تسحب بطاقة الموظف لعمود إدارة أو موقع مختلف للتحديث الفوري:</p>
    </section>

    <!-- قيد الانتظار -->
    <section id="pending" class="card section anchor">
      <h2 class="h2 mb-2">طلبات الإجازة/العهدة</h2>
      <ul class="list-disc pr-6 space-y-1">
        <li><strong>الإجازات</strong>: المدير يوافق إذا <em>manager_status</em> فاضي، وHR يعتمد إذا <em>hr_status</em> فاضي. الأدمن يقدر يحسم عند الحاجة.</li>
        <li><strong>العهدة</strong>: عند الموافقة تختار <em>المدير المختص</em> و<em>المدير المعتمد</em> قبل الإرسال.</li>
      </ul>
    </section>

    <!-- الرسوم -->
    <section id="charts" class="card section anchor">
      <h2 class="h2 mb-2">الرسوم البيانية</h2>
      <ul class="list-disc pr-6 space-y-1">
        <li>عدد الموظفين حسب <strong>الإدارة</strong>.</li>
        <li>عدد الموظفين حسب <strong>الموقع</strong>.</li>
      </ul>
    </section>

    <!-- المودالات -->
    <section id="modals" class="card section anchor">
      <h2 class="h2 mb-2">المودالات</h2>
      <ul class="list-disc pr-6 space-y-1">
        <li><strong>📂 ملفات الموظف</strong>: رفع/استعراض عبر</li>
        <li><strong>🎓 تدريبات</strong>: إضافة دورة (اسم/جهة/تاريخ/ساعات/ملاحظة/شهادة) عبر</li>
        <li><strong>⏱️ التأخير/الغياب</strong>: اختيار شهر/سنة وجلب التفاصيل من.</li>
      </ul>
    </section>

    <!-- السياسات -->
    <section id="policy" class="card section anchor">
      <h2 class="h2 mb-2">سياسات وأمن البيانات</h2>
      <ul class="list-disc pr-6 space-y-1">
        <li>حافظ على <strong>درجة السرّية</strong> لكل موظف.</li>
        <li>التعديلات/الحذف عمليات حسّاسة — تأكد من التفويض.</li>
        <li>تجنّب رفع ملفات شخصية دون حاجة.</li>
      </ul>
    </section>

<!-- تواصل مع الدعم الفني -->
<section id="contact" class="py-12 md:py-16" data-reveal>
<div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
<div class="card rounded-2xl p-6">
<h2 class="text-xl md:text-2xl font-bold text-[var(--ink)]">خلّنا نتواصل</h2>
<form id="contactForm" class="mt-4 grid gap-3">
<input id="c_name" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
<input id="c_email" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
<input id="c_phone" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
<textarea id="c_msg" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
<button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
<p id="contactResult" class="text-sm mt-1 opacity-90"></p>
</form>
</div>
<div>
<h3 class="text-2xl font-bold">بيانات التواصل</h3>
<ul class="mt-4 space-y-2 text-[var(--muted)]">
<li>الموقع: 98RL.LINK</li>
<li>البريد: 98rl@98rl.link</li>
<li>واتساب: +966535500241</li>
</ul>
<a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">تواصل واتساب مباشر</a>
</div>
</div>
</section>


<script>
// إرسال النموذج للواتساب مباشرة (بدون API)
(function(){
const form = document.getElementById('contactForm');
const res = document.getElementById('contactResult');
const WA_NUMBER = '966535500241'; // عدّل الرقم لو تغيّر
if(!form) return;
form.addEventListener('submit', function(e){
e.preventDefault();
const name = document.getElementById('c_name').value.trim();
const email = document.getElementById('c_email').value.trim();
const phone = document.getElementById('c_phone').value.trim();
const msg = document.getElementById('c_msg').value.trim();
if(!name || !msg){ res.textContent = 'الاسم والطلب مطلوبين'; return; }
const page = location.pathname;
const text = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email || '-'}
الجوال: ${phone || '-'}
الصفحة: ${page}
————————
الطلب:
${msg}`;
const url = `https://wa.me/${WA_NUMBER}?text=${encodeURIComponent(text)}`;
window.open(url, '_blank');
res.textContent = 'بيفتح لك واتساب برسالة جاهزة.. بس أرسلها ونخدمك 👍';
});
})();
</script>


    <!-- روابط -->
    <section id="links" class="card section anchor">
      <h2 class="h2 mb-2">روابط سريعة</h2>
      <div class="flex flex-wrap gap-2">
        <a class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700" href="index.php">👥 قائمة المستخدمين</a>
        <a class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700" href="add.php">➕ إضافة مستخدم</a>
        <a class="px-3 py-2 rounded-lg bg-sky-600 hover:bg-sky-700" href="attendance_log.php">📜 سجل الحضور</a>
        <a class="px-3 py-2 rounded-lg bg-amber-600 hover:bg-amber-700" href="trainings_list.php">🎓 الدورات</a>
        <?php if ($hrCanSeeMoney): ?>
          <a class="px-3 py-2 rounded-lg bg-pink-600 hover:bg-pink-700" href="salaries/index.php">💰 الرواتب</a>
          <a class="px-3 py-2 rounded-lg bg-fuchsia-600 hover:bg-fuchsia-700" href="settlements/index.php">📑 المخالصات</a>
        <?php endif; ?>
      </div>
    </section>


  </div> <!-- ✅ إغلاق الحاوية الرئيسية -->
</div><!-- /container-print -->

</body>
</html>
