<?php
session_start();
require_once '../config/db.php';
require_once '../authorize.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// نفس صلاحيات صفحة الإضافة: مدير/مدير عام فقط
if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'] ?? '', ['admin','manager'])) {
  header('Location: ../unauthorized.php'); exit;
}

$user  = $_SESSION['user'] ?? [];
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58','second_text_color'=>'#94a3b8'];
$userThemeColor            = $color['hex_code'];
$userThemeTextColor        = $color['text_color'];
$userThemeSecondTextColor  = $color['second_text_color'];
$userThemeNavColor         = $color['nav_color'] ?? '#233a58';

$pageTitle = 'تعليمات صفحة "إضافة مستخدم"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
:root{
  --bg: <?= $userThemeColor ?>;
  --ink: <?= $userThemeTextColor ?>;
  --muted: <?= $userThemeSecondTextColor ?>;
  --card: <?= $userThemeNavColor ?>;
  --ring: #2563eb;
  --primary: #22c55e; /* لون زر الإرسال (واتساب) */
}
    body{ background: var(--bg); color: var(--ink); }
    .card{ background: var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.4rem .7rem; border-radius:.5rem; }
    .toc a:hover{ background: rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .45rem; border-radius:.375rem; background:rgba(255,255,255,.08); }
    .callout{ border-inline-start:4px solid var(--ring); background: rgba(37,99,235,.08); }
    .kbd{ font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }

    /* بحث داخلي */
    .mark{ background: #fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }

    /* طباعة */
    @media print{
      .no-print{ display:none !important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ border:1px solid #e5e7eb; background:#fff; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- العمود الأيسر: الفهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#prereq">المتطلبات قبل البدء</a>
        <a href="#steps-pre">الخطوات 1–4 (قبل الإنشاء)</a>
        <a href="#steps-post">الخطوات 5–10 (بعد الإنشاء)</a>
        <a href="#salary">الراتب وبنوده</a>
        <a href="#contracts">العقود</a>
        <a href="#apis">واجهات الـ API المستخدمة</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#troubleshoot">أخطاء شائعة ومعالجتها</a>
        <a href="#privacy">الخصوصية والأمان</a>
        <a href="#related">روابط ذات صلة</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="window.location.href='/erp_task_system/users/add.php'" class="w-full px-3 py-2 rounded bg-blue-600 text-white">فتح صفحة الإضافة</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يعرض النتائج ويبرِز المطابقات.</small>
      </div>
    </aside>

    <!-- العمود الأيمن: المحتوى -->
    <main class="space-y-6">
      <header class="card rounded-2xl p-5">
        <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“إضافة مستخدم”</span></h1>
        <p class="opacity-90 mt-2">
          هذه الصفحة تُستخدم لإضافة موظف جديد للنظام على مراحل. بعد إنشاء السجل الأساسي، تنفتح لك بقية التبويبات لإكمال البيانات (المواقع، الطوارئ، العائلة، المؤهلات، الراتب، العقود).
        </p>
        <div class="callout rounded-xl p-3 mt-3">
          ✅ الصلاحية مطلوبة: <b>مدير نظام</b> أو <b>مدير</b>.  
          ✅ التحقق من البريد والآيبان والرقم الوظيفي يتم تلقائيًا من خلال خدمات داخلية.
        </div>
      </header>

      <!-- نظرة عامة -->
      <section id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">نظرة عامة</h2>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الخطوات <b>1–4</b> (البيانات الأساسية، الاتصال، الهوية، الحساب البنكي) تُحفظ عبر API واحد: <span class="badge">users_basic_create.php</span>.</li>
          <li>بعد الإنشاء تُفعل الخطوات <b>5–10</b> (مواقع، طوارئ، عائلة، مؤهلات، راتب، عقود) ولكل تبويب API مخصص.</li>
          <li>يوجد اقتراح تلقائي للرقم الوظيفي، وفحص تفرّد للبريد، وتعرّف بنك من الآيبان.</li>
        </ul>
      </section>

      <!-- المتطلبات -->
      <section id="prereq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">المتطلبات قبل البدء</h2>
          <a class="anchor" href="#prereq">#prereq</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>تجهيز <b>الإدارات</b> و<b>الورديات</b> و<b>المواقع</b> مسبقًا.</li>
          <li>تفعيل بنود الرواتب في <b>salary_components</b> (وضع <code class="kbd">is_active=1</code>).</li>
          <li>توفر اتصال بالـ APIs الداخلية المذكورة بالأسفل.</li>
        </ul>
      </section>

      <!-- 1–4 قبل الإنشاء -->
      <section id="steps-pre" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الخطوات 1–4 (قبل الإنشاء)</h2>
          <a class="anchor" href="#steps-pre">#steps-pre</a>
        </div>
        <ol class="list-decimal pr-6 mt-2 space-y-2">
          <li><b>الأساسية:</b> الاسم، البريد (يتحقق تلقائيًا من التكرار)، كلمة المرور، الدور، الإدارة، الدوام، الموقع الرئيسي، يوم الراحة، الرقم الوظيفي (اقتراح تلقائي)، الوظيفة، التوظيف، الجنسية، المرفقات الاختيارية (صورة/توقيع).</li>
          <li><b>العنوان والاتصال:</b> حقول العنوان + بريد وجوال العمل، ومرفق شهادة العنوان الوطني (PDF/صورة).</li>
          <li><b>الهوية والجواز:</b> رقم الهوية <b>10 أرقام</b>، بيانات الجواز للمقيمين.</li>
          <li><b>الحساب البنكي:</b> رقم الحساب والآيبان <b>SA</b> (24 خانة) والتعرّف على البنك تلقائيًا، وإرفاق شهادة الآيبان.</li>
        </ol>
        <div class="mt-3">
          <span class="badge">زر التنفيذ</span> اضغط <b>إنشاء المستخدم</b> لتفتح لك بقية التبويبات (5–10).
        </div>
      </section>

      <!-- 5–10 بعد الإنشاء -->
      <section id="steps-post" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الخطوات 5–10 (بعد الإنشاء)</h2>
          <a class="anchor" href="#steps-post">#steps-post</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>المواقع:</b> تحديد مواقع مسموحة للموظف (حفظ جماعي).</li>
          <li><b>الطوارئ:</b> إضافة جهات اتصال مع خيار “أولوية”.</li>
          <li><b>العائلة:</b> أفراد العائلة مع خيار “معال”.</li>
          <li><b>المؤهلات:</b> المؤهل/التخصص/الجهة/الدولة/التاريخ/التقدير + مرفق.</li>
          <li><b>الراتب:</b> الراتب الأساسي، اختيار البنود من <b>salary_components</b>، وحساب تلقائي لبدل السكن/النقل كنِسب.</li>
          <li><b>العقود:</b> نوع التوظيف (Segmented)، نوع العقد، الحالة، الفترات والتنبيهات، المشروع، الملاحظات، مع إجراءات (تعديل/تمديد/تجديد/إنهاء) ومرفقات للعقد.</li>
        </ul>
      </section>

      <!-- الراتب -->
      <section id="salary" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الراتب وبنوده</h2>
          <a class="anchor" href="#salary">#salary</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>أدخل <b>الأساسي</b>، ثم اختر البنود (بدل/علاوة/خصم…).</li>
          <li>يُنصح بتعريف أكواد للبنود الأساسية: <code class="kbd">BASIC</code>, <code class="kbd">HOUSING</code>, <code class="kbd">TRANSPORT</code> لتفعيل الحساب التلقائي.</li>
          <li>يمكن تعديل القيم يدويًّا، وزر <b>↺ تلقائي</b> يعيد الحسبة حسب النِسب.</li>
          <li>الإجمالي = مجموع الإضافات − مجموع الخصومات.</li>
        </ul>
      </section>

      <!-- العقود -->
      <section id="contracts" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">العقود</h2>
          <a class="anchor" href="#contracts">#contracts</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>تتبدّل أزرار Segmented بحسب اختيارك، والحقل “نهاية” يُخفى تلقائيًا عند <b>غير محدد المدة</b>.</li>
          <li>الإجراءات:
            <ul class="list-disc pr-6 mt-1 space-y-1">
              <li><b>تمديد:</b> تغيير تاريخ النهاية.</li>
              <li><b>تجديد:</b> يبدأ عقد جديد ويمكن إغلاق القديم تلقائيًا.</li>
              <li><b>إنهاء:</b> إقفال العقد الحالي.</li>
              <li><b>مرفقات:</b> رفع ملفات مرتبطة بالعقد وإدارتها.</li>
            </ul>
          </li>
        </ul>
      </section>

      <!-- APIs -->
      <section id="apis" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">واجهات الـ API المستخدمة</h2>
          <a class="anchor" href="#apis">#apis</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1 text-sm">
          <li><code class="kbd">/erp_task_system/api/check_email.php</code> — فحص تفرّد البريد.</li>
          <li><code class="kbd">/erp_task_system/api/next_employee_number.php</code> — اقتراح رقم وظيفي.</li>
          <li><code class="kbd">/erp_task_system/api/iban_lookup.php</code> — تعرّف البنك من الآيبان.</li>
          <li><code class="kbd">/erp_task_system/api/users_basic_create.php</code> — حفظ الخطوات 1–4.</li>
          <li><code class="kbd">/erp_task_system/api/user_locations.php</code> — إدارة المواقع.</li>
          <li><code class="kbd">/erp_task_system/api/emergency_contacts.php</code> — جهات الطوارئ.</li>
          <li><code class="kbd">/erp_task_system/api/family_members.php</code> — أفراد العائلة.</li>
          <li><code class="kbd">/erp_task_system/api/user_qualifications.php</code> — المؤهلات.</li>
          <li><code class="kbd">/erp_task_system/api/user_salary.php</code> — الراتب والبنود.</li>
          <li><code class="kbd">/erp_task_system/api/contracts.php</code> — العقود وإجراءاتها.</li>
        </ul>
      </section>

      <!-- FAQ -->
      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أسئلة شائعة</h2>
          <a class="anchor" href="#faq">#faq</a>
        </div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش ما انفتحَت تبويبات 5–10؟</summary>
          <p class="mt-2 opacity-90">لازم أولًا تنشئ المستخدم من الخطوات 1–4 بنجاح. بعدها تتفعّل التبويبات تلقائيًا.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">كيف أغيّر نِسب السكن/النقل الافتراضية؟</summary>
          <p class="mt-2 opacity-90">من تبويب الراتب غيّر الحقول <b>سكن %</b> و<b>نقل %</b>، واضغط “↺ تلقائي”.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">العقد غير محدد المدة وما أبي يظهر “نهاية”.</summary>
          <p class="mt-2 opacity-90">اختَر “غير محدد المدة” وحيختفي حقل النهاية تلقائيًا.</p>
        </details>
      </section>

      <!-- أخطاء شائعة -->
      <section id="troubleshoot" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أخطاء شائعة ومعالجتها</h2>
          <a class="anchor" href="#troubleshoot">#troubleshoot</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>الإيميل مستخدم:</b> جرّب بريد آخر. التحقق يتم عبر <code class="kbd">check_email.php</code>.</li>
          <li><b>الآيبان غير معروف:</b> تأكد يبدأ بـ <b>SA</b> وطوله 24 خانة، ثم أعد الإدخال ليُعاد التعرف.</li>
          <li><b>فشل إنشاء المستخدم:</b> راجع رسالة الخطأ من <code class="kbd">users_basic_create.php</code>، وتأكد من الحقول المطلوبة (الدوام/الإدارة إذا كانت مطلوبة عندكم).</li>
          <li><b>تداخل عقود:</b> إذا رجّع API قيمة <code class="kbd">overlap</code>، عدّل تواريخ البداية/النهاية أو أنهِ العقد السابق.</li>
        </ul>
      </section>

      <!-- الخصوصية -->
      <section id="privacy" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الخصوصية والأمان</h2>
          <a class="anchor" href="#privacy">#privacy</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الهوية والآيبان وملفات العقود تُحفظ لاستخدامات الموارد البشرية فقط.</li>
          <li>يُفضّل تقييد الوصول للملفات الحسّاسة وفق درجات السرّية داخل النظام.</li>
        </ul>
      </section>

      <!-- روابط -->
      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">روابط ذات صلة</h2>
          <a class="anchor" href="#related">#related</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="/erp_task_system/users/add.php">صفحة إضافة مستخدم</a></li>
          <li><a class="underline" href="/erp_task_system/users/list.php">قائمة المستخدمين</a></li>
          <li><a class="underline" href="/erp_task_system/roles/">الصلاحيات والأدوار</a></li>
        </ul>
      </section>
    </main>
  </div>
<!-- تواصل -->
<section id="contact" class="py-12 md:py-16">
  <div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
    <div class="card rounded-2xl p-6">
      <h2 class="text-xl md:text-2xl font-bold">خلّنا نتواصل</h2>
      <form id="contactForm" class="mt-4 grid gap-3">
        <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
        <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
        <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
        <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
        <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
        <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
      </form>
    </div>
    <div>
      <h3 class="text-2xl font-bold">بيانات التواصل</h3>
      <ul class="mt-4 space-y-2" style="color:var(--muted)">
        <li>الموقع: 98RL.LINK</li>
        <li>البريد: 98rl@98rl.link</li>
        <li>واتساب: +966535500241</li>
      </ul>
      <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">تواصل واتساب مباشر</a>
    </div>
  </div>
</section>

<script>
/* إرسال واتساب مباشرة */
(function(){
  const f = document.getElementById('contactForm');
  const r = document.getElementById('contactResult');
  const WA = '966535500241'; // غيّر الرقم هنا لو تبي

  if(!f) return;

  f.addEventListener('submit', (e)=>{
    e.preventDefault();
    const name  = document.getElementById('c_name').value.trim();
    const email = document.getElementById('c_email').value.trim();
    const phone = document.getElementById('c_phone').value.trim();
    const msg   = document.getElementById('c_msg').value.trim();

    if(!name || !msg){
      r.textContent = 'الاسم والطلب مطلوبين';
      return;
    }

    const txt = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;

    const url = `https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
    const w = window.open(url, '_blank');
    if (w) w.opener = null; // أمان إضافي
    r.textContent = 'بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
  });
})();
</script>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m => {
        const txt = document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt, m);
      });
    }
    function highlight(root, term){
      if(!term) return;
      const rx = new RegExp('('+term.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')+')', 'gi');
      root.querySelectorAll('p, li').forEach(node=>{
        if(!node.childNodes || !node.childNodes.length) return;
        node.childNodes.forEach(ch=>{
          if(ch.nodeType === Node.TEXT_NODE){
            const span = document.createElement('span');
            span.innerHTML = ch.textContent.replace(rx, '<mark class="mark">$1</mark>');
            if(span.innerHTML !== ch.textContent){
              ch.parentNode.replaceChild(span, ch);
            }
          }
        });
      });
    }

    q.addEventListener('input', ()=>{
      const term = q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit = s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display = hit ? '' : 'none';
        if(hit) highlight(s, term);
      });
    });
  </script>
</body>
</html>
