<?php
// /erp_task_system/assets/help_asset_requests.php  (عدّل المجلد حسب مسارك)
session_start();
require_once '../config/db.php';
require_once '../authorize.php';

if (!isset($_SESSION['user'])) { header('Location: ../unauthorized.php'); exit; }

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "إدارة العهد"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .chip{ display:inline-block; padding:2px 8px; border-radius:9999px; font-size:.75rem; margin-left:.35rem }
    .b-amber{ background:#fef3c7; color:#92400e }
    .b-red{   background:#fee2e2; color:#991b1b }
    .b-green{ background:#dcfce7; color:#166534 }
    .b-blue{  background:#e0f2fe; color:#0369a1 }
    .b-slate{ background:#e2e8f0; color:#334155 }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }

    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#filters">الفلاتر والبحث</a>
        <a href="#columns">أعمدة الجدول</a>
        <a href="#status">ألوان الحالات</a>
        <a href="#invoice">الفاتورة والمرفقات</a>
        <a href="#export-print">التصدير والطباعة</a>
        <a href="#security">الأمان والحذف</a>
        <a href="#tech">ملاحظات تقنية من الكود</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <!-- عدّل المسار حسب ملفك -->
        <button onclick="history.back()" class="w-full px-3 py-2 rounded bg-blue-600 text-white">الرجوع للصفحة</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“إدارة العهد”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          الصفحة تعرض طلبات العهد (الأصول/الأدوات) مع بيانات الموظف والإدارة، حالة الطلب، معلومات التسليم، ورابط الفاتورة إن وُجد. تقدر تبحث وتفلتر وتصدّر النتائج إلى Excel أو تطبع التقرير.
        </p>
      </header>

      <section id="filters" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الفلاتر والبحث</h2>
          <a class="anchor" href="#filters">#filters</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>كلمة بحث…</b> تبحث في: اسم الموظف، نوع العهدة، <span class="kbd">status</span>، اسم الإدارة، الرقم التسلسلي، رقم الطلب، السعر، تاريخ الطلب/التسليم.</li>
          <li><b>الإدارة:</b> اختيار إدارة معيّنة.</li>
          <li><b>من تاريخ / إلى تاريخ:</b> يفلتر على <span class="kbd">DATE(ar.created_at)</span>.</li>
          <li>زر <b>🔍 بحث</b> يعرض النتائج بالفلاتر المحددة.</li>
        </ul>
      </section>

      <section id="columns" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أعمدة الجدول</h2>
          <a class="anchor" href="#columns">#columns</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>#، الموظف، الإدارة</b> — من جدول <span class="kbd">users</span> و<span class="kbd">departments</span>.</li>
          <li><b>نوع العهدة / التفاصيل</b> — من <span class="kbd">asset_requests</span>.</li>
          <li><b>الحالة</b> — شارة ملوّنة حسب النص (التفاصيل لاحقًا).</li>
          <li><b>المدير المختص / المدير المعتمد</b> — أسماء المستخدمين المرتبطين بالحقلين.</li>
          <li><b>تاريخ الطلب</b> — <span class="kbd">ar.created_at</span>.</li>
          <li><b>الرقم التسلسلي / السعر / ملف الفاتورة / حالة التسليم / تاريخ التسليم</b> — من <span class="kbd">asset_hand_over_forms</span> إن وُجد ربط.</li>
          <li><b>إجراء</b> — حذف السجل (خارج الطباعة).</li>
        </ul>
      </section>

      <section id="status" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">ألوان الحالات</h2>
          <a class="anchor" href="#status">#status</a>
        </div>
        <p class="opacity-90 mt-2">يتم التلوين بـ <span class="kbd">statusColor()</span> حسب وجود كلمات داخل الحالة:</p>
        <p class="mt-2">
          <span class="chip b-amber">”بانتظار“ … أصفر</span>
          <span class="chip b-red">”مرفوضة“ … أحمر</span>
          <span class="chip b-green">”تم التنفيذ/تم التسليم/منفذة“ … أخضر</span>
          <span class="chip b-blue">”اعتماد المدير/المدير المختص“ … أزرق</span>
          <span class="chip b-slate">غير ذلك … رمادي</span>
        </p>
      </section>

      <section id="invoice" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الفاتورة والمرفقات</h2>
          <a class="anchor" href="#invoice">#invoice</a>
        </div>
        <p class="mt-2">
          إذا توفّر <span class="kbd">invoice_filename</span> و <span class="kbd">employee_number</span> يظهر رابط <b>عرض الفاتورة</b> لمسار:
        </p>
        <pre class="kbd" style="display:block;white-space:pre-wrap">/erp_task_system/users/employee_files/{employee_number}/{invoice_filename}</pre>
        <p class="opacity-90 mt-2">احرص على صلاحيات مجلد الملفات وتنظيف أسماء الملفات، ويفضّل رفعها بمجلد فرعي خاص بالعُهد.</p>
      </section>

      <section id="export-print" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">التصدير والطباعة</h2>
          <a class="anchor" href="#export-print">#export-print</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>📥 تصدير Excel:</b> يشتغل عبر <span class="kbd">GET ?export=excel</span> ويصدّر النتائج الحالية (بعد تطبيق الفلاتر).</li>
          <li><b>🖨️ الطباعة:</b> أنماط طباعة مُهيأة (RTL، إخفاء عناصر التحكم، حجم Landscape).</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الأمان والحذف</h2>
          <a class="anchor" href="#security">#security</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>الحذف يتم عبر <span class="kbd">POST</span> إلى <span class="kbd">delete_asset_form.php</span> مع تأكيد نافذة. يُنصح إضافة رمز <span class="kbd">CSRF</span> (حقل مخفي) والتحقق منه في الخادم.</li>
          <li>عند عرض البيانات في الجدول، يتم استخدام <span class="kbd">htmlspecialchars</span> و <span class="kbd">nl2br</span> بشكل صحيح.</li>
        </ul>
      </section>

      <section id="tech" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">ملاحظات تقنية من الكود</h2>
          <a class="anchor" href="#tech">#tech</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2 text-sm">
          <li>الاستعلام الرئيسي يجمع من:
            <span class="kbd">asset_requests ar</span> +
            <span class="kbd">users u</span> +
            <span class="kbd">departments d (LEFT)</span> +
            <span class="kbd">users m</span> (المدير المختص) +
            <span class="kbd">users ma</span> (المعتمد) +
            <span class="kbd">asset_hand_over_forms hf (LEFT)</span>.</li>
          <li>البحث العام يستخدم <span class="kbd">LIKE</span> على عدّة أعمدة (بما فيها <span class="kbd">ar.id</span>). هذا ممتاز للمرونة لكن ممكن يثقل الاستعلام — فكّر لاحقًا في فلاتر منفصلة للـ <span class="kbd">status</span> و”وجود فاتورة“ و”وجود تسليم“.</li>
          <li><b>CSS ملاحظة:</b> انتبه لوجود <span class="kbd">&lt;style&gt;&lt;style&gt;</span> متداخلة في صفحتك الأصلية؛ احذف الزائدة. وبرضه سطر:
            <span class="kbd">a:hover { background-color: ... !important; }</span>
            قد يغيّر شكل الروابط بشكل مزعج — يفضّل عدم تعميمه.</li>
          <li>أداء: أضف فهارس على <span class="kbd">(user_id)</span> و <span class="kbd">(created_at)</span> في <span class="kbd">asset_requests</span>، وعلى <span class="kbd">(asset_request_id)</span> في <span class="kbd">asset_hand_over_forms</span>.</li>
        </ul>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">تحسينات مقترحة</h2>
          <a class="anchor" href="#improve">#improve</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>فلتر حالة الطلب (بانتظار/معتمد/مرفوض/مُنفَّذ…).</li>
          <li>فلتر “مع فاتورة فقط” و“مع تسليم فقط”.</li>
          <li>تلوين الصف كاملاً حسب الحالة لتسهيل القراءة.</li>
          <li>تصدير CSV/Excel للفلاتر الحالية مع تنسيقات رقمية للسعر.</li>
          <li>ترقيم صفحات (Pagination) إذا زادت السجلات.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أسئلة شائعة</h2>
          <a class="anchor" href="#faq">#faq</a>
        </div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش رابط الفاتورة ما يفتح؟</summary>
          <p class="mt-2 opacity-90">تأكد من وجود <span class="kbd">invoice_filename</span> ورقم موظف <span class="kbd">employee_number</span> صحيحين، وصلاحيات مجلد الملفات.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">التصدير يطلع عربي “مكبوس”؟</summary>
          <p class="mt-2 opacity-90">استخدم Excel بنسخة تدعم UTF-8. ولو احتجت CSV بترميز UTF-8 مع BOM نقدر نضيفه.</p>
        </details>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">روابط ذات صلة</h2>
          <a class="anchor" href="#related">#related</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="asset_requests.php">إدارة العهد (الصفحة الرئيسية)</a></li>
          <li><a class="underline" href="/erp_task_system/users/list.php">قائمة الموظفين</a></li>
          <li><a class="underline" href="/erp_task_system/assets/forms/">نماذج التسليم</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">خلّنا نتواصل</h2>
          <a class="anchor" href="#contact">#contact</a>
        </div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const txt=document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
