<?php
// /erp_task_system/.../help_employee_trainings.php
session_start();
require_once '../config/db.php';
require_once '../authorize.php';

if (!isset($_SESSION['user'])) { header('Location: ../unauthorized.php'); exit; }

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "سجل الدورات التدريبية"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#filters">الفلاتر وطريقة البحث</a>
        <a href="#columns">أعمدة الجدول</a>
        <a href="#certs">الشهادات والمرفقات</a>
        <a href="#tech">ملاحظات تقنية من الكود</a>
        <a href="#best">تحسينات مقترحة</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <!-- عدّل الرابط هنا لاسم صفحتك لو يختلف -->
        <button onclick="window.location.href='employee_trainings.php'"
                class="w-full px-3 py-2 rounded bg-blue-600 text-white">
          فتح سجل الدورات
        </button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يعرض النتائج ويبرز الكلمات المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“سجل الدورات التدريبية”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تعرِض الصفحة جميع الدورات التدريبية المسجَّلة للموظفين مع إمكانية الفلترة بحسب الموظف ونطاق التاريخ، وإظهار الشهادة إن وُجدت.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول للصفحة حسب إعدادات <span class="kbd">authorize.php</span> (عادةً المدير أو مدير النظام).</li>
          <li>تُسحب أسماء الموظفين من جدول <span class="kbd">users</span> للفلترة.</li>
        </ul>
      </section>

      <section id="filters" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الفلاتر وطريقة البحث</h2><a class="anchor" href="#filters">#filters</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>الموظف:</b> اختر موظفًا معيّنًا أو اتركه “الكل”.</li>
          <li><b>من تاريخ / إلى تاريخ:</b> يحددان نطاق التاريخ لحقل <span class="kbd">course_date</span>.</li>
          <li>زر <b>🔍 تصفية</b> يعرض النتائج وفق الفلاتر المختارة بتمريرها عبر <span class="kbd">GET</span>.</li>
        </ul>
      </section>

      <section id="columns" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أعمدة الجدول</h2><a class="anchor" href="#columns">#columns</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>الموظف:</b> الاسم من <span class="kbd">users.name</span>.</li>
          <li><b>اسم الدورة • الجهة • التاريخ • الساعات:</b> من جدول <span class="kbd">employee_trainings</span>.</li>
          <li><b>ملاحظات:</b> آراء الموظف/تفاصيل الدورة؛ تُعرَض مع احترام أسطر جديدة.</li>
          <li><b>📎 الشهادة:</b> رابط عرض/تحميل إن كان <span class="kbd">certificate_path</span> موجودًا.</li>
        </ul>
      </section>

      <section id="certs" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الشهادات والمرفقات</h2><a class="anchor" href="#certs">#certs</a></div>
        <p class="mt-2">
          يحتفظ الحقل <span class="kbd">certificate_path</span> بمسار الملف. عند توفره يظهر زر <b>عرض/تحميل</b> يفتح الملف في تبويب جديد.
          يُفضّل حفظ الملفات داخل مجلد آمن (مثل <span class="kbd">/uploads/trainings/</span>) مع فحص الامتدادات.
        </p>
      </section>

      <section id="tech" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">ملاحظات تقنية من الكود</h2><a class="anchor" href="#tech">#tech</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2 text-sm">
          <li>الفلترة تُبنى عبر استعلام مُحضَّر (Prepared) على جدول <span class="kbd">employee_trainings</span> مع ضمّ <span class="kbd">users</span>.</li>
          <li><b>تنبيه مهم:</b> في نهاية الكود عندك استعلام ثانٍ:
            <span class="kbd">$stmt = $conn->query("SELECT t.*, u.name ... ORDER BY t.course_date DESC");</span>
            ثم <span class="kbd">$trainings = $stmt->fetchAll(...)</span>—وهذا يُعيد تحميل النتائج كاملة ويتجاهل الفلاتر.
            <br/>احذف الكتلة الثانية عشان الفلاتر تشتغل:
<pre class="kbd" style="display:block;white-space:pre-wrap">
/* احذف من هنا */
// $stmt = $conn->query("SELECT t.*, u.name AS employee_name ...");
// $trainings = $stmt->fetchAll(PDO::FETCH_ASSOC);
/* إلى هنا */
</pre>
          </li>
          <li>أمان المخرجات: تُستخدم <span class="kbd">htmlspecialchars</span> و <span class="kbd">nl2br</span> بشكل سليم لعرض النصوص.</li>
          <li>أداء مُستحسن: أضف فهارس (INDEX) على <span class="kbd">(employee_id)</span> و <span class="kbd">(course_date)</span> لتحسين سرعة البحث.</li>
        </ul>
      </section>

      <section id="best" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحسينات مقترحة</h2><a class="anchor" href="#best">#best</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>زر <b>تصدير CSV</b> للنتائج المفلترة.</li>
          <li>إجماليات: عدد الدورات وساعات التدريب حسب الموظف أو الفترة.</li>
          <li>ترقيم الصفحات (Pagination) إذا كثرت السجلات.</li>
          <li>فلتر سريع بالنص على اسم الدورة/الجهة.</li>
          <li>لوحة تفاصيل سريعة عند النقر على الصف (Modal) لعرض الملاحظات كاملة والمرفقات.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أسئلة شائعة</h2><a class="anchor" href="#faq">#faq</a></div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش الفلاتر ما تغيّر النتائج؟</summary>
          <p class="mt-2 opacity-90">احذف الاستعلام الثاني المذكور في “ملاحظات تقنية” لأنه يعيد تحميل كل البيانات ويتجاهل الفلاتر.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">الشهادة ما تنفتح؟</summary>
          <p class="mt-2 opacity-90">تأكد من صحة <span class="kbd">certificate_path</span> وصلاحيات الوصول للملف في السيرفر.</p>
        </details>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="employee_trainings.php">سجل الدورات التدريبية</a></li>
          <li><a class="underline" href="/erp_task_system/users/add.php">إضافة مستخدم (لربط الدورات بالموظف)</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">خلّنا نتواصل</h2><a class="anchor" href="#contact">#contact</a></div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m => {
        const txt = document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt, m);
      });
    }
    function highlight(root, term){
      if(!term) return;
      const rx = new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType === Node.TEXT_NODE){
            const span = document.createElement('span');
            span.innerHTML = ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML !== ch.textContent){ ch.parentNode.replaceChild(span, ch); }
          }
        });
      });
    }
    q && q.addEventListener('input', ()=>{
      const term = q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit = s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display = hit ? '' : 'none';
        if(hit) highlight(s, term);
      });
    });

    // واتساب مباشر
    (function(){
      const f = document.getElementById('contactForm');
      const r = document.getElementById('contactResult');
      const WA = '966535500241';
      if(!f) return;
      f.addEventListener('submit', (e)=>{
        e.preventDefault();
        const name  = document.getElementById('c_name').value.trim();
        const email = document.getElementById('c_email').value.trim();
        const phone = document.getElementById('c_phone').value.trim();
        const msg   = document.getElementById('c_msg').value.trim();
        if(!name || !msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url = `https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w = window.open(url, '_blank'); if(w) w.opener = null;
        r.textContent = 'بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
