<?php
// /erp_task_system/evaluations/help_evaluate_employee.php  ← عدّل المسار حسب مجلدك
session_start();
require_once '../config/db.php';
require_once '../authorize.php';

if (!isset($_SESSION['user'])) { header('Location: ../unauthorized.php'); exit; }

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "تقييم موظف"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#fields">حقول التقييم</a>
        <a href="#scoring">المعدل وآلية الاحتساب</a>
        <a href="#stats">بطاقات الإحصائيات</a>
        <a href="#apis">الواجهات (APIs) والـ AJAX</a>
        <a href="#prev">عرض التقييمات السابقة</a>
        <a href="#security">الأمان والممارسات الجيدة</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <!-- عدّل الرابط حسب اسم صفحتك -->
        <button onclick="window.location.href='evaluate_employee.php'"
                class="w-full px-3 py-2 rounded bg-blue-600 text-white">
          فتح صفحة التقييم
        </button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“تقييم موظف”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تتيح هذه الصفحة إدخال تقييم أداء لموظف محدّد (شهري/نصف سنوي)، مع عرض سريع لإحصائيات الفترة (مهام/غياب/تأخير) وجدول بجميع تقييماته السابقة. الحفظ يتم عبر الخادم، والقراءات تعرض فوريًا بالواجهات المساعدة.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول يمر عبر <span class="kbd">authorize.php</span> حسب سياسة نظامكم (عادة مدير/مدير نظام).</li>
          <li>قائمة الموظفين تُجلب من جدول <span class="kbd">users</span> مرتبةً بالاسم.</li>
        </ul>
      </section>

      <section id="fields" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">حقول التقييم</h2><a class="anchor" href="#fields">#fields</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>الموظف:</b> إلزامي.</li>
          <li><b>نوع التقييم:</b> <span class="kbd">monthly</span> (شهري) أو <span class="kbd">semi_annual</span> (نصف سنوي).</li>
          <li><b>تاريخ التقييم:</b> إلزامي (افتراضيًا تاريخ اليوم).</li>
          <li><b>المحاور (1–5):</b> الانضباط، جودة العمل، إنجاز المهام، التعاون، التطوير الذاتي، تقييم المدير.</li>
          <li><b>ملاحظات:</b> اختياري.</li>
        </ul>
      </section>

      <section id="scoring" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">المعدل وآلية الاحتساب</h2><a class="anchor" href="#scoring">#scoring</a></div>
        <p class="mt-2">
          يظهر حقل <span class="kbd">total_score</span> من قاعدة البيانات كما حُسِب عند الحفظ (ملف <span class="kbd">store_evaluation.php</span>). 
          الصيغة الشائعة:
        </p>
        <pre class="kbd" style="display:block;white-space:pre-wrap">المعدل = متوسط (الانضباط + جودة العمل + إنجاز المهام + التعاون + التطوير الذاتي + تقييم المدير)</pre>
        <p class="opacity-90 mt-2">يمكن اعتماد أوزان مختلفة لكل محور حسب سياسة شركتكم.</p>
      </section>

      <section id="stats" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">بطاقات الإحصائيات</h2><a class="anchor" href="#stats">#stats</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>تعرض الشبكة <span class="kbd">#empStats</span>: عدد المهام خلال الفترة، المنتهية، أيام الغياب، مرات التأخير.</li>
          <li>تُحدَّث تلقائيًا عند تغيير: الموظف/نوع التقييم/تاريخ التقييم.</li>
          <li>مصدر البيانات: <span class="kbd">get_employee_stats.php?employee_id=&amp;evaluation_period=&amp;evaluation_date=</span> ويعيد JSON بشكل <span class="kbd">{ok:true, stats:{...}}</span>.</li>
        </ul>
      </section>

      <section id="apis" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الواجهات (APIs) والـ AJAX</h2><a class="anchor" href="#apis">#apis</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><span class="kbd">store_evaluation.php</span> — حفظ التقييم (POST) ويُنصح بإضافة CSRF وتخزين <span class="kbd">created_by</span>.</li>
          <li><span class="kbd">get_employee_evaluations.php?id=EMP_ID</span> — يعيد قائمة تقييمات الموظف السابقة مع اسم المقيم.</li>
          <li><span class="kbd">get_employee_stats.php</span> — إحصائيات الفترة المعتمدة على تاريخ ونوع التقييم.</li>
          <li>ملاحظة في الجبهة: تم استبدال الدالة <span class="kbd">loadEvaluations</span> لتستدعي <span class="kbd">loadStats()</span> بعد تعبئة الموظف.</li>
        </ul>
      </section>

      <section id="prev" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">عرض التقييمات السابقة</h2><a class="anchor" href="#prev">#prev</a></div>
        <p class="mt-2">
          القسم <span class="kbd">#allEvaluations</span> يُظهر جدول جميع التقييمات السابقة عند توفر بيانات من <span class="kbd">get_employee_evaluations.php</span>. 
          تم إلغاء “ملخص آخر تقييم” عمدًا حسب الكود الحالي.
        </p>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والممارسات الجيدة</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>أضف رمز <span class="kbd">CSRF</span> في نموذج الحفظ داخل <span class="kbd">store_evaluation.php</span> وتحقق منه.</li>
          <li>تحقق من القيم: الموظف موجود، التواريخ صالحة، القيم 1–5، ونوع التقييم ضمن القيم المسموحة.</li>
          <li>قيود فريدة اختيارية: منع تكرار تقييم لنفس الموظف ونفس الفترة/التاريخ إذا رغبت.</li>
          <li>فهارس مقترحة: على <span class="kbd">(employee_id)</span> و <span class="kbd">(evaluation_date)</span> في جدول <span class="kbd">employee_evaluations</span>.</li>
        </ul>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحسينات مقترحة</h2><a class="anchor" href="#improve">#improve</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>حقل “حد أدنى للمعدل” وفلترة حسب الفترة/التاريخ.</li>
          <li>إظهار “مؤشر إنجاز” بصري حسب نسبة المهام.</li>
          <li>إرفاق مرفقات للتقييم (ملفات إثبات/خطط تطوير).</li>
          <li>تصدير CSV/Excel للتقييمات الخاصة بموظف معيّن.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أسئلة شائعة</h2><a class="anchor" href="#faq">#faq</a></div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش الإحصائيات ما تطلع؟</summary>
          <p class="mt-2 opacity-90">تأكد إن <span class="kbd">employee_id</span> و<span class="kbd">evaluation_period</span> و<span class="kbd">evaluation_date</span> مرسلة صحيحة، وأن <span class="kbd">get_employee_stats.php</span> يرجع <span class="kbd">ok:true</span>.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">التقييم ما ينحفظ؟</summary>
          <p class="mt-2 opacity-90">راجع متطلبات الحقول في <span class="kbd">store_evaluation.php</span> ورسالة الخطأ، وتأكد من جلسة المستخدم والصلاحيات.</p>
        </details>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="employee_evaluations.php">قائمة التقييمات</a></li>
          <li><a class="underline" href="view_tasks_by_evaluation.php">عرض المهام المرتبطة بالتقييم</a></li>
          <li><a class="underline" href="evaluate_employee.php">تقييم موظف</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">خلّنا نتواصل</h2><a class="anchor" href="#contact">#contact</a></div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const txt=document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
