<?php
// /erp_task_system/leaves/help_leave_requests.php
session_start();
require_once '../config/db.php';
require_once '../auth.php';

if (!isset($_SESSION['user']) || !in_array(($_SESSION['user']['role'] ?? 'employee'), ['admin','manager'], true)) {
  header("Location: ../unauthorized.php"); exit;
}

$user  = $_SESSION['user'];
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58','second_text_color'=>'#94a3b8'];

$bg   = htmlspecialchars($color['hex_code'] ?? '#f8fafc');
$ink  = htmlspecialchars($color['text_color'] ?? '#111827');
$navc = htmlspecialchars($color['nav_color'] ?? '#233a58');
$muted= htmlspecialchars($color['second_text_color'] ?? '#94a3b8');

$pageTitle = 'تعليمات صفحة "طلبات الإجازة"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.4rem .7rem; border-radius:.5rem; }
    .toc a:hover{ background: rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .45rem; border-radius:.375rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace,Menlo,Consolas,monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .legend span{ display:inline-block; padding:2px 8px; border-radius:9999px; font-size:.75rem; margin-left:.4rem }
    .b-blue{  background:#e0f2fe; color:#0369a1 }
    .b-green{ background:#dcfce7; color:#166534 }
    .b-red{   background:#fee2e2; color:#991b1b }
    .b-amber{ background:#fef3c7; color:#92400e }
    .b-slate{ background:#e2e8f0; color:#334155 }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    @media print{
      .no-print{ display:none !important; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#columns">أعمدة الجدول</a>
        <a href="#status-logic">منطق الحالة النهائية</a>
        <a href="#actions">الموافقات والإجراءات</a>
        <a href="#security">الأمان وCSRF</a>
        <a href="#tech-notes">ملاحظات تقنية من الكود</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#troubleshoot">أخطاء شائعة ومعالجتها</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="window.location.href='requests.php'" class="w-full px-3 py-2 rounded bg-blue-600 text-white">فتح طلبات الإجازة</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يعرض النتائج ويبرِز المطابقات.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header class="card rounded-2xl p-5">
        <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“طلبات الإجازة”</span></h1>
        <p class="opacity-90 mt-2">
          تُستخدم الصفحة لعرض جميع طلبات الإجازة ومتابعتها واتخاذ قرارات الموافقة/الرفض من قِبل المدير ثم الموارد البشرية. تُظهر الحالة النهائية تلقائيًا بحسب التواريخ ونتائج الموافقات.
        </p>
        <div class="legend mt-3">
          <span class="b-amber">بانتظار</span>
          <span class="b-blue">مقبولة (لم تبدأ)</span>
          <span class="b-green">في إجازة</span>
          <span class="b-slate">منتهية</span>
          <span class="b-red">مرفوضة</span>
        </div>
      </header>

      <!-- الصلاحيات -->
      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الصلاحيات</h2>
          <a class="anchor" href="#roles">#roles</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول إلى الصفحة: <b>مدير نظام (admin)</b> أو <b>مدير (manager)</b>.</li>
          <li>المدير يستطيع اتخاذ القرار لطلبات موظفي <b>إدارته فقط</b> عندما لا يكون هناك قرار مدير سابق.</li>
          <li>الموارد البشرية: يُعرّف النظام الإدارة بواحد من الأسماء: <span class="kbd">إدارة الموارد البشرية</span> / <span class="kbd">الموارد البشرية</span> / <span class="kbd">HR</span> / <span class="kbd">Human Resources</span>. مدير هذه الإدارة (أو المدير العام) يملك قرار الموارد.</li>
        </ul>
      </section>

      <!-- الأعمدة -->
      <section id="columns" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أعمدة الجدول</h2>
          <a class="anchor" href="#columns">#columns</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>الموظف/الإدارة</b> — يظهر اسم الموظف وإدارته الحالية.</li>
          <li><b>النوع</b> — نوع الإجازة (اعتيادية/مرضية/… حسب الإدخال).</li>
          <li><b>من/إلى</b> — تاريخ البداية والنهاية.</li>
          <li><b>السبب</b> — نص محفوظ كما كُتب من الموظف.</li>
          <li><b>الحالة النهائية</b> — تُحسب تلقائيًا (المنطق موضح أدناه).</li>
          <li><b>قرار المدير/الموارد</b> + <b>ملاحظاتهم</b> — الاعتماد والتعليقات لكل جهة.</li>
          <li><b>الإجراء</b> — يظهر نموذج قرار للجهة المخوّلة فقط.</li>
        </ul>
      </section>

      <!-- منطق الحالة النهائية -->
      <section id="status-logic" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">منطق الحالة النهائية</h2>
          <a class="anchor" href="#status-logic">#status-logic</a>
        </div>
        <ol class="list-decimal pr-6 mt-2 space-y-2">
          <li>إذا <b>لا يوجد قرار للمدير</b> → <span class="b-amber">بانتظار موافقة المدير</span>.</li>
          <li>إذا <b>رفض المدير أو رفضت الموارد</b> → <span class="b-red">مرفوضة</span>.</li>
          <li>إذا <b>وافق المدير ولا يوجد قرار للموارد</b> → <span class="b-amber">بانتظار موافقة الموارد</span>.</li>
          <li>إذا <b>وافق المدير والموارد</b>:
            <ul class="list-disc pr-6 mt-1 space-y-1">
              <li>والتاريخ اليوم <b>قبل البدء</b> → <span class="b-blue">مقبولة (لم تبدأ)</span>.</li>
              <li>واليوم <b>بعد النهاية</b> → <span class="b-slate">منتهية</span>.</li>
              <li>وإلا → <span class="b-green">في إجازة</span>.</li>
            </ul>
          </li>
          <li>أي حالات غير متوقعة تُظهر القيمة من حقل <span class="kbd">status</span> كـ "غير معروف".</li>
        </ol>
      </section>

      <!-- الإجراءات -->
      <section id="actions" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الموافقات والإجراءات</h2>
          <a class="anchor" href="#actions">#actions</a>
        </div>
        <p class="mt-2">كل إجراء يتم عبر نموذج صغير داخل صف الطلب، ويرسل إلى الملف <span class="kbd">update_leave_status.php</span> بطريقة <span class="kbd">POST</span>.</p>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>قرار المدير</b> (لنفس الإدارة فقط إن لم يُقرَّر مسبقًا): تعبئة ملاحظة اختيارية ثم <span class="kbd">موافقة</span> أو <span class="kbd">رفض</span>.</li>
          <li><b>قرار الموارد/المدير العام</b> (HR/Admin): تعبئة ملاحظة اختيارية ثم <span class="kbd">موافقة</span> أو <span class="kbd">رفض</span>.</li>
          <li>لا توجد خطوة "تراجع" في الواجهة الحالية؛ إن حدث خطأ، يفضّل تعديل القرار من خلال الأدمن مباشرة أو إضافة سجل جديد (حسب سياسة العمل لديكم).</li>
          <li>عمليًا النظام يسمح للموارد باتخاذ قرار حتى لو لم يعتمد المدير بعد؛ لكن الأفضل تنظيميًا انتظار قرار المدير أولًا.</li>
        </ul>
      </section>

      <!-- الأمان -->
      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الأمان وCSRF</h2>
          <a class="anchor" href="#security">#security</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>تستخدم الصفحة رمز CSRF في الجلسة: <span class="kbd">$_SESSION['csrf_leave']</span> ويُرسل مع كل نموذج.</li>
          <li>تأكيد الصلاحيات يتم في الواجهة (عرض الأزرار) ثم يجب أيضًا التحقق منها داخل <span class="kbd">update_leave_status.php</span> قبل تعديل السجل.</li>
        </ul>
      </section>

      <!-- ملاحظات تقنية -->
      <section id="tech-notes" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">ملاحظات تقنية من الكود</h2>
          <a class="anchor" href="#tech-notes">#tech-notes</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1 text-sm">
          <li>جلب البيانات:
            <span class="kbd">JOIN users</span> لاسم الموظف،
            <span class="kbd">LEFT JOIN departments</span> لاسم الإدارة.</li>
          <li>الحالة النهائية تُحسب محليًا في الواجهة اعتمادًا على <span class="kbd">manager_status</span> و<span class="kbd">hr_status</span> وتواريخ <span class="kbd">start_date / end_date</span>.</li>
          <li>تحديد “هل المستخدم HR؟” يتم باسم الإدارة (واحدة من: HR / Human Resources / الموارد البشرية…).</li>
          <li>نماذج القرارات ترسل: <span class="kbd">csrf</span>، <span class="kbd">id</span>، <span class="kbd">actor</span> (manager/hr/admin)، <span class="kbd">action</span> (accept/reject)، <span class="kbd">note</span>.</li>
        </ul>
      </section>

      <!-- FAQ -->
      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أسئلة شائعة</h2>
          <a class="anchor" href="#faq">#faq</a>
        </div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش بعض الطلبات “بانتظار موافقة الموارد”؟</summary>
          <p class="mt-2 opacity-90">لأن المدير وافق ومتبقّي قرار الموارد البشرية.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش الطلب “مرفوض” والحالتين مو واضحة؟</summary>
          <p class="mt-2 opacity-90">الرفض يُمكن أن يكون من المدير أو الموارد. راجع عمود “قرار المدير/الموارد”.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أخطأت بالقرار.. كيف أصلّح؟</summary>
          <p class="mt-2 opacity-90">حاليًا لا يوجد “تراجع” من الواجهة. تواصل مع الأدمن لإعادة الضبط حسب سياستكم أو سجّل قرار تصحيحي موثّق.</p>
        </details>
      </section>

      <!-- أخطاء شائعة -->
      <section id="troubleshoot" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أخطاء شائعة ومعالجتها</h2>
          <a class="anchor" href="#troubleshoot">#troubleshoot</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>CSRF غير صالح:</b> حدّث الصفحة أو أعد تسجيل الدخول.</li>
          <li><b>ليس لديك صلاحية:</b> تأكّد من كونك مديرًا لنفس الإدارة (قرار المدير) أو ضمن HR/أدمن (قرار الموارد).</li>
          <li><b>الطلب لا يظهر:</b> تأكّد أن العلاقات بين الجداول صحيحة وأن الموظف مرتبط بإدارة.</li>
        </ul>
      </section>

      <!-- روابط -->
      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">روابط ذات صلة</h2>
          <a class="anchor" href="#related">#related</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="requests.php">طلبات الإجازة</a></li>
          <li><a class="underline" href="update_leave_status.php">معالجة قرار الإجازة (POST)</a></li>
        </ul>
      </section>

      <!-- تواصل -->
      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">خلّنا نتواصل</h2>
          <a class="anchor" href="#contact">#contact</a>
        </div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">تواصل واتساب مباشر</a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m => {
        const txt = document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt, m);
      });
    }
    function highlight(root, term){
      if(!term) return;
      const rx = new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g, '\\\\$&')+')', 'gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType === Node.TEXT_NODE){
            const span = document.createElement('span');
            span.innerHTML = ch.textContent.replace(rx, '<mark class="mark">$1</mark>');
            if(span.innerHTML !== ch.textContent){ ch.parentNode.replaceChild(span, ch); }
          }
        });
      });
    }
    q && q.addEventListener('input', ()=>{
      const term = q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit = s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display = hit ? '' : 'none';
        if(hit) highlight(s, term);
      });
    });

    // واتساب مباشر
    (function(){
      const f = document.getElementById('contactForm');
      const r = document.getElementById('contactResult');
      const WA = '966535500241';
      if(!f) return;
      f.addEventListener('submit', (e)=>{
        e.preventDefault();
        const name  = document.getElementById('c_name').value.trim();
        const email = document.getElementById('c_email').value.trim();
        const phone = document.getElementById('c_phone').value.trim();
        const msg   = document.getElementById('c_msg').value.trim();
        if(!name || !msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url = `https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w = window.open(url, '_blank'); if(w) w.opener=null;
        r.textContent = 'بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
