<?php
session_start();
require_once '../config/db.php';

// تحقّق صلاحيات: مدير نظام أو مدير
if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'] ?? '', ['admin','manager'])) {
  header('Location: ../unauthorized.php'); exit;
}

// ثيم المستخدم
$user  = $_SESSION['user'];
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58','second_text_color'=>'#94a3b8'];
$userThemeColor            = $color['hex_code'];
$userThemeTextColor        = $color['text_color'];
$userThemeSecondTextColor  = $color['second_text_color'] ?? '#94a3b8';
$userThemeNavColor         = $color['nav_color'] ?? '#233a58';

$pageTitle = 'تعليمات صفحة "إدارة أوقات الدوام"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $userThemeColor ?>;
      --ink: <?= $userThemeTextColor ?>;
      --muted: <?= $userThemeSecondTextColor ?>;
      --card: <?= $userThemeNavColor ?>;
      --ring: #2563eb;
      --primary:#22c55e; /* للزر الأخضر تبع واتساب */
    }
    body{ background: var(--bg); color: var(--ink); }
    .card{ background: var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.4rem .7rem; border-radius:.5rem; }
    .toc a:hover{ background: rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .45rem; border-radius:.375rem; background:rgba(255,255,255,.08); }
    .callout{ border-inline-start:4px solid var(--ring); background: rgba(37,99,235,.08); }
    .kbd{ font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }

    /* تمييز نتائج البحث */
    .mark{ background: #fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }

    /* طباعة */
    @media print{
      .no-print{ display:none !important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ border:1px solid #e5e7eb; background:#fff; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- الفهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#fields">حقول الفترة</a>
        <a href="#add-edit">إضافة/تعديل فترة</a>
        <a href="#delete">حذف فترة</a>
        <a href="#listing">عرض الجدول</a>
        <a href="#validation">التحقّق والتنبيهات</a>
        <a href="#tech">ملاحظات تقنية من الكود</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#troubleshoot">أخطاء شائعة ومعالجتها</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="window.location.href='work_shifts.php'" class="w-full px-3 py-2 rounded bg-blue-600 text-white">فتح صفحة أوقات الدوام</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يعرض النتائج ويبرِز المطابقات.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header class="card rounded-2xl p-5">
        <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“إدارة أوقات الدوام”</span></h1>
        <p class="opacity-90 mt-2">
          تُستخدم هذه الصفحة لإضافة وتعديل وحذف فترات الدوام (صباحي/مسائي/مخصص) مع ملاحظات اختيارية. جميع العمليات تتم من خلال نفس الصفحة.
        </p>
        <div class="callout rounded-xl p-3 mt-3">
          ✅ مناسب لمديري النظام والمديرين لتنظيم الورديات وربطها لاحقًا بملفات الموظفين والحضور.  
          ✅ يحفظ النظام الفترة مباشرة ويعيد توجيهك إلى <span class="kbd">work_shifts.php</span>.
        </div>
      </header>

      <!-- الصلاحيات -->
      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">الصلاحيات</h2>
          <a class="anchor" href="#roles">#roles</a>
        </div>
        <p class="mt-2">الوصول محصور على: <b>مدير نظام</b> أو <b>مدير</b>.</p>
      </section>

      <!-- الحقول -->
      <section id="fields" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">حقول الفترة</h2>
          <a class="anchor" href="#fields">#fields</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>اسم الفترة</b> — نص إلزامي (مثال: “صباحي رئيسي”).</li>
          <li><b>بداية الدوام</b> — وقت إلزامي بصيغة <span class="kbd">HH:MM</span>.</li>
          <li><b>نهاية الدوام</b> — وقت إلزامي بصيغة <span class="kbd">HH:MM</span>.</li>
          <li><b>نوع الفترة</b> — قائمة: صباحي / مسائي / مخصص.</li>
          <li><b>ملاحظات</b> — نص اختياري لأي تفاصيل إضافية.</li>
        </ul>
      </section>

      <!-- إضافة/تعديل -->
      <section id="add-edit" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">إضافة/تعديل فترة</h2>
          <a class="anchor" href="#add-edit">#add-edit</a>
        </div>
        <ol class="list-decimal pr-6 mt-2 space-y-2">
          <li>عبّئ الحقول المطلوبة ثم اضغط <b>حفظ</b> لإضافة فترة جديدة.</li>
          <li>للتعديل: اضغط زر <b>تعديل</b> في الصف المطلوب — تُحمّل البيانات في النموذج، عدّلها ثم اضغط <b>حفظ</b>.</li>
          <li>زر <b>جديد</b> يفرّغ النموذج للبدء من الصفر.</li>
        </ol>
        <p class="mt-3 opacity-90">
          بعد الحفظ، يتم إعادة التوجيه تلقائيًا إلى <span class="kbd">work_shifts.php</span> لعرض القائمة المحدّثة.
        </p>
      </section>

      <!-- حذف -->
      <section id="delete" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">حذف فترة</h2>
          <a class="anchor" href="#delete">#delete</a>
        </div>
        <p class="mt-2">
          من الجدول، اضغط <b>حذف</b> ثم أكّد الرسالة المنبثقة. سيُحذف السجل ويُعاد توجيهك للصفحة.
        </p>
        <div class="callout rounded-xl p-3 mt-3">
          ⚠️ تنبيه: الحذف يتم عبر رابط GET مع تأكيد متصفح. للأمان الأعلى، يُستحسن لاحقًا التحويل إلى POST مع رمز CSRF.
        </div>
      </section>

      <!-- عرض الجدول -->
      <section id="listing" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">عرض الجدول</h2>
          <a class="anchor" href="#listing">#listing</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>يُعرض كل السجلات من الجدول <span class="kbd">work_shifts</span> مُرتّبة تنازليًا حسب <span class="kbd">id</span>.</li>
          <li>زر <b>تعديل</b> يحمّل بيانات الصف في النموذج أعلى الصفحة.</li>
          <li>زر <b>حذف</b> يحذف السجل بعد التأكيد.</li>
        </ul>
      </section>

      <!-- التحقق -->
      <section id="validation" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">التحقّق والتنبيهات</h2>
          <a class="anchor" href="#validation">#validation</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>الحقول <b>الاسم</b>، <b>البداية</b>، <b>النهاية</b>، <b>النوع</b> مطلوبة.</li>
          <li>من الأفضل أن تكون البداية قبل النهاية ضمن نفس اليوم. الفترات العابرة لمنتصف الليل (مثل 23:00 → 07:00) غير مُتحقَّق منها تلقائيًا في هذا الإصدار.</li>
          <li>لا يوجد فحص تضارب تلقائي بين الفترات (Overlap). يمكنك إضافته لاحقًا إن رغبت.</li>
        </ul>
      </section>

      <!-- ملاحظات تقنية -->
      <section id="tech" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">ملاحظات تقنية من الكود</h2>
          <a class="anchor" href="#tech">#tech</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1 text-sm">
          <li>الإضافة/التعديل يتمان عبر <span class="kbd">POST</span> على نفس الصفحة، ثم <span class="kbd">header("Location: work_shifts.php")</span>.</li>
          <li>الحذف يتم عبر <span class="kbd">GET ?delete=ID</span> مع تأكيد <span class="kbd">confirm()</span>.</li>
          <li>العرض: <span class="kbd">$shifts = $conn->query("SELECT * FROM work_shifts ORDER BY id DESC")</span>.</li>
          <li>التحكم بالثيم من جلسة المستخدم: الألوان تُسحب من <span class="kbd">$_SESSION['user']['color']</span>.</li>
        </ul>
      </section>

      <!-- FAQ -->
      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أسئلة شائعة</h2>
          <a class="anchor" href="#faq">#faq</a>
        </div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أضفت فترة وما ظهرت بالجدول؟</summary>
          <p class="mt-2 opacity-90">تتحمّل الصفحة وتوجّهك لنفس الملف. إذا ما ظهرت، حدّث المتصفح أو تأكد من نجاح التنفيذ في الخادم.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أبغى فترة “ليلية” تتجاوز منتصف الليل.</summary>
          <p class="mt-2 opacity-90">هذا الإصدار يتعامل مع اليوم نفسه. بإمكانك لاحقًا دعم فترات عابرة لليوم بإضافة منطق خاص بالحضور.</p>
        </details>
      </section>

      <!-- أخطاء شائعة -->
      <section id="troubleshoot" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">أخطاء شائعة ومعالجتها</h2>
          <a class="anchor" href="#troubleshoot">#troubleshoot</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>فشل التنفيذ:</b> راجع صلاحيات المستخدم والاتصال بقاعدة البيانات.</li>
          <li><b>لا يمكن الحذف:</b> قد تكون هناك قيود مرجعية مستقبلًا إذا رُبطت الفترات بموظفين. راجع علاقات الجداول.</li>
        </ul>
      </section>

      <!-- روابط -->
      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">روابط ذات صلة</h2>
          <a class="anchor" href="#related">#related</a>
        </div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="work_shifts.php">صفحة إدارة أوقات الدوام</a></li>
          <li><a class="underline" href="/erp_task_system/users/add.php">إضافة مستخدم (يرتبط بالورديات)</a></li>
        </ul>
      </section>

      <!-- تواصل -->
      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">خلّنا نتواصل</h2>
          <a class="anchor" href="#contact">#contact</a>
        </div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">تواصل واتساب مباشر</a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m => {
        const txt = document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt, m);
      });
    }
    function highlight(root, term){
      if(!term) return;
      const rx = new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g, '\\\\$&')+')', 'gi');
      root.querySelectorAll('p, li').forEach(node=>{
        if(!node.childNodes || !node.childNodes.length) return;
        node.childNodes.forEach(ch=>{
          if(ch.nodeType === Node.TEXT_NODE){
            const span = document.createElement('span');
            span.innerHTML = ch.textContent.replace(rx, '<mark class="mark">$1</mark>');
            if(span.innerHTML !== ch.textContent){
              ch.parentNode.replaceChild(span, ch);
            }
          }
        });
      });
    }
    q && q.addEventListener('input', ()=>{
      const term = q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit = s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display = hit ? '' : 'none';
        if(hit) highlight(s, term);
      });
    });

    /* إرسال واتساب مباشرة من نموذج التواصل */
    (function(){
      const f = document.getElementById('contactForm');
      const r = document.getElementById('contactResult');
      const WA = '966535500241';
      if(!f) return;

      f.addEventListener('submit', (e)=>{
        e.preventDefault();
        const name  = document.getElementById('c_name').value.trim();
        const email = document.getElementById('c_email').value.trim();
        const phone = document.getElementById('c_phone').value.trim();
        const msg   = document.getElementById('c_msg').value.trim();
        if(!name || !msg){ r.textContent='الاسم والطلب مطلوبين'; return; }

        const txt = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;

        const url = `https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w = window.open(url, '_blank');
        if (w) w.opener = null;
        r.textContent = 'بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
