<?php
require_once '../../../config/db.php';
require_once '../../../auth.php';

// تأكد من أن البيانات مرسلة عن طريق POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $employee_id = intval($_POST['employee_id'] ?? 0);
    $component_id = intval($_POST['component_id'] ?? 0);
    $value = floatval($_POST['value'] ?? 0);
    $notes = trim($_POST['notes'] ?? '');

    if ($employee_id && $component_id && $value > 0) {
        // هل موجود نفس البند مسبقاً لهذا الموظف؟
        $stmt = $conn->prepare("SELECT id FROM employee_salary_items WHERE employee_id = ? AND component_id = ?");
        $stmt->execute([$employee_id, $component_id]);
        if ($stmt->fetch()) {
            echo json_encode(['success' => false, 'message' => 'البند مضاف مسبقاً لهذا الموظف.']);
            exit;
        }

        $stmt = $conn->prepare("INSERT INTO employee_salary_items (employee_id, component_id, value, notes) VALUES (?, ?, ?, ?)");
        $stmt->execute([$employee_id, $component_id, $value, $notes]);
        echo json_encode(['success' => true, 'message' => 'تمت إضافة البند بنجاح.']);
        exit;
    } else {
        echo json_encode(['success' => false, 'message' => 'يجب تعبئة جميع الحقول المطلوبة.']);
        exit;
    }
}
echo json_encode(['success' => false, 'message' => 'طلب غير صالح.']);
