<?php
require_once '../../../config/db.php';

$employee_id = intval($_GET['employee_id'] ?? 0);

if ($employee_id) {
    // جلب البنود المالية للموظف مع تفاصيل البند
    $stmt = $conn->prepare("
        SELECT esi.*, sc.name AS component_name, sc.type
        FROM employee_salary_items esi
        JOIN salary_components sc ON sc.id = esi.component_id
        WHERE esi.employee_id = ?
        ORDER BY sc.type, sc.id
    ");
    $stmt->execute([$employee_id]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    ?>
    <table class="w-full border mt-6 text-center">
        <thead>
            <tr class="bg-gray-100">
                <th>#</th>
                <th>اسم البند</th>
                <th>النوع</th>
                <th>القيمة</th>
                <th>ملاحظات</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($items as $row): ?>
            <tr class="border-b">
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['component_name']) ?></td>
                <td>
                    <?php
                      if($row['type']=='allowance') echo '<span class="text-green-700 font-bold">بدل</span>';
                      elseif($row['type']=='deduction') echo '<span class="text-red-700 font-bold">خصم</span>';
                      elseif($row['type']=='basic') echo '<span class="text-blue-700 font-bold">أساسي</span>';
                      else echo htmlspecialchars($row['type']);
                    ?>
                </td>
                <td><?= number_format($row['value'], 2) ?></td>
                <td><?= htmlspecialchars($row['notes']) ?></td>
                <td>
                  <button onclick="deleteSalaryItem(<?= $row['id'] ?>, <?= $employee_id ?>)" class="bg-red-600 text-white px-2 py-1 rounded hover:bg-red-800">حذف</button>
                </td>
            </tr>
            <?php endforeach ?>
            <?php if (count($items) == 0): ?>
                <tr><td colspan="6" class="text-gray-500 py-3">لا يوجد بنود مالية مرتبطة بهذا الموظف.</td></tr>
            <?php endif ?>
        </tbody>
    </table>
    <?php
    exit;
}
echo '<div class="text-red-500 font-bold">لم يتم تحديد الموظف.</div>';
