<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

// تحقق الدخول
if (!isset($_SESSION['user'])) { header('Location: ../../login.php'); exit; }

// مُدخلات
$payroll_id = (int)($_GET['id'] ?? 0);
if ($payroll_id <= 0) die('رقم المسير غير صحيح.');
$mode = (isset($_GET['full']) && $_GET['full'] == '1') ? 'full' : 'bank';

// جلب عناصر المسير + بيانات البنك (مع السناب شوت)
$sql = "SELECT
          pi.id AS payroll_item_id,
          u.employee_number, u.name, u.national_id, u.bank_account, u.iban,
          pi.snapshot_employee_number, pi.snapshot_name, pi.snapshot_national_id,
          pi.snapshot_bank_account, pi.snapshot_iban, pi.snapshot_currency
        FROM payroll_items pi
        JOIN users u ON u.id = pi.user_id
        WHERE pi.payroll_id = ?";
$stmt = $conn->prepare($sql);
$stmt->execute([$payroll_id]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
if (!$rows) die('لا يوجد بيانات لهذا المسير.');

// دالة مريحة لتفضيل سناب شوت على بيانات المستخدم
function prefer_snapshot(array $r, string $field){
  $snap = $r['snapshot_'.$field] ?? null;
  $plain= $r[$field] ?? null;
  return ($snap !== null && $snap !== '') ? $snap : $plain;
}

// تحضير استعلام تفاصيل البنود (للوضع الكامل) أو التجميع
$detailStmt = $conn->prepare(
  "SELECT sc.name, sc.type, pc.amount
   FROM payroll_item_components pc
   JOIN salary_components sc ON sc.id = pc.component_id
   WHERE pc.payroll_item_id = ?"
);

// تجهيز الهيدر مرة وحدة فقط
header('Content-Type: text/tab-separated-values; charset=utf-8');
$fname = ($mode === 'full') ? "payroll_full_{$payroll_id}.xls" : "payroll_bank_{$payroll_id}.xls";
header("Content-Disposition: attachment; filename={$fname}");
echo "\xEF\xBB\xBF"; // BOM لدعم UTF-8 في Excel

if ($mode === 'bank') {
  // (بدون ترويسة أعمدة حتى يتوافق مع بعض بنوك/WPS، عدلها لو تبغى)
  foreach ($rows as $r) {
    $empNo = prefer_snapshot($r,'employee_number');
    $name  = prefer_snapshot($r,'name');
    $nid   = prefer_snapshot($r,'national_id');
    $acc   = prefer_snapshot($r,'bank_account');
    $iban  = prefer_snapshot($r,'iban');

    // احسب إجماليات من تفاصيل البنود
    $base=0.0; $allow=0.0; $ded=0.0; $ot=0.0;
    $detailStmt->execute([$r['payroll_item_id']]);
    while ($c = $detailStmt->fetch(PDO::FETCH_ASSOC)) {
      $type = strtolower(trim($c['type'] ?? ''));
      $amt  = (float)$c['amount'];
      if ($type === 'basic') $base += $amt;
      elseif ($type === 'allowance' || $type === 'earning') $allow += $amt;
      elseif ($type === 'deduction') $ded += $amt;
      elseif ($type === 'overtime')  $ot  += $amt;
    }
    $net = $base + $allow + $ot - $ded;

    echo implode("\t", [
      $empNo ?? '',
      $name  ?? '',
      $nid   ?? '',
      $acc   ?? '',
      $iban  ?? '',
      number_format($net, 2)
    ]) . "\n";
  }
  exit;
}

// ===== وضع كامل =====
echo "الرقم الوظيفي\tاسم الموظف\tرقم الهوية\tرقم الحساب\tالآيبان\tالأساسي\tالبدلات\tالخصومات\tالإضافي\tالصافي\tتفاصيل البنود\n";

foreach ($rows as $r) {
  $empNo = prefer_snapshot($r,'employee_number');
  $name  = prefer_snapshot($r,'name');
  $nid   = prefer_snapshot($r,'national_id');
  $acc   = prefer_snapshot($r,'bank_account');
  $iban  = prefer_snapshot($r,'iban');

  $base=0.0; $allow=0.0; $ded=0.0; $ot=0.0; $details=[];
  $detailStmt->execute([$r['payroll_item_id']]);
  while ($c = $detailStmt->fetch(PDO::FETCH_ASSOC)) {
    $type   = strtolower(trim($c['type'] ?? ''));
    $amount = (float)$c['amount'];
    if ($type === 'basic') $base += $amount;
    elseif ($type === 'allowance' || $type === 'earning') $allow += $amount;
    elseif ($type === 'deduction') $ded += $amount;
    elseif ($type === 'overtime')  $ot  += $amount;

    $details[] = ($c['name'] ?? '—') . " (" . ($c['type'] ?? '-') . "): " . number_format($amount, 2);
  }
  $net = $base + $allow + $ot - $ded;

  echo implode("\t", [
    $empNo ?? '',
    $name  ?? '',
    $nid   ?? '',
    $acc   ?? '',
    $iban  ?? '',
    number_format($base, 2),
    number_format($allow, 2),
    number_format($ded, 2),
    number_format($ot, 2),
    number_format($net, 2),
    implode(", ", $details)
  ]) . "\n";
}
exit;
