<?php
// /erp_task_system/payrolls/help_employee_salary_items.php  ← عدّل المسار إذا لزم
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
require_once '../../authorize.php';

if (!isset($_SESSION['user'])) { header('Location: /erp_task_system/unauthorized.php'); exit; }
// نفس منطق الصفحة الأصلية: إداري فقط
allow_roles(['admin']);

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "بنود الرواتب للموظفين"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#flow">كيف تؤثّر البنود على المسير</a>
        <a href="#ui">واجهة الصفحة والحقول</a>
        <a href="#actions">الإجراءات (إضافة/حذف)</a>
        <a href="#apis">واجهات الـ API</a>
        <a href="#security">الأمان والتحقق</a>
        <a href="#best">ممارسات موصى بها</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="history.back()" class="w-full px-3 py-2 rounded bg-blue-600 text-white">الرجوع للصفحة</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“بنود الرواتب للموظفين”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تُتيح هذه الصفحة إدارة البنود المالية الخاصة بكل موظف (أساسي/بدلات/خصومات…) بإضافة قيَم جديدة أو حذف قيَم سابقة. 
          تُستخدم هذه البيانات لاحقًا عند إنشاء مسير الرواتب لحساب الأجور بدقّة حتى نهاية الشهر المختار.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول للصفحة والإجراءات محصور بدور <b>المدير (admin)</b> وفق <span class="kbd">allow_roles(['admin'])</span>.</li>
          <li>قائمة الموظفين تُجلب مُرتّبة بالاسم من جدول <span class="kbd">users</span>.</li>
          <li>قائمة البنود تُعرض فقط البنود <b>المفعّلة</b> (<span class="kbd">salary_components.is_active=1</span>).</li>
        </ul>
      </section>

      <section id="flow" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">كيف تؤثّر البنود على المسير</h2><a class="anchor" href="#flow">#flow</a></div>
        <p class="mt-2">
          عند إنشاء مسير الرواتب، يعتمد النظام على <b>آخر قيمة</b> لكل بند حتى <b>آخر يوم</b> في الشهر المختار:
        </p>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><span class="kbd">get_employee_basic_salary()</span> يجلب آخر قيمة للبند ذي النوع <span class="kbd">basic</span>.</li>
          <li><span class="kbd">get_employee_component_sum('allowance')</span> يجمع آخر قيمة لكل بند بدلات.</li>
          <li><span class="kbd">get_employee_component_sum('deduction')</span> يجمع آخر قيمة لكل بند خصومات.</li>
          <li>الفرز مبني على <span class="kbd">created_at</span> و/أو <span class="kbd">id</span> تنازليًا لاختيار الأحدث حتى نهاية الشهر.</li>
        </ul>
        <p class="opacity-90 mt-2">إن أردت احتساب الأثر التاريخي (Effective Date)، فكّر بإضافة حقل <span class="kbd">effective_date</span> بدل الاعتماد على تاريخ الإدراج فقط.</p>
      </section>

      <section id="ui" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">واجهة الصفحة والحقول</h2><a class="anchor" href="#ui">#ui</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>اختيار الموظف:</b> باستخدام Select2 (بحث/اختيار).</li>
          <li><b>عرض البنود المرتبطة:</b> يُحمّل تلقائيًا عبر AJAX عند اختيار الموظف.</li>
          <li><b>إضافة بند جديد:</b> اختر البند (من البنود المفعّلة)، أدخِل <b>القيمة</b> (>= 0) وملاحظة اختيارية، ثم “إضافة”.</li>
        </ul>
        <div class="text-sm opacity-90 mt-1">
          تنبيه واجهة: في صفحتك الأصلية عندك قاعدة CSS عامة <span class="kbd">a:hover { background-color: ... }</span> 
          ممكن تغيّر خلفية الروابط بشكل غير مرغوب. الأفضل تخصيصها لأزرار معيّنة بدل كل الروابط.
        </div>
      </section>

      <section id="actions" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الإجراءات (إضافة/حذف)</h2><a class="anchor" href="#actions">#actions</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>إضافة:</b> من نموذج “إضافة بند مالي جديد” → يحفَظ سطر جديد في <span class="kbd">employee_salary_items</span> للبند المختار.</li>
          <li><b>حذف:</b> زر الحذف في الجدول (ضمن المحتوى الذي تُعيده <span class="kbd">get_employee_salary_items.php</span>) يستدعي <span class="kbd">delete_employee_salary_item.php</span> ثم يُعيد التحميل.</li>
          <li><b>تعديل قيمة:</b> غير متاح في الشيفرة الحالية كتحرير مباشر؛ بدلًا منه أضف قيَمًا جديدة (الأحدث تسري)، أو أضف API للتعديل إن رغبت.</li>
        </ul>
      </section>

      <section id="apis" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">واجهات الـ API</h2><a class="anchor" href="#apis">#apis</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1 text-sm">
          <li><span class="kbd">api/get_employee_salary_items.php?employee_id=ID</span> — (GET) يُعيد HTML للجدول.</li>
          <li><span class="kbd">api/add_employee_salary_item.php</span> — (POST) حقول: <span class="kbd">employee_id</span>, <span class="kbd">component_id</span>, <span class="kbd">value</span>, <span class="kbd">notes</span> — يُعيد JSON: <span class="kbd">{success, message}</span>.</li>
          <li><span class="kbd">api/delete_employee_salary_item.php</span> — (POST) حقول: <span class="kbd">id</span> — يُعيد JSON: <span class="kbd">{success, message}</span>.</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والتحقق</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>تحقق خادميًّا من الصلاحيات قبل كل API (تأكّد من <span class="kbd">admin</span>).</li>
          <li>تحقق من وجود الموظف والبند (<span class="kbd">is_active=1</span>) وأن <span class="kbd">value ≥ 0</span>.</li>
          <li>اعتماد <b>CSRF</b> لطلبات POST، وإرجاع رسائل أخطاء واضحة.</li>
          <li>سجل تدقيق (Logs): من أضاف/حذف ومتى (مفيد للمراجعة المالية).</li>
        </ul>
      </section>

      <section id="best" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">ممارسات موصى بها</h2><a class="anchor" href="#best">#best</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>دعم <b>تاريخ النفاذ (effective_date)</b> لكل قيمة بدلًا من الاعتماد على <span class="kbd">created_at</span> فقط.</li>
          <li>منع التكرار: خيار “لا تسمح بأكثر من قيمة فعّالة لنفس البند في نفس التاريخ”.</li>
          <li>عرض نوع البند (basic/allowance/deduction) بجانب الاسم لتوضيح الأثر على المسير.</li>
          <li>تصدير CSV/Excel لبنود موظف معيّن عند المراجعة.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أسئلة شائعة</h2><a class="anchor" href="#faq">#faq</a></div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أضفت بندًا وما ظهر في المسير؟</summary>
          <p class="mt-2 opacity-90">المسير يأخذ <b>آخر قيمة حتى نهاية الشهر</b>. تأكد من تاريخ الإدراج/الفعالية، وأن البند مفعّل، وأنك أنشأت المسير للفترة الصحيحة.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش ما أشوف بعض البنود في القائمة؟</summary>
          <p class="mt-2 opacity-90">الصفحة تعرض البنود ذات <span class="kbd">is_active=1</span> فقط من <span class="kbd">salary_components</span>.</p>
        </details>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="employee_salary_items.php">بنود الرواتب للموظفين (الصفحة الحالية)</a></li>
          <li><a class="underline" href="salary_components.php">إدارة البنود المالية</a></li>
          <li><a class="underline" href="index.php">مسيرات الرواتب</a></li>
          <li><a class="underline" href="create.php">إنشاء مسير رواتب جديد</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">خلّنا نتواصل</h2><a class="anchor" href="#contact">#contact</a></div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const txt=document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
