<?php
// /erp_task_system/payrolls/help_payroll_create.php  ← عدّل المسار إذا لزم
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';

if (!isset($_SESSION['user'])) { header('Location: /erp_task_system/unauthorized.php'); exit; }

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "إنشاء مسير رواتب جديد"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    .chip{ display:inline-block; padding:2px 8px; border-radius:9999px; font-size:.75rem; margin-left:.35rem }
    .b-amber{ background:#fef3c7; color:#92400e }
    .b-emerald{ background:#d1fae5; color:#065f46 }
    .b-indigo{ background:#e0e7ff; color:#3730a3 }
    .b-rose{ background:#ffe4e6; color:#9f1239 }
    .b-amber2{ background:#fffbeb; color:#92400e }
    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>

      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#inputs">المدخلات وأزرار الحساب</a>
        <a href="#table">جدول الموظفين</a>
        <a href="#formula">كيفية الاحتساب (الصافي)</a>
        <a href="#functions">الدوال المساعدة (من الصفحة)</a>
        <a href="#ajax">تحديث الجدول AJAX</a>
        <a href="#security">الأمان والممارسات الجيدة</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="history.back()" class="w-full px-3 py-2 rounded bg-blue-600 text-white">الرجوع للصفحة</button>
        <button onclick="window.print()"  class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">

      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“إنشاء مسير رواتب جديد”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تُتيح هذه الصفحة إنشاء مسير رواتب لشهر/سنة محدّدين، مع حسابات تلقائية للبدلات والخصومات وخصم التأخير والغياب والتأمينات والأثر المرضي، وإمكانية تشغيل/إيقاف كل عنصر على حدة قبل الحفظ.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول يمر عبر <span class="kbd">auth.php</span> بجلسة مستخدم صالحة.</li>
          <li>يُفضّل قصر الإنشاء على دور <b>المالية/المدير العام</b> فقط.</li>
        </ul>
      </section>

      <section id="inputs" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">المدخلات وأزرار الحساب</h2><a class="anchor" href="#inputs">#inputs</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>الشهر/السنة:</b> يحدّدان الفترة التي تُحتسب عليها الرواتب.</li>
          <li><b>أزرار التشغيل/الإيقاف:</b></li>
        </ul>
        <p class="mt-2">
          <span class="chip b-amber">حساب التأخير / بدون خصم التأخير</span>
          <span class="chip b-indigo">حساب الإضافي / بدون إضافي</span>
          <span class="chip b-rose">حساب الغياب / بدون خصم الغياب</span>
          <span class="chip b-amber2">حساب التأمينات / بدون التأمينات</span>
        </p>
        <p class="mt-2 opacity-90">يؤثّر كل زر على إظهار/إخفاء العمود المقابل في الجدول وكذلك على نتيجة الحساب.</p>
      </section>

      <section id="table" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">جدول الموظفين</h2><a class="anchor" href="#table">#table</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>الراتب الأساسي/البدلات/الخصومات:</b> تُملأ تلقائيًا بآخر القيم حتى نهاية الشهر، ويمكن تعديلها يدويًا.</li>
          <li><b>أيام غياب:</b> تُحتسب تلقائيًا (0، 0.5، 1.0 ...) ويمكن تعديلها يدويًا؛ المبلغ يُعرض في “خصم الغياب”.</li>
          <li><b>التأمينات وخصم مرضي:</b> تُعرض قيمتها، وتُرسل أيضًا كخانات مخفية للحفظ.</li>
          <li><b>إجمالي/صافي:</b> مخرجات القراءة فقط حسب المعادلة الموضّحة أدناه.</li>
        </ul>
        <div class="mt-2 text-sm opacity-90">
          ملحوظة: عند الحفظ، الجدول يُخزّن <span class="kbd">base_salary</span> و<span class="kbd">total_allowances</span> و
          <span class="kbd">total_deductions</span> (وتشمل <b>خصومات البنود + التأمينات + المرضي</b>) و
          <span class="kbd">absent_days</span>. <u>خصم التأخير</u> و<u>خصم الغياب (المبلغ)</u> يُعرضان هنا لكن لا يُخزّنان كمبالغ في
          <span class="kbd">payroll_items</span> وفق الشيفرة الحالية — إن رغبت بتخزينهما أضِف أعمدة للحفظ.
        </div>
      </section>

      <section id="formula" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">كيفية الاحتساب (الصافي)</h2><a class="anchor" href="#formula">#formula</a></div>
        <pre class="kbd" style="display:block;white-space:pre-wrap">
الإجمالي (Gross) = الأساسي + البدلات + الإضافي
الصافي (Net)     = الإجمالي
                   − خصومات البنود (deduction)
                   − خصم التأخير (late_ded)
                   − خصم الغياب (absence_ded)
                   − التأمينات (gosi_ded)
                   − خصم مرضي (sick_ded)
        </pre>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>معاملات الحساب الافتراضية في أعلى الصفحة: <span class="kbd">WORK_DAYS_MONTH=30</span>, <span class="kbd">WORK_HOURS_DAY=8</span>, <span class="kbd">LATE_MULTIPLIER=1.5</span>, <span class="kbd">ABS_MULTIPLIER=1.5</span>, <span class="kbd">OT_RATE_WORKING=1.5</span>, <span class="kbd">OT_RATE_OFFDAY=2.0</span>, <span class="kbd">HALF_DAY_MINUTES=240</span>.</li>
        </ul>
      </section>

      <section id="functions" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الدوال المساعدة (من الصفحة)</h2><a class="anchor" href="#functions">#functions</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2 text-sm">
          <li><span class="kbd">month_bounds()</span> — يتحقق من المستقبل، ويقص الشهر الحالي “حتى أمس”.</li>
          <li><span class="kbd">get_shift_times()</span> — يجلب أوقات الدوام من <span class="kbd">work_shifts</span> للموظف (افتراضي 08:00–16:00).</li>
          <li><span class="kbd">get_work_weekdays()</span> — أيام العمل من <span class="kbd">department_work_days</span> مطروحًا منها يوم الراحة.</li>
          <li><span class="kbd">get_leave_dates()</span> — يبني تواريخ الإجازات المقبولة المتقاطعة مع الشهر.</li>
          <li><span class="kbd">get_month_attendance()</span> — أقل “دخول” وأعلى “خروج” لكل يوم، ويحسِب الدقائق العاملة (لا يحسب الفواصل/تعدّد البصمات).</li>
          <li><span class="kbd">get_employee_basic_salary()</span> — آخر قيمة “أساسي” حتى آخر يوم بالشهر.</li>
          <li><span class="kbd">get_employee_component_sum(type)</span> — مجموع آخر قيمة لكل بند من النوع (allowance/deduction) حتى آخر الشهر.</li>
          <li><span class="kbd">get_employee_late_hours()</span> — ساعات التأخير بعد وقت الدوام (مع تحقّق حالة الحضور).</li>
          <li><span class="kbd">calculate_overtime_pay()</span> — أجر الإضافي: كامل الوقت في أيام الراحة بمعدل <span class="kbd">OT_RATE_OFFDAY</span>، وبعد نهاية الدوام في أيام العمل بمعدل <span class="kbd">OT_RATE_WORKING</span> وبحدّ أقصى فوق ساعات الدوام.</li>
          <li><span class="kbd">get_employee_gosi_deduction()</span> — آخر سجل ساري في <span class="kbd">social_insurance</span> ضمن الشهر (نسبة الموظف × وعاء الاشتراك).</li>
          <li><span class="kbd">get_sick_impact_monthly()</span> — يحسب أيام مرضية الشهر وفق سنة مرضية رجعية: أول 30 يوم (كامل)، ثم حتى 90 (مدفوع 75% → خصم 25%)، وبعدها (غير مدفوع → خصم 100%). الناتج: <span class="kbd">{full,p75,unpaid}</span> ويُشتق منه <span class="kbd">sick_ded</span>.</li>
        </ul>
        <div class="mt-2 text-sm opacity-90">
          إن كانت سياسة شركتكم مختلفة (مثلاً شريحة 50%) يمكن تعديل الدالة لإضافة شريحة إضافية.
        </div>
      </section>

      <section id="ajax" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحديث الجدول AJAX</h2><a class="anchor" href="#ajax">#ajax</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>التحديث يتم عبر <span class="kbd">GET</span> لنفس الصفحة بـ <span class="kbd">ajax=1</span> وتمرير: <span class="kbd">month, year, calc_late, calc_ot, calc_abs, calc_gosi</span>.</li>
          <li>الصفحة تُعيد صفوف <span class="kbd">&lt;tr&gt;</span> فقط، ثم تُحقّق دوال إظهار/إخفاء الأعمدة: <span class="kbd">.col-late/.col-ot/.col-abs/.col-gosi</span> (بينما <span class="kbd">.col-sick</span> دائمًا ظاهرة).</li>
          <li>انتبِه: استخدام <span class="kbd">window.location.pathname</span> يعني أن الطلب يُرسل لنفس المسار بدقة؛ لو تغيّر المسار داخل مجلدات مختلفة عدِّله حسب الحاجة.</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والممارسات الجيدة</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>أضف رمز <span class="kbd">CSRF</span> لنموذج الحفظ (POST) وتحقق من الصلاحيات قبل الإدراج.</li>
          <li>تحقق خادميًّا من المدخلات (Month/Year ضمن المدى، القيم ≥ 0، الموظف “نشط”).</li>
          <li>التجميد بعد الاعتماد: احفظ Snapshot أو امنع التعديل بعد إصدار ملف البنك.</li>
          <li>أداء: ضع فهارس على جداول الحضور/الرواتب (<span class="kbd">attendance(user_id,date)</span>، <span class="kbd">employee_salary_items(employee_id,created_at)</span>...).</li>
        </ul>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحسينات مقترحة</h2><a class="anchor" href="#improve">#improve</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>حفظ مبالغ <b>خصم التأخير</b> و<b>خصم الغياب</b> ضمن <span class="kbd">payroll_items</span> (أعمدة جديدة) بدل العرض فقط.</li>
          <li>إضافة ملخص أعلى الجدول (إجمالي أساسي/بدلات/خصومات/صافي لكل المسير).</li>
          <li>فلترة بالاسم/الإدارة قبل تكوين الجدول لتخفيف الحمل عند عدد موظفين كبير.</li>
          <li>زر “معاينة قبل الحفظ” يوضح الفرق عن الشهر السابق.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أسئلة شائعة</h2><a class="anchor" href="#faq">#faq</a></div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش يوم اليوم ما يدخل بالحساب؟</summary>
          <p class="mt-2 opacity-90">الدالة <span class="kbd">month_bounds</span> تقصّ الشهر الحالي إلى “أمس” لتجنّب بيانات ناقصة. يمكن تعديلها لاحتساب اليوم عند نهاية الدوام.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">الحضور عندنا فيه أكثر من “دخول/خروج” في اليوم، هل محسوب؟</summary>
          <p class="mt-2 opacity-90">الحساب الحالي يأخذ أقل دخول وأعلى خروج فقط. لو عندكم بصمات متعددة/فواصل، أضف منطق جمع الفترات داخل اليوم.</p>
        </details>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="index.php">مسيرات الرواتب</a></li>
          <li><a class="underline" href="create.php">إنشاء مسير جديد (الصفحة الحالية)</a></li>
          <li><a class="underline" href="employee_salary_items.php">إدارة بنود الرواتب للموظفين</a></li>
          <li><a class="underline" href="salary_components.php">إدارة البنود المالية</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">خلّنا نتواصل</h2><a class="anchor" href="#contact">#contact</a></div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>

    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];
    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const txt=document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
