<?php
// /erp_task_system/payrolls/help_payrolls.php  ← عدّل المسار إذا لزم
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';

if (!isset($_SESSION['user'])) { header('Location: /erp_task_system/unauthorized.php'); exit; }

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "مسيرات الرواتب"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e; /* واتساب */
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    .chip{ display:inline-block; padding:2px 8px; border-radius:9999px; font-size:.75rem; margin-left:.35rem }
    .b-yellow{ background:#fef3c7; color:#92400e }
    .b-green{  background:#dcfce7; color:#166534 }
    .b-blue{   background:#e0f2fe; color:#0369a1 }
    .b-slate{  background:#e2e8f0; color:#334155 }

    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#columns">أعمدة الجدول</a>
        <a href="#statuses">معاني الحالات</a>
        <a href="#actions">الأزرار والإجراءات</a>
        <a href="#export">التصدير والطباعة</a>
        <a href="#security">الأمان والممارسات الجيدة</a>
        <a href="#tech">ملاحظات تقنية من الكود</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <!-- عدّل الرابط حسب اسم ملفك (index/list) -->
        <button onclick="history.back()" class="w-full px-3 py-2 rounded bg-blue-600 text-white">الرجوع للصفحة</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“مسيرات الرواتب”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          الصفحة تعرض جميع مسيرات الرواتب مرتّبة تنازليًا (سنة/شهر) مع الحالة وروابط الإدارة (عرض التفاصيل، توليد ملفات البنك، وإعادة الاحتساب).
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول يمر عبر <span class="kbd">auth.php</span> (جلسة مستخدم صالحة).</li>
          <li>يُفضّل تقييد الأزرار الحسّاسة (إنشاء/إعادة احتساب/توليد بنك) على <b>المدير العام/المالية</b> فقط.</li>
        </ul>
      </section>

      <section id="columns" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أعمدة الجدول</h2><a class="anchor" href="#columns">#columns</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>#</b> — معرف المسير <span class="kbd">payrolls.id</span>.</li>
          <li><b>الشهر/السنة</b> — <span class="kbd">month</span> و<span class="kbd">year</span>.</li>
          <li><b>الحالة</b> — <span class="kbd">draft</span> / <span class="kbd">approved</span> / <span class="kbd">sent</span>.</li>
          <li><b>تاريخ الإنشاء</b> — <span class="kbd">created_at</span>.</li>
          <li><b>إجراءات</b> — روابط الإدارة (تفاصيل، ملف البنك، ملف كامل، إعادة احتساب).</li>
        </ul>
      </section>

      <section id="statuses" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">معاني الحالات</h2><a class="anchor" href="#statuses">#statuses</a></div>
        <p class="mt-2">
          <span class="chip b-yellow">مسودة (draft)</span>
          <span class="chip b-green">معتمد (approved)</span>
          <span class="chip b-blue">مرسل للبنك (sent)</span>
          <span class="chip b-slate">حالات أخرى/مخصّصة</span>
        </p>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>لا يُفضّل توليد ملف بنك لمسير <b>مسودة</b> قبل الاعتماد.</li>
          <li>بعد “مرسل للبنك” يُمنع التعديل إلا عبر إجراء إداري (حسب سياساتكم).</li>
        </ul>
      </section>

      <section id="actions" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأزرار والإجراءات</h2><a class="anchor" href="#actions">#actions</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>➕ إنشاء مسير جديد:</b> يفتح <span class="kbd">create.php</span> لإعداد مسير (شهر/سنة) وبناء تفاصيل الرواتب.</li>
          <li><b>👥 إدارة بنود الرواتب:</b> <span class="kbd">employee_salary_items.php</span> — ضبط البنود المرتبطة بالموظفين.</li>
          <li><b>💰 إدارة البنود المالية:</b> <span class="kbd">salary_components.php</span> — تعريف البنود (أساسي/بدلات/خصومات…).</li>
          <li><b>عرض التفاصيل:</b> <span class="kbd">view.php?id=PAYROLL_ID</span> — مراجعة مسير معيّن.</li>
          <li><b>ملف البنك:</b> <span class="kbd">generate.php?id=PAYROLL_ID</span> — يُولّد ملف التحويل البنكي بالتنسيق المطلوب.</li>
          <li><b>ملف كامل:</b> <span class="kbd">generate.php?id=PAYROLL_ID&full=1</span> — نسخة موسّعة لاستخدامات التدقيق/الأرشفة.</li>
          <li><b>إعادة الاحتساب:</b> <span class="kbd">recalc_run.php?payroll_id=ID&month=M&year=Y&snapshot=1</span>
            — يعيد حساب التفاصيل (احرص على الحقول <span class="kbd">snapshot</span> وسياسة التجميد بعد الاعتماد).</li>
        </ul>
      </section>

      <section id="export" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">التصدير والطباعة</h2><a class="anchor" href="#export">#export</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>التصدير البنكي يتم عبر <span class="kbd">generate.php</span> (مع/بدون <span class="kbd">full=1</span>).</li>
          <li>للتقارير السريعة، اطبع من المتصفح مع إعدادات الطباعة الافتراضية.</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والممارسات الجيدة</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>قيود صلاحيات واضحة على: إنشاء المسير، إعادة الاحتساب، توليد ملف البنك.</li>
          <li>تجميد المسير بعد الاعتماد/الإرسال لمنع التعديلات غير المقصودة.</li>
          <li>تتبّع الأثر (Logs): من عدّل؟ ومتى؟ وما التغييرات؟</li>
          <li>نسخة Snapshot لرواتب الموظفين وقت توليد المسير لضمان ثبات الأرقام عند إعادة الحساب.</li>
        </ul>
      </section>

      <section id="tech" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">ملاحظات تقنية من الكود</h2><a class="anchor" href="#tech">#tech</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2 text-sm">
          <li>جلب المسيرات:
            <span class="kbd">SELECT * FROM payrolls ORDER BY year DESC, month DESC</span>.</li>
          <li><b>تنبيه HTML:</b> في صفحتك الأساسية، وِجد `<tbody` بدون `>` قبل حلقة الـ PHP — أضف الإغلاق: <span class="kbd">&lt;tbody&gt;</span>.</li>
          <li>تم تضمين ملفات <span class="kbd">select2</span> لكن ما تُستخدم هنا — تقدر تشيلها لتخفيف التحميل.</li>
          <li>فهرسة مقترحة: على <span class="kbd">(year, month)</span> و/أو <span class="kbd">(status)</span> لتحسين الاستعلامات المستقبلية.</li>
        </ul>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify_between"><h2 class="text-xl font-bold">تحسينات مقترَحة</h2><a class="anchor" href="#improve">#improve</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>فلاتر أعلى الجدول: الشهر/السنة/الحالة + بحث سريع.</li>
          <li>تلوين الصف حسب الحالة، وإضافة شارة “مجمد” بعد الإرسال.</li>
          <li>زر تصدير CSV/Excel لقائمة المسيرات مع الحالة والتواريخ.</li>
          <li>تأكيد مزدوج قبل “إعادة الاحتساب” مع توضيح تأثيره.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أسئلة شائعة</h2><a class="anchor" href="#faq">#faq</a></div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">ليش ملف البنك ما يفتح صح؟</summary>
          <p class="mt-2 opacity-90">تأكّد من تنسيق الأعمدة والترميز حسب متطلبات البنك، وقد تحتاج حفظه كـ CSV بترميز UTF-8/BOM.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أعدتُ الاحتساب وتغيّرت الأرقام!</summary>
          <p class="mt-2 opacity-90">هذا طبيعي إذا ما فيه Snapshot ثابت. اعتمد سياسة تجميد الأرقام بعد الاعتماد/الإرسال.</p>
        </details>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify_between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="create.php">إنشاء مسير جديد</a></li>
          <li><a class="underline" href="employee_salary_items.php">إدارة بنود الرواتب للموظفين</a></li>
          <li><a class="underline" href="salary_components.php">إدارة البنود المالية</a></li>
          <li><a class="underline" href="view.php">عرض تفاصيل المسير</a></li>
          <li><a class="underline" href="generate.php">توليد ملف البنك / الملف الكامل</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify_between">
          <h2 class="text-xl font-bold">خلّنا نتواصل</h2><a class="anchor" href="#contact">#contact</a>
        </div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>
    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];

    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const txt=document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
