<?php
// /erp_task_system/payrolls/help_salary_components.php  ← عدّل المسار إذا لزم
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
require_once '../../authorize.php';

if (!isset($_SESSION['user'])) { header('Location: /erp_task_system/unauthorized.php'); exit; }
allow_roles(['admin']); // نفس منطق الصفحة الأصلية

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "إدارة البنود المالية"';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e;
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    .chip{ display:inline-block; padding:2px 8px; border-radius:9999px; font-size:.75rem; margin-left:.35rem }
    .b-green{  background:#dcfce7; color:#166534 }
    .b-red{    background:#fee2e2; color:#991b1b }
    .b-blue{   background:#e0f2fe; color:#0369a1 }
    .b-indigo{ background:#e0e7ff; color:#3730a3 }
    .b-slate{  background:#e2e8f0; color:#334155 }

    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- الفهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#columns">أعمدة الجدول</a>
        <a href="#types">أنواع البنود</a>
        <a href="#auto">الحقل “آلي؟”</a>
        <a href="#codes">حقل الكود (Code)</a>
        <a href="#actions">الإجراءات (إضافة/تعديل/حذف)</a>
        <a href="#impact">أثر البنود على المسير</a>
        <a href="#security">الأمان والممارسات الجيدة</a>
        <a href="#tech">ملاحظات تقنية من الكود</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="history.back()" class="w-full px-3 py-2 rounded bg-blue-600 text-white">الرجوع للصفحة</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">

      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“إدارة البنود المالية”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تُستخدم هذه الصفحة لتعريف البنود المالية (البدلات/الخصومات/الأوفر تايم/الأساسي) التي تُبنى عليها رواتب الموظفين.
          يمكن إضافة بند جديد أو تعديل بند موجود أو تعطيله دون حذفه.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>الوصول والإجراءات محصور على <b>المشرف (admin)</b> عبر <span class="kbd">allow_roles(['admin'])</span>.</li>
        </ul>
      </section>

      <section id="columns" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أعمدة الجدول</h2><a class="anchor" href="#columns">#columns</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>#</b> — معرف البند.</li>
          <li><b>اسم البند</b> — نص ظاهر للمستخدمين.</li>
          <li><b>النوع</b> — شارة توضّح التصنيف (بدل/خصم/أوفر تايم/أساسي).</li>
          <li><b>آلي؟</b> — “✔️” إذا كان يُحسب تلقائيًا أو “يدوي”.</li>
          <li><b>الحالة</b> — مفعل/معطل (شارات).</li>
          <li><b>الكود</b> — رمز مختصر للبند (اختياري لكنه مفيد للربط).</li>
          <li><b>ملاحظات</b> — نص توضيحي.</li>
          <li><b>إجراءات</b> — تعديل/حذف.</li>
        </ul>
      </section>

      <section id="types" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أنواع البنود</h2><a class="anchor" href="#types">#types</a></div>
        <p class="mt-2">
          <span class="chip b-indigo">أساسي (basic)</span>
          <span class="chip b-green">بدل (allowance)</span>
          <span class="chip b-red">خصم (deduction)</span>
          <span class="chip b-blue">أوفر تايم (overtime)</span>
        </p>
        <div class="mt-2 text-sm opacity-90">
          في صفحة إنشاء المسير الحالية، الحسابات التلقائية تجمع <b>allowance</b> و <b>deduction</b> وتقرأ <b>basic</b>،  
          بينما نوع <b>overtime</b> لا يُجمع عبر <span class="kbd">get_employee_component_sum()</span> (الإضافي يُحسب من الحضور بدالة مستقلة).
        </div>
      </section>

      <section id="auto" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الحقل “آلي؟”</h2><a class="anchor" href="#auto">#auto</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>يدوي (0):</b> القيمة تُسجّل يدويًا لكل موظف في صفحة “بنود الموظفين”.</li>
          <li><b>آلي (1):</b> قيمة البند مفترض تُشتق من منطق داخلي (مثال: بدل خطر 20% من الأساسي).  
              <span class="opacity-80">إن رغبت بتفعيل هذا فعليًا، أضف كود الحسبة عند إنشاء المسير أو كـ Job مسبق.</span>
          </li>
        </ul>
      </section>

      <section id="codes" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">حقل الكود (Code)</h2><a class="anchor" href="#codes">#codes</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>يوصَى بتوحيد رموز لبعض البنود الأساسية لتسهيل المعالجة لاحقًا، مثل:
            <span class="kbd">BASIC</span>, <span class="kbd">HOUSING</span>, <span class="kbd">TRANSPORT</span>.</li>
          <li>ضع قيد فريد (Unique) على <span class="kbd">code</span> إذا احتجت عدم التكرار.</li>
        </ul>
      </section>

      <section id="actions" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الإجراءات (إضافة/تعديل/حذف)</h2><a class="anchor" href="#actions">#actions</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>إضافة بند:</b> زر <b>➕ إضافة بند</b> يفتح مودال ويحفظ عبر <span class="kbd">save_salary_component.php</span> (POST).</li>
          <li><b>تعديل:</b> زر <b>تعديل</b> يملأ بيانات المودال ثم حفظ.</li>
          <li><b>حذف:</b> الرابط <span class="kbd">delete_component.php?id=…</span> مع تأكيد.  
              <span class="opacity-80">للسلامة، يفضّل <b>التعطيل</b> بدل الحذف عند وجود سجلات موظفين مرتبطة.</span>
          </li>
        </ul>
      </section>

      <section id="impact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أثر البنود على المسير</h2><a class="anchor" href="#impact">#impact</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>القيم المستخدمة في المسير تُقرأ من جدول <span class="kbd">employee_salary_items</span> (آخر قيمة حتى نهاية الشهر).</li>
          <li>تعطيل بند هنا لا يمس السجلات القديمة تلقائيًا؛ فقط يمنع ظهوره كخيار جديد أو يُستثنى منطقيًا حسب تطبيقك.</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والممارسات الجيدة</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>تحقق من الصلاحيات في كل ملفات المعالجة (حفظ/حذف) وليس الواجهة فقط.</li>
          <li>أضف <span class="kbd">CSRF</span> لطلبات POST، ورسائل أخطاء واضحة.</li>
          <li>تحقق من <b>type</b> ضمن القيم المسموحة، و<strong>value ≥ 0</strong> عند الاستخدام مع الموظفين.</li>
          <li>سجل تدقيق (من عدّل/أضاف/حذف ومتى) للامتثال المالي.</li>
        </ul>
      </section>

      <section id="tech" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">ملاحظات تقنية من الكود</h2><a class="anchor" href="#tech">#tech</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1 text-sm">
          <li>جلب البنود: <span class="kbd">SELECT id,name,type,is_active,is_automatic,notes,code FROM salary_components ORDER BY type,id</span>.</li>
          <li>المودال يُعبَّأ عبر <span class="kbd">openComponentModal(row)</span> ويُحفظ بـ <span class="kbd">save_salary_component.php</span>.</li>
          <li>إظهار الشارات يتم عبر دوال PHP صغيرة (<span class="kbd">typeBadge()</span>، <span class="kbd">statusBadgeFromBool()</span>).</li>
        </ul>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحسينات مقترحة</h2><a class="anchor" href="#improve">#improve</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>إضافة حقول <b>effective_date</b> و<b>end_date</b> لإدارة صلاحية القيم تاريخيًا.</li>
          <li>فرض فريد على <b>code</b>، والتحقق من عدم تكرار اسم/كود مع نفس النوع.</li>
          <li>فلترة/بحث أعلى الجدول (النوع، الحالة، نص حر).</li>
        </ul>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="salary_components.php">إدارة البنود المالية (الصفحة الحالية)</a></li>
          <li><a class="underline" href="employee_salary_items.php">بنود الرواتب للموظفين</a></li>
          <li><a class="underline" href="index.php">مسيرات الرواتب</a></li>
          <li><a class="underline" href="create.php">إنشاء مسير رواتب جديد</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">خلّنا نتواصل</h2><a class="anchor" href="#contact">#contact</a></div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>

    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q = document.getElementById('q');
    const secs = [...document.querySelectorAll('[data-sec]')];
    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const txt=document.createTextNode(m.textContent);
        m.parentNode.replaceChild(txt,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
