<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// جلب بيانات المستخدم والألوان
$user = $_SESSION['user'];
$role = $user['role'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'] ?? '#233a58';
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];

// جلب كل المسيرات
$stmt = $conn->prepare("SELECT * FROM payrolls ORDER BY year DESC, month DESC");
$stmt->execute();
$payrolls = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مسيرات الرواتب</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <style>
      body { background-color: <?= $userThemeColor ?> !important; color: <?= $userThemeTextColor ?> !important; }
      .main-card { background: #fff; border-radius: 1.25rem; box-shadow: 0 2px 12px 0 #0001; }
      table th, table td { color: #222 !important; }
      nav, .card { background-color: <?= $userThemeNavColor ?> !important; }
      .text, label, option, h2, select, a { color: <?= $userThemeTextColor ?> !important; }
      option { text-align: center; }
      .select2-container .select2-selection--single { height: 48px; line-height: 48px; font-size: 12px;}
      .select2-container--default .select2-selection--single { background-color: <?= $userThemeNavColor ?> !important; border: none;}
      .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 48px; color: <?= $userThemeTextColor ?> !important; }
      .select2-container--default .select2-selection--single .select2-selection__arrow { height: 48px; }
      .select2-dropdown { font-size: 12px; }
      .select2-results__option { padding: 12px; line-height: 24px; }
      .select2-container { width: 100% !important; }
    </style>
</head>
<body>
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
<div class="h-20"></div>

<!-- كرت عرض مسيرات الرواتب -->
<div class="max-w-5xl mx-auto mt-6 main-card p-8">
<div class="flex justify-between items-center mb-6">
<style>.rtl-left{ margin-right:auto; }</style>

<div class="flex items-center gap-2 mb-4">
  <h1 class="text-2xl font-bold">مسيرات الرواتب</h1>
  <a href="help_payrolls.php" target="_blank"
     class="rtl-left inline-flex items-center gap-2 px-3 py-1.5 rounded-xl bg-gray-200 text-gray-900 hover:bg-gray-300">
❓ تعليمات
  </a>
</div>
  <div class="flex gap-2">
    <a href="create.php" class="bg-blue-600 text-white px-6 py-2 rounded-xl hover:bg-blue-800 transition">➕ إنشاء مسير جديد</a>
    <a href="employee_salary_items.php" class="bg-green-600 text-white px-6 py-2 rounded-xl hover:bg-green-700 transition">👥 إدارة بنود الرواتب</a>
    <a href="salary_components.php" class="bg-purple-600 text-white px-6 py-2 rounded-xl hover:bg-purple-700 transition">💰 إدارة البنود المالية</a>
  </div>
</div>
    <table class="w-full text-center border rounded-xl overflow-hidden">
        <thead>
            <tr class="bg-gray-100">
                <th class="py-2">#</th>
                <th>الشهر</th>
                <th>السنة</th>
                <th>الحالة</th>
                <th>تاريخ الإنشاء</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody
<?php foreach ($payrolls as $row): ?>
    <tr class="border-b hover:bg-gray-50 transition">
        <td><?= $row['id'] ?></td>
        <td><?= $row['month'] ?></td>
        <td><?= $row['year'] ?></td>
        <td>
            <?php
            if ($row['status'] == 'draft') {
                echo '<span class="text-yellow-600 font-bold">مسودة</span>';
            } elseif ($row['status'] == 'approved') {
                echo '<span class="text-green-700 font-bold">معتمد</span>';
            } elseif ($row['status'] == 'sent') {
                echo '<span class="text-blue-700 font-bold">مرسل للبنك</span>';
            }
            ?>
        </td>
        <td><?= $row['created_at'] ?></td>
        <td>
            <a href="view.php?id=<?= $row['id'] ?>" class="text-blue-600 hover:underline font-semibold">عرض التفاصيل</a>
            |
            <a href="generate.php?id=<?= $row['id'] ?>" class="text-green-600 hover:underline font-semibold">ملف البنك</a>
            |
            <a href="generate.php?id=<?= $row['id'] ?>&full=1" class="text-purple-600 hover:underline font-semibold">ملف كامل</a>
            |
            <a href="recalc_run.php?payroll_id=<?= $row['id'] ?>&month=<?= $row['month'] ?>&year=<?= $row['year'] ?>&snapshot=1"
               class="text-red-600 hover:underline font-semibold">إعادة الاحتساب</a>
        </td>
    </tr>
<?php endforeach ?>
        </tbody>
    </table>
    <?php if (count($payrolls) == 0): ?>
        <div class="text-center py-8 text-gray-400 font-bold">لا يوجد مسيرات رواتب حتى الآن.</div>
    <?php endif ?>
</div>
</body>
</html>
