<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
require_once '../../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* يسمح فقط للمشرف */
allow_roles(['admin']);

/* هروب آمن */
function e($v){ return htmlspecialchars(is_null($v)?'':(string)$v, ENT_QUOTES, 'UTF-8'); }

/* ثيم المستخدم */
$user = $_SESSION['user'] ?? [];
$role = $user['role'] ?? 'employee';
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58'];
$userThemeColor      = $color['hex_code']      ?? '#f8fafc';
$userThemeTextColor  = $color['text_color']    ?? '#111827';
$userThemeNavColor   = $color['nav_color']     ?? '#233a58';
$allColors           = $user['colors']         ?? [];
$currentUserColorId  = $user['color_id']       ?? null;

/* جلب البنود – مطابق لهيكل الجدول اللي بالصورة */
$sql = "
  SELECT
    id,
    COALESCE(name,'')          AS name,
    COALESCE(type,'')          AS type,         -- allowance | deduction | overtime | basic
    COALESCE(is_active,0)      AS is_active,
    COALESCE(is_automatic,0)   AS is_automatic,
    COALESCE(notes,'')         AS notes,
    COALESCE(code,'')          AS code
  FROM salary_components
  ORDER BY type, id ASC
";
$stmt = $conn->prepare($sql);
$stmt->execute();
$components = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* بادجات بسيطة */
function badge($text,$class){ return '<span class="px-2 py-1 text-xs rounded '.$class.'">'.e($text).'</span>'; }
function typeBadge($t){
  switch ($t) {
    case 'allowance': return badge('بدل','bg-green-100 text-green-700');
    case 'deduction': return badge('خصم','bg-red-100 text-red-700');
    case 'overtime':  return badge('أوفر تايم','bg-blue-100 text-blue-700');
    case 'basic':     return badge('أساسي','bg-indigo-100 text-indigo-700');
    default:          return badge($t ?: 'غير محدد','bg-gray-100 text-gray-600');
  }
}
function statusBadgeFromBool($active){
  return $active ? badge('مفعل','bg-emerald-100 text-emerald-700')
                 : badge('معطل','bg-gray-200 text-gray-700');
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>💰 إدارة البنود المالية</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- jQuery + Select2 لاختيار النمط -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <style>
    body, .card { background-color: <?= e($userThemeColor) ?> !important; }
    nav, .toolbar { background-color: <?= e($userThemeNavColor) ?> !important; }
    .text, th, td, a, label, h1, h2 { color: <?= e($userThemeTextColor) ?> !important; }
    .main-card { background:#fff; border-radius:1rem; box-shadow:0 2px 12px #0000001a; }
    .btn { padding:.55rem 1rem; border-radius:.75rem; color:#fff !important; display:inline-block; }
    .table th, .table td { color:#222 !important; }
    .select2-container--default .select2-selection--single { background-color: <?= e($userThemeNavColor) ?> !important; border: none; height: 42px; }
    .select2-container--default .select2-selection--single .select2-selection__rendered { color: <?= e($userThemeTextColor) ?> !important; line-height: 42px; }
    .select2-container { width: 100% !important; }
  </style>
</head>
<body class="text-right">
    
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
<div class="h-20"></div>

<div class="max-w-6xl mx-auto main-card p-8 mt-8">
<style>.rtl-left{ margin-right:auto; }</style>

<div class="flex justify-between items-center mb-6">
  <h1 class="text-2xl font-bold">إدارة البنود المالية (البدلات والخصومات)</h1>

  <a href="help_salary_components.php" target="_blank"
     class="rtl-left inline-flex items-center gap-2 px-3 py-1.5 rounded-xl bg-gray-200 text-gray-900 hover:bg-gray-300">
❓ تعليمات
  </a>

  <div class="flex gap-2">
    <a href="index.php" class="btn bg-blue-600 hover:bg-blue-700">⬅ مسيرات الرواتب</a>
    <a href="employee_salary_items.php" class="btn bg-green-600 hover:bg-green-700">👥 بنود الموظفين</a>
    <button onclick="openComponentModal()" class="btn bg-purple-600 hover:bg-purple-700">➕ إضافة بند</button>
  </div>
</div>
  </div>

  <div class="overflow-x-auto">
    <table class="w-full border text-center table">
      <thead>
        <tr class="bg-gray-100">
          <th class="p-2 border">#</th>
          <th class="p-2 border">اسم البند</th>
          <th class="p-2 border">النوع</th>
          <th class="p-2 border">آلي؟</th>
          <th class="p-2 border">الحالة</th>
          <th class="p-2 border">الكود</th>
          <th class="p-2 border">ملاحظات</th>
          <th class="p-2 border">إجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$components): ?>
          <tr><td colspan="8" class="p-6 text-gray-500">ما فيه بنود حالياً.</td></tr>
        <?php else: foreach($components as $row): ?>
          <tr class="border-b hover:bg-gray-50">
            <td class="p-2 border"><?= (int)$row['id'] ?></td>
            <td class="p-2 border"><?= e($row['name']) ?></td>
            <td class="p-2 border"><?= typeBadge($row['type']) ?></td>
            <td class="p-2 border"><?= ((int)$row['is_automatic'] === 1) ? '✔️' : 'يدوي' ?></td>
            <td class="p-2 border"><?= statusBadgeFromBool((int)$row['is_active'] === 1) ?></td>
            <td class="p-2 border"><?= e($row['code']) ?></td>
            <td class="p-2 border"><?= e($row['notes']) ?></td>
            <td class="p-2 border">
              <button
                onclick='openComponentModal(<?= json_encode($row, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP) ?>)'
                class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600">تعديل</button>
              <a href="delete_component.php?id=<?= (int)$row['id'] ?>"
                 onclick="return confirm('حذف البند؟')"
                 class="bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 inline-block ml-1">حذف</a>
            </td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- مودال إضافة/تعديل بند -->
<div id="componentModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center">
  <div class="bg-white rounded-lg p-6 max-w-md w-full">
    <div class="flex justify-between items-center mb-4">
      <h2 class="text-xl font-bold" id="modalTitle">إضافة بند مالي</h2>
      <button onclick="closeComponentModal()" class="text-xl">&times;</button>
    </div>
    <form method="POST" id="componentForm" action="save_salary_component.php">
      <input type="hidden" name="id" id="compId">
      <div class="mb-3">
        <label>اسم البند</label>
        <input type="text" name="name" id="compName" class="border rounded w-full px-2 py-2" required>
      </div>
      <div class="mb-3">
        <label>النوع</label>
        <select name="type" id="compType" class="border rounded w-full px-2 py-2" required>
          <option value="allowance">بدل</option>
          <option value="deduction">خصم</option>
          <option value="overtime">أوفر تايم</option>
          <option value="basic">أساسي</option>
        </select>
      </div>
      <div class="mb-3">
        <label>هل هو آلي؟</label>
        <select name="is_automatic" id="compAutomatic" class="border rounded w-full px-2 py-2">
          <option value="0">يدوي</option>
          <option value="1">آلي (يُحسب تلقائياً)</option>
        </select>
      </div>
      <div class="mb-3">
        <label>الكود</label>
        <input type="text" name="code" id="compCode" class="border rounded w-full px-2 py-2">
      </div>
      <div class="mb-3">
        <label>ملاحظات</label>
        <input type="text" name="notes" id="compNotes" class="border rounded w-full px-2 py-2">
      </div>
      <div class="mb-3">
        <label>الحالة</label>
        <select name="is_active" id="compActive" class="border rounded w-full px-2 py-2">
          <option value="1">مفعل</option>
          <option value="0">معطل</option>
        </select>
      </div>
      <div class="mt-4 text-center">
        <button type="submit" class="bg-blue-700 text-white px-8 py-2 rounded-xl hover:bg-blue-900">حفظ</button>
      </div>
    </form>
  </div>
</div>

<script>
  function openComponentModal(row = null) {
    document.getElementById('componentModal').classList.remove('hidden');
    document.getElementById('modalTitle').textContent = row ? "تعديل بند مالي" : "إضافة بند مالي";
    document.getElementById('componentForm').reset();

    if (row) {
      document.getElementById('compId').value         = row.id || '';
      document.getElementById('compName').value       = row.name || '';
      document.getElementById('compType').value       = row.type || 'allowance';
      document.getElementById('compAutomatic').value  = (row.is_automatic !== undefined && row.is_automatic !== null) ? row.is_automatic : '0';
      document.getElementById('compCode').value       = row.code || '';
      document.getElementById('compNotes').value      = row.notes || '';
      document.getElementById('compActive').value     = (row.is_active !== undefined && row.is_active !== null) ? row.is_active : '1';
    }
  }

  function closeComponentModal() {
    document.getElementById('componentModal').classList.add('hidden');
  }

  // إغلاق عند الضغط خارج المودال
  document.addEventListener('click', function(e){
    let modal = document.getElementById('componentModal');
    if(!modal.classList.contains('hidden') && e.target === modal) closeComponentModal();
  });
</script>
</body>
</html>