<?php
// /erp_task_system/users/settlements/api/delete_item.php
if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../_helpers.php';
require_roles(['admin','manager','hr','HR']);

try {
  $uid = current_user_id();
  if (!$uid) throw new Exception('login');

  $sid    = (int)($_POST['settlement_id'] ?? 0);
  $itemId = (int)($_POST['item_id'] ?? 0);
  if ($sid <= 0 || $itemId <= 0) throw new Exception('bad_id');

  $settlement = get_settlement_row($conn, $sid);
  assert_editable($settlement);

  // تأكد أن البند فعلاً يتبع نفس المخالصة
  $st = $conn->prepare("SELECT id FROM settlement_items WHERE id=? AND settlement_id=?");
  $st->execute([$itemId, $sid]);
  if (!$st->fetchColumn()) throw new Exception('item_not_found');

  $conn->beginTransaction();

  $del = $conn->prepare("DELETE FROM settlement_items WHERE id=? AND settlement_id=?");
  $del->execute([$itemId, $sid]);

  recalc_settlement_totals($conn, $sid);

  $conn->commit();
  echo json_encode(['ok'=>true, 'msg'=>'deleted']);
} catch (Exception $e) {
  if ($conn->inTransaction()) $conn->rollBack();
  echo json_encode(['ok'=>false, 'msg'=>$e->getMessage()]);
}
