<?php
/* /erp_task_system/users/settlements/api/employee_snapshot.php */
@ob_clean();
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Riyadh');

session_start();
require_once '../../../config/db.php';

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }

$user_id = (int)($_GET['user_id'] ?? 0);
if ($user_id <= 0) { echo json_encode(['ok'=>false,'msg'=>'bad_user']); exit; }

try {
  $basic      = null;
  $source     = null;
  $hire_date  = null;
  $hints      = [];

  /* 1) من employee_salary_items (المبلغ = value) */
  try {
    $sql = "
      SELECT esi.value AS amt
      FROM employee_salary_items esi
      JOIN salary_components sc
        ON sc.id = esi.component_id
      WHERE esi.employee_id = :uid
        AND (
          LOWER(sc.type) = 'basic'
          OR LOWER(sc.code) = 'basic'
          OR LOWER(sc.name) LIKE '%basic%'
          OR sc.name LIKE '%أساسي%'
        )
      ORDER BY COALESCE(esi.updated_at, esi.created_at, esi.id) DESC
      LIMIT 1
    ";
    $st = $conn->prepare($sql);
    $st->execute([':uid'=>$user_id]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    if ($row && $row['amt'] !== null) {
      $basic  = (float)$row['amt'];
      $source = 'employee_salary_items(value)';
      $hints[] = 'esi hit';
    } else {
      $hints[] = 'esi miss';
    }
  } catch (Throwable $e) {
    $hints[] = 'esi err: '.$e->getMessage();
  }

  /* 2) fallback: آخر مسير (payrolls + payroll_items) */
  if ($basic === null) {
    try {
      $sql = "
        SELECT COALESCE(pi.amount, pi.value) AS amt
        FROM payrolls p
        JOIN payroll_items pi ON pi.payroll_id = p.id
        LEFT JOIN salary_components sc
          ON sc.id = pi.component_id
        WHERE p.user_id = :uid
          AND (
            LOWER(COALESCE(sc.type,'')) = 'basic'
            OR LOWER(COALESCE(sc.code,'')) = 'basic'
            OR LOWER(COALESCE(sc.name,'')) LIKE '%basic%'
            OR COALESCE(sc.name,'') LIKE '%أساسي%'
          )
        ORDER BY COALESCE(p.period_end, p.period_start, p.created_at) DESC, pi.id DESC
        LIMIT 1
      ";
      $st = $conn->prepare($sql);
      $st->execute([':uid'=>$user_id]);
      $row = $st->fetch(PDO::FETCH_ASSOC);
      if ($row && $row['amt'] !== null) {
        $basic  = (float)$row['amt'];
        $source = 'payroll_items';
        $hints[] = 'pi hit';
      } else {
        $hints[] = 'pi miss';
      }
    } catch (Throwable $e) {
      $hints[] = 'pi err: '.$e->getMessage();
    }
  }

  /* تاريخ التعيين للعرض/الحساب */
  try {
    $st = $conn->prepare("SELECT hire_date FROM users WHERE id = :uid LIMIT 1");
    $st->execute([':uid'=>$user_id]);
    $u = $st->fetch(PDO::FETCH_ASSOC);
    $hire_date = $u['hire_date'] ?? null;
  } catch (Throwable $e) {
    $hints[] = 'hire err: '.$e->getMessage();
  }

  $basic = $basic !== null ? $basic : 0.0;
  $daily = $basic > 0 ? round($basic/30, 2) : 0.0;

  echo json_encode([
    'ok'   => true,
    'data' => [
      'basic_salary' => round($basic, 2),
      'daily_wage'   => $daily,
      'hire_date'    => $hire_date,
      'source'       => $source ?: 'none'
    ],
    'debug' => ['hints'=>$hints]
  ], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
