<?php
/* /erp_task_system/users/settlements/create.php */
session_start();
require_once '../../config/db.php';
require_once '../../authorize.php'; // لو عندك تحكم صلاحيات

$user = $_SESSION['user'] ?? [];
if (!$user) { header('Location: ../../login.php'); exit; }

$users = $conn->query("SELECT id, name FROM users ORDER BY id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
$contracts = [];
try { $contracts = $conn->query("SELECT id FROM contracts ORDER BY id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC); } catch(Exception $e){}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title>إنشاء مخالصة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-slate-50">
  <div class="max-w-5xl mx-auto p-6">
<style>.rtl-left{ margin-right:auto; }</style>

<div class="flex items-center gap-2 mb-4">
  <h1 class="text-2xl font-bold">إنشاء مخالصة (HR)</h1>
  <a href="help_settlement_create.php" target="_blank"
     class="rtl-left inline-flex items-center gap-2 px-3 py-1.5 rounded-xl bg-gray-200 text-gray-900 hover:bg-gray-300">
❓ تعليمات
  </a>
</div>

    <form id="settlementForm" class="grid md:grid-cols-2 gap-4 bg-white p-5 rounded-xl shadow">
      <!-- hidden للتحكم بخيار الخصومات -->
      <input type="hidden" name="with_deductions" id="with_deductions" value="1">

      <div>
        <label class="block text-sm mb-1">الموظف</label>
        <select name="employee_id" id="employee_id" class="w-full border rounded p-2" required>
          <option value="">اختر موظف</option>
          <?php foreach($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>"><?= (int)$u['id'] ?> — <?= htmlspecialchars($u['name'] ?: 'بدون اسم') ?></option>
          <?php endforeach; ?>
        </select>
        <p id="emp_hint" class="text-xs text-slate-500 mt-1"></p>
      </div>

      <div>
        <label class="block text-sm mb-1">العقد (اختياري)</label>
        <select name="contract_id" class="w-full border rounded p-2">
          <option value="">بدون</option>
          <?php foreach($contracts as $c): ?>
            <option value="<?= (int)$c['id'] ?>"><?= (int)$c['id'] ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">المنهي</label>
        <select name="initiated_by" class="w-full border rounded p-2" required>
          <option value="employee">الموظف</option>
          <option value="employer">صاحب العمل</option>
          <option value="mutual">اتفاق مشترك</option>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">سبب الإنهاء</label>
        <select name="termination_reason" class="w-full border rounded p-2" required>
          <option value="resignation">استقالة</option>
          <option value="contract_end">انتهاء مدة العقد</option>
          <option value="termination">إنهاء من المنشأة</option>
          <option value="redundancy">ظروف تشغيلية</option>
          <option value="death">وفاة</option>
          <option value="other">أخرى</option>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">تاريخ الإشعار (اختياري)</label>
        <input type="date" name="notice_date" id="notice_date" class="w-full border rounded p-2">
      </div>

      <div>
        <label class="block text-sm mb-1">آخر يوم عمل</label>
        <input type="date" name="last_working_day" id="last_working_day" class="w-full border rounded p-2" required>
      </div>

      <div>
        <label class="block text-sm mb-1">الراتب الأساسي (لقطة)</label>
        <input type="number" step="0.01" name="basic_salary_snapshot" id="basic_salary_snapshot" class="w-full border rounded p-2" required>
      </div>

      <div>
        <label class="block text-sm mb-1">الأجر اليومي (لقطة)</label>
        <input type="number" step="0.01" name="daily_wage_snapshot" id="daily_wage_snapshot" class="w-full border rounded p-2" required>
        <p class="text-xs text-slate-500 mt-1">يُحسب تلقائيًا من الأساسي ÷ 30 (تقدر تغيّره يدويًا).</p>
      </div>

      <div>
        <label class="block text-sm mb-1">أيام الخدمة</label>
        <input type="number" name="service_days_total" id="service_days_total" class="w-full border rounded p-2" required>
        <p id="svc_hint" class="text-xs text-slate-500 mt-1"></p>
      </div>

      <div>
        <label class="block text-sm mb-1">طريقة الصرف</label>
        <select name="pay_method" class="w-full border rounded p-2">
          <option value="bank">تحويل بنكي</option>
          <option value="cash">نقدًا</option>
          <option value="cheque">شيك</option>
        </select>
      </div>

      <div class="md:col-span-2">
        <label class="block text-sm mb-1">ملاحظة</label>
        <textarea name="reason_note" class="w-full border rounded p-2" rows="2"></textarea>
      </div>

      <div class="md:col-span-2 border-t pt-4">
        <div class="flex flex-col md:flex-row gap-3">
          <div class="flex gap-3">
            <button type="submit"
                    class="px-6 py-2 rounded bg-indigo-600 text-white disabled:opacity-60"
                    onclick="document.getElementById('with_deductions').value=1">
              حفظ (مع الخصومات)
            </button>
            <button type="submit"
                    class="px-6 py-2 rounded bg-slate-700 text-white disabled:opacity-60"
                    onclick="document.getElementById('with_deductions').value=0">
              حفظ (بدون خصومات)
            </button>
          </div>
          <a href="index.php" class="px-6 py-2 rounded border text-center">رجوع</a>
        </div>
      </div>
    </form>

    <div id="msg" class="mt-4"></div>
  </div>

<script>
const form = document.getElementById('settlementForm');
const empSel = document.getElementById('employee_id');
const empHint = document.getElementById('emp_hint');
const basic = document.getElementById('basic_salary_snapshot');
const daily = document.getElementById('daily_wage_snapshot');
const lastDay = document.getElementById('last_working_day');
const svcDays = document.getElementById('service_days_total');
const svcHint = document.getElementById('svc_hint');

function fmt(n){ return (Math.round((Number(n)||0)*100)/100).toFixed(2); }

function calcDailyIfEmpty(){
  if (!daily.value || Number(daily.value) <= 0) {
    const b = Number(basic.value||0);
    if (b > 0) daily.value = fmt(b / 30);
  }
}

function diffDays(a,b){
  try{
    const d1 = new Date(a), d2 = new Date(b);
    if (isNaN(d1) || isNaN(d2)) return null;
    const ms = d2.setHours(0,0,0,0) - d1.setHours(0,0,0,0);
    return Math.max(0, Math.round(ms / 86400000));
  }catch(_){ return null; }
}

async function loadSnapshot(){
  empHint.textContent = '';
  const id = empSel.value;
  if(!id) return;
  try{
    const res = await fetch('api/employee_snapshot.php?user_id='+encodeURIComponent(id));
    const j = await res.json();
    if(j.ok){
      if (j.data.basic_salary) {
        basic.value = fmt(j.data.basic_salary);
        calcDailyIfEmpty();
      }
      if (j.data.daily_wage) {
        daily.value = fmt(j.data.daily_wage);
      }
      if (j.data.hire_date && lastDay.value){
        const d = diffDays(j.data.hire_date, lastDay.value);
        if (d !== null) { svcDays.value = d; svcHint.textContent = `من ${j.data.hire_date} إلى ${lastDay.value} = ${d} يوم`; }
      }
      empHint.textContent = j.data.hire_date ? `تاريخ التعيين: ${j.data.hire_date}` : '';
    } else {
      empHint.textContent = 'ما قدرنا نجيب لقطة الموظف.';
    }
  }catch(e){
    empHint.textContent = 'خطأ أثناء جلب بيانات الموظف.';
  }
}

empSel.addEventListener('change', loadSnapshot);
lastDay.addEventListener('change', ()=>{
  // إذا عندنا تاريخ تعيين من الهنت، نحاول نقرأه
  const txt = empHint.textContent||'';
  const m = txt.match(/(\d{4}-\d{2}-\d{2})/);
  if(m){
    const d = diffDays(m[1], lastDay.value);
    if (d !== null) { svcDays.value = d; svcHint.textContent = `من ${m[1]} إلى ${lastDay.value} = ${d} يوم`; }
  }
});
basic.addEventListener('input', calcDailyIfEmpty);

form.addEventListener('submit', async (e)=>{
  e.preventDefault();
  const submitBtns = form.querySelectorAll('button[type="submit"]');
  submitBtns.forEach(b=>b.disabled=true);

  const fd = new FormData(form);
  const res = await fetch('api/create_settlement.php', { method:'POST', body:fd });
  let j = {};
  try { j = await res.json(); } catch(_){}
  const msg = document.getElementById('msg');

  if(j.ok){
    msg.innerHTML = `<div class="p-3 rounded bg-green-100 text-green-800">تم الإنشاء — كود: ${j.code}</div>`;
    setTimeout(()=>{ location.href = 'view.php?id='+j.id; }, 700);
  }else{
    msg.innerHTML = `<div class="p-3 rounded bg-red-100 text-red-800">خطأ: ${j.msg||'unknown'}</div>`;
    submitBtns.forEach(b=>b.disabled=false);
  }
});
</script>
</body>
</html>