<?php
// /erp_task_system/users/settlements/help_settlement_create.php
session_start();
require_once '../../config/db.php';
require_once '../../authorize.php'; // إذا عندك تحكم أدوار
if (function_exists('allow_roles')) { allow_roles(['admin','hr','manager']); }

$user  = $_SESSION['user'] ?? [];
$color = $user['color'] ?? [
  'hex_code'=>'#f8fafc',
  'text_color'=>'#111827',
  'nav_color'=>'#233a58',
  'second_text_color'=>'#94a3b8'
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "إنشاء مخالصة (HR)"';
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e;
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }

    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">
    <!-- فهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات والتدفق</a>
        <a href="#fields">حقول النموذج</a>
        <a href="#snapshots">اللقطات والحسابات التلقائية</a>
        <a href="#submit">الحفظ والرسائل</a>
        <a href="#apis">واجهات الـ API المستخدمة</a>
        <a href="#security">الأمان والتحقق</a>
        <a href="#faq">أسئلة شائعة</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="window.location.href='create.php'" class="w-full px-3 py-2 rounded bg-blue-600 text-white">فتح صفحة الإنشاء</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">
      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“إنشاء مخالصة (HR)”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تُمكّنك هذه الصفحة من إنشاء مخالصة جديدة لموظف مع التقاط لقطات أساسية (الراتب/الأجر اليومي) وحساب أيام الخدمة، ثم حفظها مع خيار تضمين الخصومات أو تجاهلها حسب سياسة المنشأة.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات والتدفق</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>يُفضّل قصر الوصول على <b>الـ HR/المدير/الأدمن</b> عبر <span class="kbd">authorize.php</span>.</li>
          <li>تدفق شائع: اختيار الموظف ← التقاط اللقطات تلقائيًا ← تحديد آخر يوم عمل وأيام الخدمة ← اختيار تضمين الخصومات أو لا ← حفظ والانتقال للتفاصيل.</li>
        </ul>
      </section>

      <section id="fields" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">حقول النموذج</h2><a class="anchor" href="#fields">#fields</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li><b>الموظف</b> — إلزامي. (القائمة تعرض آخر 50 موظفًا وفق الكود الحالي).</li>
          <li><b>العقد (اختياري)</b> — ربط المخالصة بعقد إن لزم.</li>
          <li><b>المنهي</b> — الموظف / صاحب العمل / اتفاق مشترك.</li>
          <li><b>سبب الإنهاء</b> — استقالة / انتهاء مدة العقد / إنهاء / ظروف تشغيلية / وفاة / أخرى.</li>
          <li><b>تاريخ الإشعار</b> — اختياري.</li>
          <li><b>آخر يوم عمل</b> — إلزامي. يُستخدم لحساب أيام الخدمة.</li>
          <li><b>الراتب الأساسي (لقطة)</b> — إلزامي. يمكن تعبئته تلقائيًا من اللقطة ثم تعديله.</li>
          <li><b>الأجر اليومي (لقطة)</b> — إلزامي. يُقترح تلقائيًا (الأساسي ÷ 30) ويمكن تغييره.</li>
          <li><b>أيام الخدمة</b> — إلزامي. يُحسب (تقريبيًا) من <span class="kbd">تاريخ التعيين ← آخر يوم عمل</span>.</li>
          <li><b>طريقة الصرف</b> — تحويل بنكي / نقدًا / شيك.</li>
          <li><b>ملاحظة</b> — نص حر.</li>
          <li><b>with_deductions</b> — حقل مخفي يُضبط عند الضغط على أحد زري الحفظ:
            <ul class="list-disc pr-6 mt-1">
              <li><span class="kbd">حفظ (مع الخصومات)</span> يرسل <span class="kbd">with_deductions=1</span>.</li>
              <li><span class="kbd">حفظ (بدون خصومات)</span> يرسل <span class="kbd">with_deductions=0</span>.</li>
            </ul>
          </li>
        </ul>
      </section>

      <section id="snapshots" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">اللقطات والحسابات التلقائية</h2><a class="anchor" href="#snapshots">#snapshots</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>عند اختيار الموظف، تُحمّل اللقطة عبر <span class="kbd">employee_snapshot.php</span> (الراتب الأساسي/الأجر اليومي/تاريخ التعيين).</li>
          <li><b>الأجر اليومي</b>: إن كان فارغًا، يُحتسب تلقائيًا <span class="kbd">الأساسي ÷ 30</span> (يمكن تعديل القيمة).</li>
          <li><b>أيام الخدمة</b>: تُحسب بالواجهة بالدالة <span class="kbd">diffDays(hire_date, last_working_day)</span> (فرق الأيام غير شامل للنهايات). راجع سياستكم إذا أردتم الاعتماد على حساب خادمي أكثر دقّة (شهور/سنوات/كسور).</li>
        </ul>
      </section>

      <section id="submit" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الحفظ والرسائل</h2><a class="anchor" href="#submit">#submit</a></div>
        <p class="mt-2">
          عند الإرسال، تُرسل البيانات إلى <span class="kbd">api/create_settlement.php</span> (POST). عند النجاح تظهر رسالة: “تم الإنشاء — كود: …” ثم تحويل إلى
          <span class="kbd">view.php?id=ID</span> خلال ثوانٍ. عند الفشل تُعرض رسالة خطأ وتُعاد تفعيل الأزرار.
        </p>
      </section>

      <section id="apis" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">واجهات الـ API المستخدمة</h2><a class="anchor" href="#apis">#apis</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1 text-sm">
          <li><span class="kbd">api/employee_snapshot.php?user_id=ID</span> — (GET) يعيد <span class="kbd">{ok, data:{basic_salary,daily_wage,hire_date,...}}</span>.</li>
          <li><span class="kbd">api/create_settlement.php</span> — (POST) يستقبل الحقول المذكورة + <span class="kbd">with_deductions</span> ويُرجع <span class="kbd">{ok,id,code,msg}</span>.</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والتحقق</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>تحقق الصلاحيات (HR/Admin) قبل عرض الصفحة وحفظ المخالصة.</li>
          <li>أضف <span class="kbd">CSRF</span> لطلبات POST في <span class="kbd">create_settlement.php</span>.</li>
          <li>تحقق خادميًّا من المدخلات: موظف موجود وفعّال، تواريخ منطقية (آخر يوم عمل ≥ تاريخ التعيين)، القيم ≥ 0.</li>
          <li>قيد فريد على <span class="kbd">settlements.code</span> إن كان يُولَّد مسبقًا لتفادي التكرار.</li>
        </ul>
      </section>

      <section id="faq" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أسئلة شائعة</h2><a class="anchor" href="#faq">#faq</a></div>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">اللقطة ما طلعت!</summary>
          <p class="mt-2 opacity-90">تأكد من صحة <span class="kbd">user_id</span> وأن واجهة <span class="kbd">employee_snapshot.php</span> ترجع <span class="kbd">ok:true</span>، وراجع صلاحيات الوصول لبيانات الموظف.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أيام الخدمة غير متوافقة مع حساباتنا.</summary>
          <p class="mt-2 opacity-90">حساب الواجهة بالأيام (فارق زمني). لو عندكم سياسة سنوات/شهور/أيام أو شمول اليوم الأخير، نفّذوا الحسبة في الخادم وفق السياسة.</p>
        </details>
        <details class="mt-2 p-3 rounded bg-white/5">
          <summary class="cursor-pointer font-semibold">أبغى أعتمد المخالصة بعد الإنشاء.</summary>
          <p class="mt-2 opacity-90">هذا يتم عادةً من <span class="kbd">view.php</span> بخطوات الاعتماد وسجل العمليات والمرفقات.</p>
        </details>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحسينات مقترحة</h2><a class="anchor" href="#improve">#improve</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>استخدام Select2 للموظف/العقد مع بحث وتحميل كسول (Lazy load) بدل <span class="kbd">LIMIT 50</span>.</li>
          <li>منطق خادمي لحساب الخدمة (سنوات/شهور/أيام) مع احتساب مكافأة نهاية الخدمة وفق السياسة المحلية.</li>
          <li>عرض تقدير الصافي المتوقع قبل الحفظ، وخيارات خصومات تفصيلية (سلف/عُهد/غياب غير مدفوع...).</li>
          <li>توليد PDF للمخالصة بعد الاعتماد مع توقيع إلكتروني.</li>
        </ul>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="index.php">قائمة المخالصات</a></li>
          <li><a class="underline" href="create.php">إنشاء مخالصة</a></li>
          <li><a class="underline" href="view.php">عرض/اعتماد مخالصة</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">خلّنا نتواصل</h2>
          <a class="anchor" href="#contact">#contact</a>
        </div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>

    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q=document.getElementById('q');
    const secs=[...document.querySelectorAll('[data-sec]')];
    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const t=document.createTextNode(m.textContent); m.parentNode.replaceChild(t,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name=document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg=document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
