<?php
// /erp_task_system/users/settlements/help_settlements_index.php
session_start();
require_once '../../config/db.php';
// لو عندك authorize.php استعمله هنا برضه
// require_once '../../authorize.php';  // مثال
// allow_roles(['admin','manager','hr']); // مثال للصلاحيات

$user  = $_SESSION['user'] ?? [];
$color = $user['color'] ?? [
  'hex_code' => '#f8fafc',
  'text_color' => '#111827',
  'nav_color' => '#233a58',
  'second_text_color' => '#94a3b8',
];

$bg   = htmlspecialchars($color['hex_code']);
$ink  = htmlspecialchars($color['text_color']);
$navc = htmlspecialchars($color['nav_color']);
$muted= htmlspecialchars($color['second_text_color']);

$pageTitle = 'تعليمات صفحة "المخالصات"';
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg: <?= $bg ?>;
      --ink: <?= $ink ?>;
      --muted: <?= $muted ?>;
      --card: <?= $navc ?>;
      --ring:#2563eb;
      --primary:#22c55e;
    }
    body{ background:var(--bg); color:var(--ink); }
    .card{ background:var(--card); border:1px solid rgba(255,255,255,.06); }
    .toc a{ display:block; padding:.45rem .7rem; border-radius:.6rem; }
    .toc a:hover{ background:rgba(255,255,255,.06); }
    .badge{ font-size:.75rem; padding:.15rem .5rem; border-radius:.5rem; background:rgba(255,255,255,.08); }
    .kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; border:1px solid #cbd5e1; border-bottom-width:3px; border-radius:.5rem; padding:.05rem .35rem; background:#fff; color:#111827; }
    .anchor{ opacity:.6; font-size:.9rem; }
    .anchor:hover{ text-decoration: underline; }
    .mark{ background:#fde047; color:#111827; padding:.05rem .15rem; border-radius:.2rem; }
    .chip{ display:inline-block; padding:2px 8px; border-radius:9999px; font-size:.75rem; margin-left:.35rem }
    .b-amber{ background:#fef3c7; color:#92400e }
    .b-blue{  background:#e0f2fe; color:#0369a1 }
    .b-green{ background:#dcfce7; color:#166534 }
    .b-slate{ background:#e2e8f0; color:#334155 }
    .b-red{   background:#fee2e2; color:#991b1b }
    @media print{
      .no-print{ display:none!important; }
      body{ background:#fff; color:#000; }
      a{ color:#000; text-decoration:none; }
      .card{ background:#fff; border:1px solid #e5e7eb; }
    }
  </style>
</head>
<body class="text-right">
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-6xl mx-auto px-4 py-6 grid lg:grid-cols-[260px,1fr] gap-6">

    <!-- الفهرس -->
    <aside class="card rounded-2xl p-4 h-max sticky top-4 no-print">
      <div class="flex items-center justify-between mb-3">
        <h2 class="font-bold">الفهرس</h2>
        <span class="badge">آخر تحديث: <?= date('Y-m-d') ?></span>
      </div>
      <nav class="toc space-y-1 text-sm">
        <a href="#overview">نظرة عامة</a>
        <a href="#roles">الصلاحيات</a>
        <a href="#columns">أعمدة الجدول</a>
        <a href="#status">الحالات (توضيح)</a>
        <a href="#actions">الإجراءات</a>
        <a href="#sql">مصدر البيانات</a>
        <a href="#perf">الأداء والترقيم</a>
        <a href="#security">الأمان والممارسات الجيدة</a>
        <a href="#improve">تحسينات مقترحة</a>
        <a href="#related">روابط ذات صلة</a>
        <a href="#contact">تواصل</a>
      </nav>

      <div class="mt-6 space-y-2">
        <button onclick="window.location.href='index.php'" class="w-full px-3 py-2 rounded bg-blue-600 text-white">فتح صفحة المخالصات</button>
        <button onclick="window.print()" class="w-full px-3 py-2 rounded bg-gray-600 text-white">طباعة</button>
      </div>

      <div class="mt-4">
        <label class="text-sm block mb-1">بحث داخل التعليمات</label>
        <input id="q" class="w-full rounded px-3 py-2 bg-white text-black" placeholder="اكتب كلمة بحث…">
        <small class="opacity-70">يبرز الكلمات المطابقة ويخفي الأقسام غير المطابقة.</small>
      </div>
    </aside>

    <!-- المحتوى -->
    <main class="space-y-6">

      <header id="overview" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h1 class="text-2xl font-bold">تعليمات صفحة <span class="opacity-90">“المخالصات”</span></h1>
          <a class="anchor" href="#overview">#overview</a>
        </div>
        <p class="opacity-90 mt-2">
          تعرِض الصفحة آخر 100 مخالصة مُسجَّلة، مع الكود والموظف والحالة وآخر يوم عمل وصافي المبلغ، بالإضافة إلى رابط فتح تفاصيل المخالصة.
        </p>
      </header>

      <section id="roles" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الصلاحيات</h2><a class="anchor" href="#roles">#roles</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>يفضّل تقييد الوصول إلى المخالصات لأدوار محددة (مثل: <b>المدير/المالية/الموارد البشرية</b>) عبر <span class="kbd">authorize.php</span>.</li>
          <li>الصفحة الحالية لا تحتوي تحقق صلاحيات ظاهر في الكود المعروض — يوصى بإضافته.</li>
        </ul>
      </section>

      <section id="columns" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">أعمدة الجدول</h2><a class="anchor" href="#columns">#columns</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>#</b> — معرف المخالصة <span class="kbd">settlements.id</span>.</li>
          <li><b>الكود</b> — <span class="kbd">settlements.code</span> (يوصى أن يكون فريدًا).</li>
          <li><b>الموظف</b> — الاسم من <span class="kbd">users.name</span>.</li>
          <li><b>الحالة</b> — من <span class="kbd">settlements.status</span> (تُعرض كنص حاليًا).</li>
          <li><b>آخر يوم</b> — <span class="kbd">settlements.last_working_day</span>.</li>
          <li><b>الصافي</b> — <span class="kbd">settlements.net_amount</span> مع تنسيق خانتين عشريتين.</li>
          <li><b>عرض</b> — رابط إلى <span class="kbd">view.php?id=…</span>.</li>
        </ul>
      </section>

      <section id="status" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الحالات (توضيح)</h2><a class="anchor" href="#status">#status</a></div>
        <p class="mt-2">
          قيم الحقل <span class="kbd">status</span> تعتمد على منطق نظامكم. أمثلة شائعة (للتوضيح فقط):
        </p>
        <p class="mt-2">
          <span class="chip b-amber">draft — مسودة</span>
          <span class="chip b-blue">hr_review — مراجعة الموارد</span>
          <span class="chip b-blue">finance_review — مراجعة المالية</span>
          <span class="chip b-green">approved/paid — معتمدة/مدفوعة</span>
          <span class="chip b-slate">closed — مغلقة</span>
          <span class="chip b-red">rejected — مرفوضة</span>
        </p>
        <div class="text-sm opacity-90 mt-2">
          يُنصح بعرض شارات ملوّنة بدل نص خام لزيادة الوضوح.
        </div>
      </section>

      <section id="actions" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الإجراءات</h2><a class="anchor" href="#actions">#actions</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><b>+ مخالصة جديدة:</b> يفتح <span class="kbd">create.php</span> لبدء مخالصة جديدة.</li>
          <li><b>فتح:</b> زر <span class="kbd">view.php?id=…</span> لعرض التفاصيل (والاعتماد/الإرفاقات حسب منطقكم).</li>
        </ul>
      </section>

      <section id="sql" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">مصدر البيانات</h2><a class="anchor" href="#sql">#sql</a></div>
        <p class="mt-2 text-sm">
          الاستعلام المستخدم (مختصرًا):
        </p>
        <pre class="kbd" style="display:block;white-space:pre-wrap">
SELECT s.id, s.code, s.status, s.last_working_day, s.net_amount, u.name AS emp_name
FROM settlements s
LEFT JOIN users u ON u.id = s.employee_id
ORDER BY s.id DESC
LIMIT 100
        </pre>
        <div class="text-sm opacity-90">
          <b>ملاحظة:</b> <span class="kbd">LIMIT 100</span> يعني قد لا تُعرض المخالصات الأقدم — افكر بترقيم الصفحات.
        </div>
      </section>

      <section id="perf" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأداء والترقيم</h2><a class="anchor" href="#perf">#perf</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li>أضف ترقيم صفحات (مثلاً: <span class="kbd">page, per_page</span>) بدل <span class="kbd">LIMIT ثابت</span>.</li>
          <li>فهارس مفيدة: <span class="kbd">settlements(employee_id, status, last_working_day)</span>.</li>
          <li>عند التصدير أو البحث، استخدم استعلامات مُحضَّرة (Prepared) لو فيه مُدخلات من المستخدم.</li>
        </ul>
      </section>

      <section id="security" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">الأمان والممارسات الجيدة</h2><a class="anchor" href="#security">#security</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>تحقق من الصلاحيات (أدوار HR/Finance/Admin) قبل السماح بالوصول.</li>
          <li>في <span class="kbd">view.php</span> تأكد من صحة <span class="kbd">id</span> والتحقق من ملكية السجل وصلاحية العرض.</li>
          <li>اعرض العملة بشكل واضح (مثلاً: SAR)، وراعِ التقريب.</li>
        </ul>
      </section>

      <section id="improve" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">تحسينات مقترحة</h2><a class="anchor" href="#improve">#improve</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-2">
          <li>إضافة فلاتر أعلى الجدول: الموظف، الحالة، نطاق التاريخ.</li>
          <li>تصدير CSV/Excel للنتائج المفلترة.</li>
          <li>إجماليات أعلى الجدول (عدد المخالصات، مجموع الصافي).</li>
          <li>شارات حالة ملوّنة بدل النص الخام.</li>
          <li>قيد فريد على <span class="kbd">settlements.code</span> لمنع التكرار.</li>
        </ul>
      </section>

      <section id="related" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between"><h2 class="text-xl font-bold">روابط ذات صلة</h2><a class="anchor" href="#related">#related</a></div>
        <ul class="list-disc pr-6 mt-2 space-y-1">
          <li><a class="underline" href="index.php">المخالصات</a></li>
          <li><a class="underline" href="create.php">إنشاء مخالصة</a></li>
          <li><a class="underline" href="view.php">عرض تفاصيل مخالصة</a></li>
        </ul>
      </section>

      <section id="contact" data-sec class="card rounded-2xl p-5">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-bold">خلّنا نتواصل</h2>
          <a class="anchor" href="#contact">#contact</a>
        </div>
        <div class="grid md:grid-cols-2 gap-6 mt-3 items-start">
          <form id="contactForm" class="grid gap-3">
            <input id="c_name"  class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text" placeholder="الاسم" required/>
            <input id="c_email" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
            <input id="c_phone" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
            <textarea id="c_msg" class="border rounded-xl p-3 bg-white text-black focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
            <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
            <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
          </form>
          <div>
            <h3 class="text-xl font-bold">بيانات التواصل</h3>
            <ul class="mt-3 space-y-2" style="color:var(--muted)">
              <li>الموقع: 98RL.LINK</li>
              <li>البريد: 98rl@98rl.link</li>
              <li>واتساب: +966535500241</li>
            </ul>
            <a href="https://wa.me/966535500241" target="_blank" rel="noopener"
               class="mt-4 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">
              تواصل واتساب مباشر
            </a>
          </div>
        </div>
      </section>

    </main>
  </div>

  <script>
    // بحث داخلي + تمييز
    const q   = document.getElementById('q');
    const secs= [...document.querySelectorAll('[data-sec]')];
    function clearMarks(root){
      root.querySelectorAll('.mark').forEach(m=>{
        const t=document.createTextNode(m.textContent); m.parentNode.replaceChild(t,m);
      });
    }
    function highlight(root,term){
      if(!term) return;
      const rx=new RegExp('('+term.replace(/[.*+?^${}()|[\\]\\\\]/g,'\\\\$&')+')','gi');
      root.querySelectorAll('p, li').forEach(node=>{
        node.childNodes.forEach(ch=>{
          if(ch.nodeType===Node.TEXT_NODE){
            const span=document.createElement('span');
            span.innerHTML=ch.textContent.replace(rx,'<mark class="mark">$1</mark>');
            if(span.innerHTML!==ch.textContent){ ch.parentNode.replaceChild(span,ch); }
          }
        });
      });
    }
    q && q.addEventListener('input',()=>{
      const term=q.value.trim();
      secs.forEach(s=>{
        clearMarks(s);
        if(!term){ s.style.display=''; return; }
        const hit=s.textContent.toLowerCase().includes(term.toLowerCase());
        s.style.display=hit?'':'none';
        if(hit) highlight(s,term);
      });
    });

    // واتساب مباشر
    (function(){
      const f=document.getElementById('contactForm');
      const r=document.getElementById('contactResult');
      const WA='966535500241';
      if(!f) return;
      f.addEventListener('submit',(e)=>{
        e.preventDefault();
        const name =document.getElementById('c_name').value.trim();
        const email=document.getElementById('c_email').value.trim();
        const phone=document.getElementById('c_phone').value.trim();
        const msg  =document.getElementById('c_msg').value.trim();
        if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
        const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
        const url=`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`;
        const w=window.open(url,'_blank'); if(w) w.opener=null;
        r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
      });
    })();
  </script>
</body>
</html>
