<?php
/* /erp_task_system/users/settlements/view.php */
session_start();
require_once '../../config/db.php';

$id = (int)($_GET['id'] ?? 0);
if($id<=0){ header('Location: index.php'); exit; }

$sett = $conn->prepare("SELECT s.*, u.name AS emp_name
                        FROM settlements s
                        LEFT JOIN users u ON u.id = s.employee_id
                        WHERE s.id=?");
$sett->execute([$id]);
$s = $sett->fetch(PDO::FETCH_ASSOC);
if(!$s){ header('Location: index.php'); exit; }

$items = $conn->prepare("SELECT * FROM settlement_items WHERE settlement_id=? ORDER BY id DESC");
$items->execute([$id]);
$rows = $items->fetchAll(PDO::FETCH_ASSOC);

$canEdit = ($s['status'] ?? '') === 'draft';
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title>مخالصة #<?= (int)$id ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 min-h-screen" data-can-edit="<?= $canEdit ? '1':'0' ?>">
  <div class="max-w-6xl mx-auto p-6">
    <a href="index.php" class="text-slate-600">&larr; رجوع</a>
    <h1 class="text-2xl font-bold mt-2 mb-4">
      مخالصة: <?= htmlspecialchars($s['code']) ?> — <?= htmlspecialchars($s['emp_name'] ?: 'موظف') ?>
    </h1>

    <div class="grid md:grid-cols-3 gap-4">
      <div class="bg-white rounded-xl shadow p-4">
        <div class="text-sm text-slate-500">الحالة</div>
        <div class="font-semibold"><?= htmlspecialchars($s['status']) ?></div>
        <div class="mt-2 text-sm text-slate-500">آخر يوم عمل</div>
        <div class="font-semibold"><?= htmlspecialchars($s['last_working_day'] ?? ($s['last_day'] ?? ($s['end_date'] ?? ''))) ?></div>
        <div class="mt-2 text-sm text-slate-500">تاريخ الاستحقاق</div>
        <div class="font-semibold"><?= htmlspecialchars($s['settlement_due_date'] ?? '') ?></div>
      </div>

      <div class="bg-white rounded-xl shadow p-4">
        <div class="text-sm text-slate-500">مجمل الإضافات</div>
        <div class="font-semibold"><?= number_format((float)($s['total_additions'] ?? 0),2) ?> ر.س</div>
        <div class="mt-2 text-sm text-slate-500">مجمل الخصومات</div>
        <div class="font-semibold"><?= number_format((float)($s['total_deductions'] ?? 0),2) ?> ر.س</div>
        <div class="mt-2 text-sm text-slate-500">الصافي</div>
        <div class="font-bold text-emerald-700 text-lg"><?= number_format((float)($s['net_amount'] ?? 0),2) ?> ر.س</div>
      </div>

      <div class="bg-white rounded-xl shadow p-4">
        <div class="text-sm text-slate-500">طريقة الصرف</div>
        <div class="font-semibold"><?= htmlspecialchars($s['pay_method'] ?? '') ?></div>
        <?php if(!empty($s['bank_iban_snapshot'])): ?>
          <div class="mt-2 text-sm text-slate-500">IBAN</div>
          <div class="font-mono text-sm"><?= htmlspecialchars($s['bank_iban_snapshot']) ?></div>
        <?php endif; ?>
      </div>
    </div>

<div class="bg-white rounded-xl shadow p-4 mb-4 mt-4">
  <h2 class="font-semibold mb-3">توليد البنود تلقائيًا</h2>
  <form id="genForm" class="grid md:grid-cols-4 gap-3">
    <input type="hidden" name="settlement_id" value="<?= (int)$id ?>">
    <div>
      <label class="block text-sm mb-1">أيام الإجازة المتبقية</label>
      <input type="number" step="0.5" name="leave_days" class="w-full border rounded p-2" placeholder="(يُقرأ من رصيد الموظف تلقائيًا إن تركته فاضي)" <?= $canEdit?'':'disabled' ?>>
    </div>
    <div>
      <label class="block text-sm mb-1">أيام راتب آخر شهر</label>
      <input type="number" step="1" name="last_salary_days" class="w-full border rounded p-2" placeholder="(يُحسب تلقائي من تاريخ آخر يوم)" <?= $canEdit?'':'disabled' ?>>
    </div>
    <div>
      <label class="block text-sm mb-1">أساس مكافأة (شهري)</label>
      <input type="number" step="0.01" name="eos_monthly_base" class="w-full border rounded p-2"
             value="<?= htmlspecialchars($s['basic_salary_snapshot'] ?? '') ?>" <?= $canEdit?'':'disabled' ?>>
      <p class="text-xs text-slate-500 mt-1">لو ودّك تحتسب على الأساسي+بدلات، اكتب المجموع هنا.</p>
    </div>

    <input type="hidden" name="include_deductions" id="include_deductions" value="0">
    <div class="flex items-end gap-2">
      <button type="button" id="btnGenNoDed" class="px-4 py-2 bg-emerald-600 text-white rounded w-1/2" <?= $canEdit?'':'disabled' ?>>
        توليد بدون خصومات
      </button>
      <button type="button" id="btnGenWithDed" class="px-4 py-2 bg-amber-600 text-white rounded w-1/2" <?= $canEdit?'':'disabled' ?>>
        توليد مع الخصومات
      </button>
    </div>
  </form>
  <div id="genMsg" class="text-sm mt-2"></div>
</div>

<script>
const genForm = document.getElementById('genForm');
const genMsg  = document.getElementById('genMsg');
const incDed  = document.getElementById('include_deductions');

async function postFormWith(flag){
  if(document.body.dataset.canEdit!=='1') return;
  incDed.value = flag ? '1' : '0';
  const fd = new FormData(genForm);
  const res = await fetch('api/generate_items.php', { method:'POST', body: fd });
  const j = await res.json();
  if(j.ok){ location.reload(); } else { genMsg.textContent = 'خطأ: '+(j.msg||''); }
}

document.getElementById('btnGenNoDed') .addEventListener('click', ()=>postFormWith(false));
document.getElementById('btnGenWithDed').addEventListener('click', ()=>postFormWith(true));
</script>

    <div class="mt-6 bg-white rounded-xl shadow p-4">
      <h2 class="font-semibold mb-3">إضافة بند</h2>
      <form id="itemForm" class="grid md:grid-cols-5 gap-3">
        <input type="hidden" name="settlement_id" value="<?= (int)$id ?>">
        <div>
          <label class="block text-sm mb-1">النوع</label>
          <select name="item_type" class="w-full border rounded p-2" <?= $canEdit?'':'disabled' ?>>
            <option value="addition">إضافة</option>
            <option value="deduction">خصم</option>
          </select>
        </div>
        <div>
          <label class="block text-sm mb-1">الكود</label>
          <select name="item_code" class="w-full border rounded p-2" <?= $canEdit?'':'disabled' ?>>
            <option value="LAST_SALARY">LAST_SALARY</option>
            <option value="LEAVE_PAYOUT">LEAVE_PAYOUT</option>
            <option value="EOS">EOS</option>
            <option value="HOUSING">HOUSING</option>
            <option value="TRANSPORT">TRANSPORT</option>
            <option value="OVERTIME">OVERTIME</option>
            <option value="OTHER_ALLOWANCE">OTHER_ALLOWANCE</option>
            <option value="ADVANCE_DED">ADVANCE_DED</option>
            <option value="ABSENCE_DED">ABSENCE_DED</option>
            <option value="PENALTY">PENALTY</option>
            <option value="GOSI_DED">GOSI_DED</option>
            <option value="OTHER_DED">OTHER_DED</option>
          </select>
        </div>
        <div class="md:col-span-2">
          <label class="block text-sm mb-1">التسمية</label>
          <input name="item_label" class="w-full border rounded p-2" required <?= $canEdit?'':'disabled' ?>>
        </div>
        <div>
          <label class="block text-sm mb-1">المبلغ</label>
          <input type="number" step="0.01" name="amount" class="w-full border rounded p-2" required <?= $canEdit?'':'disabled' ?>>
        </div>
        <div class="md:col-span-5">
          <button class="px-5 py-2 bg-slate-800 text-white rounded" <?= $canEdit?'':'disabled title="المخالصة مقفلة"' ?>>إضافة</button>
          <span id="itemMsg" class="text-sm ms-3"></span>
        </div>
      </form>

      <hr class="my-4">

      <h2 class="font-semibold mb-2">تفاصيل البنود</h2>
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead>
            <tr class="bg-slate-100">
              <th class="p-2">#</th>
              <th class="p-2">النوع</th>
              <th class="p-2">الكود</th>
              <th class="p-2">التسمية</th>
              <th class="p-2">المبلغ</th>
              <th class="p-2">المصدر</th>
              <th class="p-2">إجراء</th>
            </tr>
          </thead>
          <tbody id="itemsBody">
            <?php foreach($rows as $i): ?>
            <tr class="border-b">
              <td class="p-2"><?= (int)$i['id'] ?></td>
              <td class="p-2"><?= htmlspecialchars($i['item_type']) ?></td>
              <td class="p-2"><?= htmlspecialchars($i['item_code']) ?></td>
              <td class="p-2"><?= htmlspecialchars($i['label']) ?></td>
              <td class="p-2"><?= number_format((float)$i['amount'],2) ?></td>
              <td class="p-2"><?= htmlspecialchars($i['source'] ?? '') ?></td>
              <td class="p-2">
                <button data-id="<?= (int)$i['id'] ?>" class="delItem px-3 py-1 rounded text-white <?= $canEdit?'bg-rose-600':'bg-slate-300 cursor-not-allowed' ?>" <?= $canEdit?'':'disabled' ?>>حذف</button>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

<script>
function formToJson(form){ return new FormData(form); }

document.getElementById('itemForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  if(document.body.dataset.canEdit!=='1'){ return; }
  const fd = formToJson(e.target);
  const res = await fetch('api/add_item.php', { method:'POST', body:fd });
  const j = await res.json();
  const m = document.getElementById('itemMsg');
  if(j.ok){ location.reload(); } else { m.textContent = 'خطأ: '+(j.msg||''); }
});

document.querySelectorAll('.delItem').forEach(btn=>{
  btn.addEventListener('click', async ()=>{
    if(document.body.dataset.canEdit!=='1'){ return; }
    if(!confirm('حذف البند؟')) return;
    const itemId = btn.getAttribute('data-id');
    const sid = <?= (int)$id ?>;
    const body = new URLSearchParams({ settlement_id: sid, item_id: itemId });
    const res = await fetch('api/delete_item.php', {
      method:'POST',
      headers:{'Content-Type':'application/x-www-form-urlencoded'},
      body:String(body)
    });
    const j = await res.json();
    if(j.ok){ location.reload(); } else { alert('خطأ: '+(j.msg||'')); }
  });
});

document.getElementById('genForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  if(document.body.dataset.canEdit!=='1'){ return; }
  const fd = formToJson(e.target);
  const res = await fetch('api/generate_items.php', { method:'POST', body: fd });
  const j = await res.json();
  const m = document.getElementById('genMsg');
  if(j.ok){
    m.textContent = 'تم توليد البنود بنجاح';
    location.reload();
  }else{
    m.textContent = 'خطأ: ' + (j.msg || '');
  }
});
</script>

</body>
</html>
