<?php
require_once '../config/db.php';
require_once '../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: add_evaluation.php");
  exit;
}

// استلام البيانات من الفورم
$employee_id = $_POST['employee_id'] ?? null;
$evaluation_period = $_POST['evaluation_period'] ?? null;
$evaluation_date = $_POST['evaluation_date'] ?? null;
$discipline = $_POST['discipline'] ?? 0;
$work_quality = $_POST['work_quality'] ?? 0;
$task_completion = $_POST['task_completion'] ?? 0;
$collaboration = $_POST['collaboration'] ?? 0;
$self_development = $_POST['self_development'] ?? 0;
$manager_rating = $_POST['manager_rating'] ?? 0;
$comments = trim($_POST['comments'] ?? '');
$created_by = $_SESSION['user']['id'] ?? null;

// حساب المعدل
$total_score = round((
  $discipline +
  $work_quality +
  $task_completion +
  $collaboration +
  $self_development +
  $manager_rating
) / 6, 2);

// حساب بداية ونهاية الفترة حسب نوع التقييم
$end_date = $evaluation_date;
$start_date = date('Y-m-d', strtotime($evaluation_period === 'monthly' ? '-1 month' : '-6 months', strtotime($evaluation_date)));

// كود اللون الأخضر للمراحل المكتملة
$completed_stage_color = '#10b981';

// جلب كل أرقام المراحل المكتملة (لونها أخضر)
$stmt = $conn->prepare("SELECT id FROM stages WHERE color = ?");
$stmt->execute([$completed_stage_color]);
$completed_stages = $stmt->fetchAll(PDO::FETCH_COLUMN);

if ($completed_stages && count($completed_stages) > 0) {
    // بناء علامات استفهام بعدد المراحل المكتملة
    $in = str_repeat('?,', count($completed_stages) - 1) . '?';

    // 1. نسبة الإنجاز العام (كل المهام اللي أُنشئت في الفترة)
    $params = array_merge($completed_stages, [$employee_id, $start_date, $end_date]);
    $task_stmt = $conn->prepare("
      SELECT COUNT(*) as total,
             SUM(CASE WHEN stage_id IN ($in) THEN 1 ELSE 0 END) as completed
      FROM tasks
      WHERE assigned_to = ? AND created_at BETWEEN ? AND ?
    ");
    $task_stmt->execute($params);
    $task_data = $task_stmt->fetch(PDO::FETCH_ASSOC);

    $total_tasks = $task_data['total'] ?? 0;
    $completed_tasks = $task_data['completed'] ?? 0;
    $completion_rate = $total_tasks > 0 ? round(($completed_tasks / $total_tasks) * 100, 1) : 0;

    // 2. عدد المهام المكتملة فعليًا خلال الفترة (اكتملت خلال الفترة)
    $params2 = array_merge([$employee_id], $completed_stages, [$start_date, $end_date]);
    $in2 = str_repeat('?,', count($completed_stages) - 1) . '?';
    $done_stmt = $conn->prepare("
      SELECT COUNT(*) as completed_in_period
      FROM tasks
      WHERE assigned_to = ? AND stage_id IN ($in2) AND completed_at BETWEEN ? AND ?
    ");
    $done_stmt->execute($params2);
    $done_tasks = $done_stmt->fetch(PDO::FETCH_ASSOC);
    $completed_in_period = $done_tasks['completed_in_period'] ?? 0;
} else {
    $total_tasks = 0;
    $completed_tasks = 0;
    $completion_rate = 0;
    $completed_in_period = 0;
}

// كشف القيم للتأكد (أحذف السطرين بعد التأكد)


// استعلام الإدخال (بدون تخزين completed_in_period لأن الجدول ما فيه العمود هذا)
$stmt = $conn->prepare("INSERT INTO employee_evaluations 
  (employee_id, evaluation_period, evaluation_date, discipline, work_quality, task_completion, collaboration, self_development, manager_rating, comments, total_score, created_by, task_completion_rate)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$success = $stmt->execute([
  $employee_id, $evaluation_period, $evaluation_date,
  $discipline, $work_quality, $task_completion, $collaboration, $self_development, $manager_rating,
  $comments, $total_score, $created_by, $completion_rate
]);

if ($success) {
  header("Location: add_evaluation.php?success=1");
  exit;
} else {
  echo "❌ حصل خطأ أثناء حفظ التقييم.";
}
